/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.lucene.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchHelper {
    private static final Logger logger = LoggerFactory.getLogger(SearchHelper.class);

    SearchHelper() {
    }

    public static Iterable<? extends IndexableField> createSimpleDoc(String value) {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("datacleaner_search_field", value, Field.Store.YES));
        return doc;
    }

    public static TopDocs search(IndexSearcher indexSearcher, String searchText) {
        TopDocs searchResult;
        Query query;
        if (StringUtils.isNullOrEmpty((String)searchText)) {
            return null;
        }
        try {
            SimpleAnalyzer analyzer = new SimpleAnalyzer(Constants.VERSION);
            QueryParser queryParser = new QueryParser(Constants.VERSION, "datacleaner_search_field", (Analyzer)analyzer);
            query = queryParser.parse(searchText);
        }
        catch (ParseException e) {
            logger.error("An error occurred while parsing query: " + searchText, (Throwable)e);
            return null;
        }
        try {
            searchResult = indexSearcher.search(query, 1);
        }
        catch (IOException e) {
            throw new IllegalStateException("Searching index threw exception", e);
        }
        return searchResult;
    }
}

