/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.metamodel.util.Action;
import org.eobjects.datacleaner.lucene.SearchIndex;

final class WriteSearchIndexAction
implements Action<Iterable<Object[]>> {
    private final SearchIndex _searchIndex;
    private final String[] _fields;

    public WriteSearchIndexAction(SearchIndex searchIndex, String[] fields) {
        this._searchIndex = searchIndex;
        this._fields = fields;
    }

    public void run(final Iterable<Object[]> iterable) throws Exception {
        this._searchIndex.write(new Action<IndexWriter>(){

            public void run(IndexWriter writer) throws Exception {
                for (Object[] rowData : iterable) {
                    StringBuilder searchText = new StringBuilder();
                    Document doc = new Document();
                    for (int i = 0; i < rowData.length; ++i) {
                        Object value = rowData[i];
                        if (value == null) continue;
                        String field = WriteSearchIndexAction.this._fields[i];
                        String stringValue = value.toString().trim();
                        if (searchText.length() != 0) {
                            searchText.append(' ');
                        }
                        searchText.append(stringValue);
                        doc.add((IndexableField)new StringField(field, stringValue, Field.Store.YES));
                    }
                    doc.add((IndexableField)new TextField("datacleaner_search_field", searchText.toString(), Field.Store.NO));
                    writer.addDocument((Iterable)doc);
                }
            }
        });
    }
}

