/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.metamodel.util.FileHelper;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.lucene.FileSystemSearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.ui.Images;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class ConfigureSearchIndexPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final UserPreferences _userPreferences;
    private final JXTextField _nameTextField;
    private final JXTextField _descriptionTextField;
    private final JRadioButton _storageDatastoreFolderRadio;
    private final JRadioButton _storageTempFolderRadio;

    public ConfigureSearchIndexPanel(UserPreferences userPreferences, SearchIndex existingSearchIndex) {
        super(Images.WATERMARK_IMAGE, 95, 10);
        this._userPreferences = userPreferences;
        this.setTitledBorder("Search index properties");
        this._nameTextField = WidgetFactory.createTextField((String)"Search index name");
        this._descriptionTextField = WidgetFactory.createTextField((String)"Description");
        int row = 0;
        WidgetUtils.addToGridBag((Component)DCLabel.dark((String)"Name:"), (JPanel)((Object)this), (int)0, (int)row);
        WidgetUtils.addToGridBag((Component)this._nameTextField, (JPanel)((Object)this), (int)1, (int)row);
        WidgetUtils.addToGridBag((Component)DCLabel.dark((String)"Description:"), (JPanel)((Object)this), (int)0, (int)(++row));
        WidgetUtils.addToGridBag((Component)this._descriptionTextField, (JPanel)((Object)this), (int)1, (int)row);
        WidgetUtils.addToGridBag((Component)DCLabel.dark((String)"Storage:"), (JPanel)((Object)this), (int)0, (int)(++row));
        this._storageDatastoreFolderRadio = new JRadioButton("DataCleaner's datastore folder", true);
        this._storageDatastoreFolderRadio.setOpaque(false);
        this._storageTempFolderRadio = new JRadioButton("My computer's temp folder", false);
        this._storageTempFolderRadio.setOpaque(false);
        DCPanel radioPanel = new DCPanel();
        radioPanel.setLayout((LayoutManager)new VerticalLayout(2));
        radioPanel.add((Component)this._storageDatastoreFolderRadio);
        radioPanel.add((Component)this._storageTempFolderRadio);
        WidgetUtils.addToGridBag((Component)radioPanel, (JPanel)((Object)this), (int)1, (int)row);
        ButtonGroup group = new ButtonGroup();
        group.add(this._storageDatastoreFolderRadio);
        group.add(this._storageTempFolderRadio);
        if (existingSearchIndex != null) {
            this._nameTextField.setEnabled(false);
            this._nameTextField.setText(existingSearchIndex.getName());
            this._descriptionTextField.setText(existingSearchIndex.getDescription());
            if (existingSearchIndex instanceof FileSystemSearchIndex) {
                File file = ((FileSystemSearchIndex)existingSearchIndex).getFile();
                if (FileHelper.getTempDir().equals(file)) {
                    this._storageTempFolderRadio.setSelected(true);
                }
                this._storageDatastoreFolderRadio.setEnabled(false);
                this._storageTempFolderRadio.setEnabled(false);
            }
        }
    }

    public SearchIndex createSearchIndex() {
        String name = this._nameTextField.getText();
        if (StringUtils.isNullOrEmpty((String)name)) {
            WidgetUtils.showErrorMessage((String)"No search index name", (String)"Please fill in a search index name!", null);
            return null;
        }
        File parentFolder = this._storageDatastoreFolderRadio.isSelected() ? this._userPreferences.getSaveDatastoreDirectory() : FileHelper.getTempDir();
        File folder = new File(parentFolder, "lucene." + name);
        folder.mkdirs();
        FileSystemSearchIndex searchIndex = new FileSystemSearchIndex(name, folder);
        return searchIndex;
    }
}

