/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.ui.ConfigureSearchIndexPanel;
import org.eobjects.datacleaner.lucene.ui.Images;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.windows.AbstractDialog;

public class ConfigureSearchIndicesDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final SearchIndexCatalog _catalog;
    private final UserPreferences _userPreferences;
    private final DCComboBox<String> _comboBox;
    private final SearchIndex _existingSearchIndex;

    public ConfigureSearchIndicesDialog(WindowContext windowContext, SearchIndexCatalog catalog, UserPreferences userPreferences, DCComboBox<String> comboBox) {
        this(windowContext, catalog, userPreferences, comboBox, null);
    }

    public ConfigureSearchIndicesDialog(WindowContext windowContext, SearchIndexCatalog catalog, UserPreferences userPreferences, DCComboBox<String> comboBox, SearchIndex searchIndex) {
        super(windowContext, Images.BANNER_IMAGE);
        this._catalog = catalog;
        this._userPreferences = userPreferences;
        this._comboBox = comboBox;
        this._existingSearchIndex = searchIndex;
    }

    public String getWindowTitle() {
        return "Configure search indices";
    }

    protected String getBannerTitle() {
        return "Search indices\nPowered by Apache Lucene";
    }

    protected int getDialogWidth() {
        return 500;
    }

    protected JComponent getDialogContent() {
        final ConfigureSearchIndexPanel configureSearchIndexPanel = new ConfigureSearchIndexPanel(this._userPreferences, this._existingSearchIndex);
        ImageIcon saveIcon = ImageManager.getInstance().getImageIcon("images/actions/save.png", new ClassLoader[0]);
        JButton saveButton = WidgetFactory.createButton((String)"Save", (Icon)saveIcon);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchIndex searchIndex = configureSearchIndexPanel.createSearchIndex();
                if (searchIndex == null) {
                    return;
                }
                if (ConfigureSearchIndicesDialog.this._existingSearchIndex != null) {
                    ConfigureSearchIndicesDialog.this._catalog.removeSearchIndex(ConfigureSearchIndicesDialog.this._existingSearchIndex);
                }
                ConfigureSearchIndicesDialog.this._catalog.addSearchIndex(searchIndex);
                ConfigureSearchIndicesDialog.this._comboBox.setSelectedItem((Object)searchIndex.getName());
                ConfigureSearchIndicesDialog.this.dispose();
            }
        });
        CloseableTabbedPane tabbedPane = new CloseableTabbedPane();
        tabbedPane.addTab("Configure search index", (Icon)ImageManager.getInstance().getImageIcon("images/menu/options.png", new ClassLoader[0]), (Component)((Object)configureSearchIndexPanel));
        tabbedPane.setUnclosableTab(0);
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(saveButton);
        DCPanel toolBarPanel = new DCPanel(WidgetUtils.BG_COLOR_DARKEST, WidgetUtils.BG_COLOR_DARKEST);
        toolBarPanel.setLayout((LayoutManager)new BorderLayout());
        toolBarPanel.add((Component)toolBar, (Object)"Center");
        DCPanel panel = new DCPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.setPreferredSize(this.getDialogWidth(), 360);
        panel.add((Component)tabbedPane, (Object)"Center");
        panel.add((Component)toolBarPanel, (Object)"South");
        return panel;
    }
}

