/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.ui.Images;
import org.eobjects.datacleaner.lucene.ui.SingleSearchIndexPropertyWidget;
import org.eobjects.datacleaner.panels.AnalyzerJobBuilderPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.widgets.properties.MultipleMappedStringsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;

public class WriteSearchIndexAnalyzerJobBuilderPanel
extends AnalyzerJobBuilderPanel {
    private static final long serialVersionUID = 1L;
    private final ConfiguredPropertyDescriptor _fieldNamesProperty;
    private final ConfiguredPropertyDescriptor _inputColumnsProperty;
    private final MultipleMappedStringsPropertyWidget _mappedFieldsPropertyWidget;
    private final SearchIndexCatalog _catalog;
    private final WindowContext _windowContext;
    private final UserPreferences _userPreferences;

    public WriteSearchIndexAnalyzerJobBuilderPanel(AnalyzerJobBuilder<?> analyzerJobBuilder, PropertyWidgetFactory propertyWidgetFactory, SearchIndexCatalog catalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(Images.WATERMARK_IMAGE, 95, 95, analyzerJobBuilder, true, propertyWidgetFactory);
        this._catalog = catalog;
        this._windowContext = windowContext;
        this._userPreferences = userPreferences;
        this._inputColumnsProperty = (ConfiguredPropertyDescriptor)((AnalyzerBeanDescriptor)analyzerJobBuilder.getDescriptor()).getConfiguredPropertiesByType(InputColumn[].class, false).iterator().next();
        this._fieldNamesProperty = (ConfiguredPropertyDescriptor)((AnalyzerBeanDescriptor)analyzerJobBuilder.getDescriptor()).getConfiguredPropertiesByType(String[].class, false).iterator().next();
        this._mappedFieldsPropertyWidget = new MultipleMappedStringsPropertyWidget((AbstractBeanJobBuilder)analyzerJobBuilder, this._inputColumnsProperty, this._fieldNamesProperty){

            protected String getDefaultMappedString(InputColumn<?> inputColumn) {
                return inputColumn.getName();
            }
        };
    }

    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == this._inputColumnsProperty) {
            return this._mappedFieldsPropertyWidget;
        }
        if (propertyDescriptor == this._fieldNamesProperty) {
            return this._mappedFieldsPropertyWidget.getMappedStringsPropertyWidget();
        }
        if (propertyDescriptor.getBaseType() == SearchIndex.class) {
            return new SingleSearchIndexPropertyWidget(beanJobBuilder, propertyDescriptor, this._catalog, this._windowContext, this._userPreferences);
        }
        return super.createPropertyWidget(beanJobBuilder, propertyDescriptor);
    }
}

