/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.beans.stringpattern.PatternFinder;
import org.datacleaner.beans.stringpattern.ReverseTokenizer;
import org.datacleaner.beans.stringpattern.TokenPattern;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;

public class ReversePatternFinder
extends PatternFinder<String> {
    private final HashMap<TokenPattern, AtomicInteger> _patternCounts = new HashMap();
    private final HashMap<TokenPattern, String> _patternSamples = new HashMap();

    public ReversePatternFinder(TokenizerConfiguration configuration) {
        super(new ReverseTokenizer(configuration), configuration);
    }

    @Override
    protected void storeNewPattern(TokenPattern pattern, String sample, String originalPattern, int distinctCount) {
        AtomicInteger counter = new AtomicInteger(distinctCount);
        this._patternCounts.put(pattern, counter);
        this._patternSamples.put(pattern, sample);
    }

    @Override
    protected void storeMatch(TokenPattern pattern, String sample, String originalPattern, int distinctCount) {
        AtomicInteger counter = this._patternCounts.get(pattern);
        counter.addAndGet(distinctCount);
    }

    public HashMap<TokenPattern, AtomicInteger> getPatternCounts() {
        return this._patternCounts;
    }

    public String getSample(TokenPattern pattern) {
        return this._patternSamples.get(pattern);
    }
}

