/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datacleaner.beans.stringpattern.PatternFinderResult;
import org.datacleaner.result.Crosstab;
import org.datacleaner.result.html.BodyElement;
import org.datacleaner.result.html.HeadElement;
import org.datacleaner.result.html.HtmlFragment;
import org.datacleaner.result.html.HtmlRenderingContext;
import org.datacleaner.result.html.SimpleHtmlFragment;
import org.datacleaner.result.renderer.CrosstabHtmlRenderer;
import org.datacleaner.result.renderer.RendererFactory;

class PatternFinderHtmlFragment
implements HtmlFragment {
    private final PatternFinderResult _result;
    private final RendererFactory _rendererFactory;
    private final SimpleHtmlFragment _htmlFragment;

    public PatternFinderHtmlFragment(PatternFinderResult result, RendererFactory rendererFactory) {
        this._result = result;
        this._rendererFactory = rendererFactory;
        this._htmlFragment = new SimpleHtmlFragment();
    }

    public void initialize(HtmlRenderingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"patternFinderResultContainer\">");
        if (this._result.isGroupingEnabled()) {
            Map<String, Crosstab<?>> crosstabs = this._result.getGroupedCrosstabs();
            if (crosstabs.isEmpty()) {
                this._htmlFragment.addBodyElement("<p>No patterns found</p>");
                return;
            }
            Set<Map.Entry<String, Crosstab<?>>> crosstabEntries = crosstabs.entrySet();
            for (Map.Entry<String, Crosstab<?>> entry : crosstabEntries) {
                String group = entry.getKey();
                Crosstab<?> crosstab = entry.getValue();
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append("<h3>Patterns for group: ");
                sb.append(context.escapeHtml(group));
                sb.append("</h3>");
                sb.append("<div class=\"patternFinderResultPanel\">");
                this.append(sb, crosstab, context);
                sb.append("</div>");
            }
        } else {
            Crosstab<?> crosstab = this._result.getSingleCrosstab();
            sb.append("<div class=\"patternFinderResultPanel\">");
            this.append(sb, crosstab, context);
            sb.append("</div>");
        }
        sb.append("</div>");
        this._htmlFragment.addBodyElement(sb.toString());
    }

    private void append(StringBuilder sb, Crosstab<?> crosstab, HtmlRenderingContext context) {
        CrosstabHtmlRenderer crosstabHtmlRenderer = new CrosstabHtmlRenderer(this._rendererFactory);
        HtmlFragment renderedResult = crosstabHtmlRenderer.render(crosstab);
        renderedResult.initialize(context);
        List bodyElements = renderedResult.getBodyElements();
        for (BodyElement bodyElement : bodyElements) {
            sb.append(bodyElement.toHtml(context));
        }
        List headElements = renderedResult.getHeadElements();
        for (HeadElement headElement : headElements) {
            this._htmlFragment.addHeadElement(headElement);
        }
    }

    public List<HeadElement> getHeadElements() {
        return this._htmlFragment.getHeadElements();
    }

    public List<BodyElement> getBodyElements() {
        return this._htmlFragment.getBodyElements();
    }
}

