/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Metric;
import org.datacleaner.beans.stringpattern.PatternFinderResultReducer;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;
import org.datacleaner.reference.SimpleStringPattern;
import org.datacleaner.result.Crosstab;
import org.datacleaner.result.CrosstabDimension;
import org.datacleaner.result.QueryParameterizableMetric;

@Distributed(reducer=PatternFinderResultReducer.class)
public class PatternFinderResult
implements AnalyzerResult {
    private static final long serialVersionUID = 1L;
    private final InputColumn<String> _column;
    private final InputColumn<String> _groupColumn;
    private final Map<String, Crosstab<?>> _crosstabs;
    private final TokenizerConfiguration _tokenizerConfiguration;

    public PatternFinderResult(InputColumn<String> column, Crosstab<?> crosstab, TokenizerConfiguration tokenizerConfiguration) {
        this._column = column;
        this._groupColumn = null;
        this._crosstabs = new HashMap();
        this._crosstabs.put(null, crosstab);
        this._tokenizerConfiguration = tokenizerConfiguration;
    }

    public PatternFinderResult(InputColumn<String> column, InputColumn<String> groupColumn, Map<String, Crosstab<?>> crosstabs, TokenizerConfiguration tokenizerConfiguration) {
        this._column = column;
        this._groupColumn = groupColumn;
        this._crosstabs = crosstabs;
        this._tokenizerConfiguration = tokenizerConfiguration;
    }

    public TokenizerConfiguration getTokenizerConfiguration() {
        return this._tokenizerConfiguration;
    }

    public InputColumn<String> getColumn() {
        return this._column;
    }

    public InputColumn<String> getGroupColumn() {
        return this._groupColumn;
    }

    public Map<String, Crosstab<?>> getGroupedCrosstabs() {
        if (!this.isGroupingEnabled()) {
            throw new IllegalStateException("This result is not a grouped crosstab based Pattern Finder result");
        }
        return this._crosstabs;
    }

    public Crosstab<?> getSingleCrosstab() {
        if (this.isGroupingEnabled()) {
            throw new IllegalStateException("This result is not a single crosstab based Pattern Finder result");
        }
        return this._crosstabs.get(null);
    }

    public boolean isGroupingEnabled() {
        return this._groupColumn != null;
    }

    @Metric(value="Match count", supportsInClause=true)
    public QueryParameterizableMetric getMatchCount() {
        return new QueryParameterizableMetric(){

            protected int getInstanceCount(String instance) {
                return PatternFinderResult.this.getMatchCount(instance);
            }

            protected int getTotalCount() {
                return PatternFinderResult.this.getTotalCount();
            }

            public Collection<String> getParameterSuggestions() {
                Crosstab<?> crosstab = PatternFinderResult.this.getSingleCrosstab();
                CrosstabDimension patternDimension = crosstab.getDimension("Pattern");
                List categories = patternDimension.getCategories();
                return categories;
            }
        };
    }

    private int getTotalCount() {
        int sum = 0;
        Crosstab<?> crosstab = this.getSingleCrosstab();
        CrosstabDimension patternDimension = crosstab.getDimension("Pattern");
        List categories = patternDimension.getCategories();
        for (String category : categories) {
            Serializable value = crosstab.where(patternDimension, category).where("Measures", "Match count").get();
            if (!(value instanceof Number)) continue;
            sum += ((Number)value).intValue();
        }
        return sum;
    }

    public int getMatchCount(String pattern) {
        Crosstab<?> crosstab = this.getSingleCrosstab();
        CrosstabDimension patternDimension = crosstab.getDimension("Pattern");
        List categories = patternDimension.getCategories();
        for (String category : categories) {
            Serializable value;
            SimpleStringPattern stringPattern = new SimpleStringPattern(category, category, this._tokenizerConfiguration);
            if (!stringPattern.matches(pattern) || !((value = crosstab.where(patternDimension, category).where("Measures", "Match count").get()) instanceof Number)) continue;
            return ((Number)value).intValue();
        }
        return 0;
    }

    @Metric(value="Pattern count")
    public int getPatternCount() {
        return this.getSingleCrosstab().getDimension("Pattern").getCategoryCount();
    }
}

