/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.Map;
import java.util.Set;
import org.datacleaner.api.RendererBean;
import org.datacleaner.beans.stringpattern.PatternFinderResult;
import org.datacleaner.result.Crosstab;
import org.datacleaner.result.renderer.AbstractRenderer;
import org.datacleaner.result.renderer.CrosstabTextRenderer;
import org.datacleaner.result.renderer.TextRenderingFormat;

@RendererBean(value=TextRenderingFormat.class)
public class PatternFinderResultTextRenderer
extends AbstractRenderer<PatternFinderResult, String> {
    public String render(PatternFinderResult result) {
        CrosstabTextRenderer crosstabTextRenderer = new CrosstabTextRenderer();
        if (result.isGroupingEnabled()) {
            Map<String, Crosstab<?>> crosstabs = result.getGroupedCrosstabs();
            if (crosstabs.isEmpty()) {
                return "No patterns found";
            }
            Set<Map.Entry<String, Crosstab<?>>> crosstabEntries = crosstabs.entrySet();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Crosstab<?>> entry : crosstabEntries) {
                String group = entry.getKey();
                Crosstab<?> crosstab = entry.getValue();
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append("Patterns for group: ");
                sb.append(group);
                sb.append('\n');
                sb.append(crosstabTextRenderer.render(crosstab));
            }
            return sb.toString();
        }
        Crosstab<?> crosstab = result.getSingleCrosstab();
        return crosstabTextRenderer.render(crosstab);
    }
}

