/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.Arrays;
import org.apache.metamodel.util.EqualsBuilder;
import org.datacleaner.beans.stringpattern.PredefinedToken;
import org.datacleaner.beans.stringpattern.Token;
import org.datacleaner.beans.stringpattern.TokenPatternSymbol;
import org.datacleaner.beans.stringpattern.TokenType;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;

public class TokenPatternSymbolImpl
implements TokenPatternSymbol {
    private static final long serialVersionUID = 1L;
    private final TokenType _tokenType;
    private int _length;
    private boolean _upperCaseOnly = false;
    private boolean _lowerCaseOnly = false;
    private boolean _negative = false;
    private boolean _decimal = false;
    private char _decimalSeparator;
    private char _minusSign;
    private String _symbolicString;

    public TokenPatternSymbolImpl(Token prototypeToken, TokenizerConfiguration configuration) {
        this._tokenType = prototypeToken.getType();
        this._length = prototypeToken.length();
        switch (this._tokenType) {
            case TEXT: {
                if (!configuration.isDiscriminateTextCase()) break;
                this._upperCaseOnly = Character.isUpperCase(prototypeToken.charAt(0));
                this._lowerCaseOnly = !this._upperCaseOnly;
                break;
            }
            case NUMBER: {
                Character minusSign;
                Character decimalSeparator;
                if (configuration.isDiscriminateDecimalNumbers() && (decimalSeparator = configuration.getDecimalSeparator()) != null) {
                    this._decimalSeparator = decimalSeparator.charValue();
                    boolean bl = this._decimal = prototypeToken.getString().indexOf(this._decimalSeparator) != -1;
                }
                if (!configuration.isDiscriminateNegativeNumbers() || (minusSign = configuration.getMinusSign()) == null) break;
                this._minusSign = minusSign.charValue();
                this._negative = this._minusSign == prototypeToken.charAt(0);
                break;
            }
            case DELIM: {
                this._symbolicString = prototypeToken.getString();
                break;
            }
            case WHITESPACE: {
                if (!configuration.isDiscriminateWhiteSpaces()) break;
                this._symbolicString = prototypeToken.getString();
                break;
            }
            case PREDEFINED: {
                if (prototypeToken instanceof PredefinedToken) {
                    PredefinedToken pt = (PredefinedToken)prototypeToken;
                    this._symbolicString = '[' + pt.getPredefinedTokenDefintion().getName() + ']';
                    break;
                }
                this._symbolicString = prototypeToken.getString();
                break;
            }
            case MIXED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported token type: " + (Object)((Object)this._tokenType));
            }
        }
    }

    @Override
    public String toSymbolicString() {
        if (this._symbolicString != null) {
            return this._symbolicString;
        }
        char c = this.getSymbolicChar();
        char[] result = new char[this._length];
        Arrays.fill(result, c);
        if (this.isNegative()) {
            result[0] = this._minusSign;
        }
        if (this.isDecimal()) {
            result[this._length - 2] = this._decimalSeparator;
        }
        return String.valueOf(result);
    }

    private char getSymbolicChar() {
        switch (this._tokenType) {
            case TEXT: {
                if (this.isUpperCaseOnly()) {
                    return 'A';
                }
                return 'a';
            }
            case NUMBER: {
                return '#';
            }
            case WHITESPACE: {
                return ' ';
            }
            case MIXED: {
                return '?';
            }
        }
        throw new UnsupportedOperationException("No symbolic char for token type: " + (Object)((Object)this._tokenType));
    }

    @Override
    public TokenType getTokenType() {
        return this._tokenType;
    }

    @Override
    public boolean isUpperCaseOnly() {
        return this._upperCaseOnly;
    }

    @Override
    public boolean isLowerCaseOnly() {
        return this._lowerCaseOnly;
    }

    @Override
    public boolean isDecimal() {
        return this._decimal;
    }

    @Override
    public boolean isNegative() {
        return this._negative;
    }

    @Override
    public boolean matches(Token token, TokenizerConfiguration configuration) {
        if (EqualsBuilder.equals((Object)((Object)this._tokenType), (Object)((Object)token.getType()))) {
            if (configuration.isDistriminateTokenLength(this._tokenType) && this.toSymbolicString().length() != token.getString().length()) {
                return false;
            }
            switch (this._tokenType) {
                case TEXT: {
                    return this.matchesText(token, configuration);
                }
                case NUMBER: {
                    return this.matchesNumber(token, configuration);
                }
                case DELIM: {
                    return this.matchesDelim(token, configuration);
                }
                case WHITESPACE: {
                    return this.matchesWhitespace(token, configuration);
                }
                case MIXED: {
                    return this.matchesMixed(token, configuration);
                }
                case PREDEFINED: {
                    return this.matchesPredefined(token);
                }
            }
            throw new UnsupportedOperationException("Unsupported token type for matching: " + (Object)((Object)this._tokenType));
        }
        return false;
    }

    private boolean matchesPredefined(Token token) {
        if (token instanceof PredefinedToken) {
            PredefinedToken pt = (PredefinedToken)token;
            String name = pt.getPredefinedTokenDefintion().getName();
            return this._symbolicString.equals('[' + name + ']');
        }
        return this._symbolicString.equals(token.getString());
    }

    private boolean matchesText(Token token, TokenizerConfiguration configuration) {
        boolean discriminateTextCase = configuration.isDiscriminateTextCase();
        if (discriminateTextCase) {
            boolean caseMatches;
            String str2 = token.getString();
            char char2 = str2.charAt(0);
            boolean upperCase = Character.isUpperCase(char2);
            boolean bl = caseMatches = this.isUpperCaseOnly() == upperCase;
            if (!caseMatches) {
                return false;
            }
            if (upperCase && !configuration.isUpperCaseExpandable()) {
                return str2.length() == this._length;
            }
            if (!upperCase && !configuration.isLowerCaseExpandable()) {
                return str2.length() == this._length;
            }
            return true;
        }
        return true;
    }

    private boolean matchesNumber(Token token, TokenizerConfiguration configuration) {
        boolean negative2;
        boolean negative1;
        boolean discriminateNegativeNumbers = configuration.isDiscriminateNegativeNumbers();
        boolean discriminateDecimalNumbers = configuration.isDiscriminateDecimalNumbers();
        if (!discriminateDecimalNumbers && !discriminateNegativeNumbers) {
            return true;
        }
        String str2 = token.getString();
        Character minusSign = configuration.getMinusSign();
        if (discriminateNegativeNumbers && minusSign != null && (negative1 = this.isNegative()) != (negative2 = EqualsBuilder.equals((Object)minusSign, (Object)Character.valueOf(str2.charAt(0))))) {
            return false;
        }
        Character decimalSeparator = configuration.getDecimalSeparator();
        if (discriminateDecimalNumbers && decimalSeparator != null) {
            boolean decimal2;
            boolean decimal1 = this.isDecimal();
            boolean bl = decimal2 = str2.indexOf(decimalSeparator.charValue()) != -1;
            if (decimal1 != decimal2) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesDelim(Token token, TokenizerConfiguration configuration) {
        return this.toSymbolicString().equals(token.getString());
    }

    private boolean matchesWhitespace(Token token, TokenizerConfiguration configuration) {
        if (configuration.isDiscriminateWhiteSpaces()) {
            return this.toSymbolicString().equals(token.getString());
        }
        return true;
    }

    private boolean matchesMixed(Token token, TokenizerConfiguration configuration) {
        return true;
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public boolean isExpandable() {
        return this._symbolicString == null;
    }

    @Override
    public void expandLenght(int amount) {
        this._length += amount;
    }
}

