/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.datacleaner.beans.stringpattern.DefaultTokenizer;
import org.datacleaner.beans.stringpattern.Token;
import org.datacleaner.beans.stringpattern.TokenPattern;
import org.datacleaner.beans.stringpattern.TokenPatternImpl;
import org.datacleaner.beans.stringpattern.Tokenizer;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.StringPatternConnection;
import org.datacleaner.util.ReadObjectBuilder;

public final class SimpleStringPattern
extends AbstractReferenceData
implements StringPattern {
    private static final long serialVersionUID = 1L;
    private final String _expression;
    private transient TokenPattern _tokenPattern;
    private transient DefaultTokenizer _tokenizer;
    private transient TokenizerConfiguration _configuration;

    public SimpleStringPattern(String name, String expression) {
        this(name, expression, new TokenizerConfiguration());
    }

    public SimpleStringPattern(String name, String expression, TokenizerConfiguration configuration) {
        super(name);
        this._expression = expression;
        this._configuration = configuration;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create((Serializable)((Object)this), SimpleStringPattern.class).readObject(stream);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            SimpleStringPattern other = (SimpleStringPattern)((Object)obj);
            return Objects.equals(this._expression, other._expression);
        }
        return false;
    }

    public boolean matches(String string) {
        List<Token> tokens = this.getTokenizer().tokenize(string);
        return this.getTokenPattern().match(tokens);
    }

    public StringPatternConnection openConnection(DataCleanerConfiguration configuration) {
        return new StringPatternConnection(){

            public boolean matches(String string) {
                return SimpleStringPattern.this.matches(string);
            }

            public void close() {
            }
        };
    }

    private Tokenizer getTokenizer() {
        if (this._tokenizer == null) {
            this._tokenizer = new DefaultTokenizer(this.getConfiguration());
        }
        return this._tokenizer;
    }

    private TokenizerConfiguration getConfiguration() {
        if (this._configuration == null) {
            this._configuration = new TokenizerConfiguration();
        }
        return this._configuration;
    }

    private TokenPattern getTokenPattern() {
        if (this._tokenPattern == null) {
            String expression = "<null>".equals(this._expression) ? null : ("<blank>".equals(this._expression) ? "" : this._expression);
            List<Token> tokens = this.getTokenizer().tokenize(expression);
            this._tokenPattern = new TokenPatternImpl(expression, tokens, this.getConfiguration());
        }
        return this._tokenPattern;
    }

    public String getExpression() {
        return this._expression;
    }

    public String toString() {
        return "SimpleStringPattern[name=" + this.getName() + ", expression=" + this._expression + "]";
    }
}

