/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.datacleaner.api.InputRow;
import org.datacleaner.beans.stringpattern.PatternFinder;
import org.datacleaner.beans.stringpattern.TokenPattern;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotations;

public final class DefaultPatternFinder
extends PatternFinder<InputRow> {
    private final ConcurrentMap<TokenPattern, RowAnnotation> _annotations;
    private final RowAnnotationFactory _annotationFactory;

    public DefaultPatternFinder(TokenizerConfiguration configuration, RowAnnotationFactory annotationFactory) {
        super(configuration);
        if (annotationFactory == null) {
            throw new IllegalArgumentException("RowAnnotationFactory cannot be null");
        }
        this._annotations = new ConcurrentHashMap<TokenPattern, RowAnnotation>();
        this._annotationFactory = annotationFactory;
    }

    public DefaultPatternFinder(TokenizerConfiguration configuration, int inMemoryRowThreshold) {
        super(configuration);
        this._annotations = new ConcurrentHashMap<TokenPattern, RowAnnotation>();
        this._annotationFactory = RowAnnotations.getInMemoryFactory((int)100, (int)inMemoryRowThreshold);
    }

    @Override
    protected void storeNewPattern(TokenPattern pattern, InputRow row, String value, int distinctCount) {
        RowAnnotation annotation = this._annotationFactory.createAnnotation();
        this._annotations.put(pattern, annotation);
        this._annotationFactory.annotate(row, distinctCount, annotation);
    }

    @Override
    protected void storeMatch(TokenPattern pattern, InputRow row, String value, int distinctCount) {
        RowAnnotation annotation = (RowAnnotation)this._annotations.get(pattern);
        if (annotation == null) {
            throw new IllegalStateException("No annotation available for pattern: " + pattern);
        }
        this._annotationFactory.annotate(row, distinctCount, annotation);
    }

    public Map<TokenPattern, RowAnnotation> getAnnotations() {
        return this._annotations;
    }
}

