/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.datacleaner.beans.stringpattern.BlankToken;
import org.datacleaner.beans.stringpattern.DefaultTokenizer;
import org.datacleaner.beans.stringpattern.NullToken;
import org.datacleaner.beans.stringpattern.SimpleToken;
import org.datacleaner.beans.stringpattern.Token;
import org.datacleaner.beans.stringpattern.TokenType;
import org.datacleaner.beans.stringpattern.Tokenizer;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;

public class ReverseTokenizer
implements Tokenizer {
    private final TokenizerConfiguration _configuration;
    private final String nullTokenString = NullToken.INSTANCE.getString();
    private final String blankTokenString = BlankToken.INSTANCE.getString();

    public ReverseTokenizer(TokenizerConfiguration configuration) {
        this._configuration = configuration;
    }

    @Override
    public List<Token> tokenize(String pattern) {
        if (pattern == null || this.nullTokenString.equals(pattern)) {
            return Arrays.asList(NullToken.INSTANCE);
        }
        if (this.blankTokenString.equals(pattern)) {
            return Arrays.asList(BlankToken.INSTANCE);
        }
        DefaultTokenizer delegate = new DefaultTokenizer(this._configuration);
        List<Token> tokens = delegate.tokenize(pattern);
        if (this._configuration.isTokenTypeEnabled(TokenType.MIXED)) {
            ListIterator<Token> it = tokens.listIterator();
            while (it.hasNext()) {
                String string;
                Token token = it.next();
                if (token.getType() != TokenType.DELIM || (string = token.getString()).indexOf("??") == -1) continue;
                StringTokenizer tokenizer = new StringTokenizer(string, "?", true);
                it.remove();
                StringBuilder tokenStringBuilder = new StringBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String tokenString = tokenizer.nextToken();
                    if (tokenString.startsWith("?")) {
                        tokenStringBuilder.append(tokenString);
                        continue;
                    }
                    if (tokenStringBuilder.length() > 0) {
                        it.add(new SimpleToken(TokenType.MIXED, tokenStringBuilder.toString()));
                        tokenStringBuilder.setLength(0);
                    }
                    it.add(new SimpleToken(TokenType.DELIM, tokenString));
                }
                if (tokenStringBuilder.length() <= 0) continue;
                it.add(new SimpleToken(TokenType.MIXED, tokenStringBuilder.toString()));
                tokenStringBuilder.setLength(0);
            }
        }
        return tokens;
    }
}

