/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.datacleaner.beans.stringpattern.PredefinedTokenDefinition;
import org.datacleaner.beans.stringpattern.TokenType;

public class TokenizerConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EnumSet<TokenType> _tokenTypes;
    private EnumMap<TokenType, Boolean> _discriminateTokenLength;
    private boolean _discriminateTextCase;
    private boolean _discriminateWhiteSpaces;
    private boolean _discriminateDecimalNumbers;
    private boolean _discriminateNegativeNumbers;
    private boolean _upperCaseExpandable;
    private boolean _lowerCaseExpandable;
    private Character _thousandsSeparator;
    private Character _decimalSeparator;
    private Character _minusSign;
    private List<PredefinedTokenDefinition> _predefinedTokens = new LinkedList<PredefinedTokenDefinition>();

    public TokenizerConfiguration() {
        this(true);
    }

    public TokenizerConfiguration(boolean enableMixedTokens) {
        this(enableMixedTokens, Character.valueOf(DecimalFormatSymbols.getInstance().getDecimalSeparator()), Character.valueOf(DecimalFormatSymbols.getInstance().getGroupingSeparator()), Character.valueOf(DecimalFormatSymbols.getInstance().getMinusSign()));
    }

    public TokenizerConfiguration(boolean enableMixed, Character decimalSeparator, Character thousandsSeparator, Character minusSign) {
        this._tokenTypes = EnumSet.allOf(TokenType.class);
        if (!enableMixed) {
            this._tokenTypes.remove((Object)TokenType.MIXED);
        }
        this._discriminateTokenLength = new EnumMap(TokenType.class);
        this._discriminateTokenLength.put(TokenType.TEXT, false);
        this._discriminateTokenLength.put(TokenType.NUMBER, false);
        this._discriminateTokenLength.put(TokenType.MIXED, false);
        this._discriminateTokenLength.put(TokenType.PREDEFINED, false);
        this._discriminateTokenLength.put(TokenType.WHITESPACE, true);
        this._discriminateTokenLength.put(TokenType.DELIM, true);
        this._discriminateTextCase = true;
        this._discriminateWhiteSpaces = true;
        this._discriminateDecimalNumbers = true;
        this._discriminateNegativeNumbers = false;
        this._upperCaseExpandable = false;
        this._lowerCaseExpandable = true;
        this._decimalSeparator = decimalSeparator;
        this._thousandsSeparator = thousandsSeparator;
        this._minusSign = minusSign;
    }

    public void setTokenTypes(EnumSet<TokenType> tokenTypes) {
        this._tokenTypes = tokenTypes;
    }

    public EnumSet<TokenType> getTokenTypes() {
        return this._tokenTypes;
    }

    public EnumMap<TokenType, Boolean> getDiscriminateTokenLength() {
        return this._discriminateTokenLength;
    }

    public boolean isDistriminateTokenLength(TokenType tokenType) {
        Boolean discriminateTokenLength = this._discriminateTokenLength.get((Object)tokenType);
        if (discriminateTokenLength == null) {
            return false;
        }
        return discriminateTokenLength;
    }

    public void setDistriminateTokenLength(EnumMap<TokenType, Boolean> discriminateTokenLength) {
        this._discriminateTokenLength = discriminateTokenLength;
    }

    public void setDistriminateTokenLength(TokenType tokenType, boolean discriminateTokenLength) {
        this._discriminateTokenLength.put(tokenType, discriminateTokenLength);
    }

    public boolean isDiscriminateTextCase() {
        return this._discriminateTextCase;
    }

    public void setDiscriminateTextCase(boolean discriminateTextCase) {
        this._discriminateTextCase = discriminateTextCase;
    }

    public boolean isDiscriminateWhiteSpaces() {
        return this._discriminateWhiteSpaces;
    }

    public void setDiscriminateWhiteSpaces(boolean discriminateWhiteSpaces) {
        this._discriminateWhiteSpaces = discriminateWhiteSpaces;
    }

    public List<PredefinedTokenDefinition> getPredefinedTokens() {
        return this._predefinedTokens;
    }

    public void setPredefinedTokens(List<PredefinedTokenDefinition> predefinedTokens) {
        this._predefinedTokens = predefinedTokens;
    }

    public boolean isDiscriminateDecimalNumbers() {
        return this._discriminateDecimalNumbers;
    }

    public void setDiscriminateDecimalNumbers(boolean discriminateDecimalNumbers) {
        this._discriminateDecimalNumbers = discriminateDecimalNumbers;
    }

    public Character getThousandsSeparator() {
        return this._thousandsSeparator;
    }

    public void setThousandsSeparator(Character thousandSeparator) {
        this._thousandsSeparator = thousandSeparator;
    }

    public Character getDecimalSeparator() {
        return this._decimalSeparator;
    }

    public void setDecimalSeparator(Character decimalSeparator) {
        this._decimalSeparator = decimalSeparator;
    }

    public Character getMinusSign() {
        return this._minusSign;
    }

    public void setMinusSign(Character minusSign) {
        this._minusSign = minusSign;
    }

    public boolean isDiscriminateNegativeNumbers() {
        return this._discriminateNegativeNumbers;
    }

    public void setDiscriminateNegativeNumbers(boolean discriminateNegativeNumbers) {
        this._discriminateNegativeNumbers = discriminateNegativeNumbers;
    }

    public boolean isUpperCaseExpandable() {
        return this._upperCaseExpandable;
    }

    public void setUpperCaseExpandable(boolean upperCaseExpandable) {
        this._upperCaseExpandable = upperCaseExpandable;
    }

    public boolean isLowerCaseExpandable() {
        return this._lowerCaseExpandable;
    }

    public void setLowerCaseExpandable(boolean lowerCaseExpandable) {
        this._lowerCaseExpandable = lowerCaseExpandable;
    }

    public boolean isTokenTypeEnabled(TokenType tokenType) {
        return this._tokenTypes.contains((Object)tokenType);
    }
}

