/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.datacleaner.beans.stringpattern.BlankToken;
import org.datacleaner.beans.stringpattern.NullToken;
import org.datacleaner.beans.stringpattern.PredefinedTokenDefinition;
import org.datacleaner.beans.stringpattern.PredefinedTokenTokenizer;
import org.datacleaner.beans.stringpattern.SimpleToken;
import org.datacleaner.beans.stringpattern.Token;
import org.datacleaner.beans.stringpattern.TokenType;
import org.datacleaner.beans.stringpattern.Tokenizer;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;
import org.datacleaner.util.CharIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTokenizer
implements Serializable,
Tokenizer {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultTokenizer.class);
    private final TokenizerConfiguration _configuration;
    private final boolean _predefinedTokens;

    public DefaultTokenizer() {
        this(new TokenizerConfiguration());
    }

    public DefaultTokenizer(TokenizerConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration argument cannot be null");
        }
        this._configuration = configuration;
        List<PredefinedTokenDefinition> predefinedTokens = this._configuration.getPredefinedTokens();
        boolean bl = this._predefinedTokens = !predefinedTokens.isEmpty() && this._configuration.isTokenTypeEnabled(TokenType.PREDEFINED);
        if (this._predefinedTokens) {
            logger.debug("Predefined tokens are turned ON, using PredefinedTokenTokenizer");
        } else {
            logger.debug("Predefined tokens are turned OFF, using tokenizeInternal");
        }
    }

    @Override
    public List<Token> tokenize(String string) {
        List<Token> tokens;
        if (string == null) {
            return Arrays.asList(NullToken.INSTANCE);
        }
        if ("".equals(string)) {
            return Arrays.asList(BlankToken.INSTANCE);
        }
        if (this._predefinedTokens) {
            List<PredefinedTokenDefinition> predefinedTokens = this._configuration.getPredefinedTokens();
            PredefinedTokenTokenizer tokenizer = new PredefinedTokenTokenizer(predefinedTokens);
            tokens = tokenizer.tokenize(string);
            ListIterator<Token> it = tokens.listIterator();
            while (it.hasNext()) {
                Token token = it.next();
                TokenType tokenType = token.getType();
                logger.debug("Next token type is: {}", (Object)tokenType);
                if (tokenType != TokenType.UNDEFINED) continue;
                List<SimpleToken> replacementTokens = this.tokenizeInternal(token.getString());
                boolean replace = true;
                if (replacementTokens.size() == 1 && token.equals(replacementTokens.get(0))) {
                    replace = false;
                }
                if (!replace) continue;
                it.remove();
                for (SimpleToken replacementToken : replacementTokens) {
                    it.add(replacementToken);
                }
            }
        } else {
            tokens = new ArrayList<Token>();
            tokens.addAll(this.tokenizeInternal(string));
        }
        return tokens;
    }

    private List<SimpleToken> tokenizeInternal(String string) {
        List<SimpleToken> tokens = DefaultTokenizer.preliminaryTokenize(string, this._configuration);
        if (this._configuration.isTokenTypeEnabled(TokenType.MIXED)) {
            tokens = DefaultTokenizer.flattenMixedTokens(tokens);
        }
        return tokens;
    }

    protected static List<SimpleToken> preliminaryTokenize(String string, TokenizerConfiguration configuration) {
        LinkedList<SimpleToken> result = new LinkedList<SimpleToken>();
        SimpleToken lastToken = null;
        CharIterator ci = new CharIterator((CharSequence)string);
        while (ci.hasNext()) {
            char next;
            char c = ci.next().charValue();
            if (ci.is(configuration.getThousandsSeparator()) || ci.is(configuration.getDecimalSeparator())) {
                boolean treatAsSeparator = false;
                if (lastToken != null && lastToken.getType() == TokenType.NUMBER && ci.hasNext()) {
                    next = ci.next().charValue();
                    if (ci.isDigit()) {
                        treatAsSeparator = true;
                        lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.NUMBER);
                        lastToken = DefaultTokenizer.registerChar(result, lastToken, next, TokenType.NUMBER);
                    } else {
                        ci.previous();
                    }
                }
                if (treatAsSeparator) continue;
                lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.DELIM);
                continue;
            }
            if (ci.is(configuration.getMinusSign())) {
                boolean treatAsMinus = false;
                if ((lastToken == null || lastToken.getType() != TokenType.NUMBER) && ci.hasNext()) {
                    next = ci.next().charValue();
                    if (ci.isDigit()) {
                        treatAsMinus = true;
                        lastToken = DefaultTokenizer.registerChar(result, null, c, TokenType.NUMBER);
                        lastToken = DefaultTokenizer.registerChar(result, lastToken, next, TokenType.NUMBER);
                    } else {
                        ci.previous();
                    }
                }
                if (treatAsMinus) continue;
                lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.DELIM);
                continue;
            }
            if (ci.isDigit()) {
                lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.NUMBER);
                continue;
            }
            if (ci.isLetter()) {
                char charFromPreviousToken;
                if (configuration.isDiscriminateTextCase() && lastToken != null && lastToken.getType() == TokenType.TEXT && Character.isUpperCase(charFromPreviousToken = lastToken.getString().charAt(0)) != Character.isUpperCase(c)) {
                    lastToken = null;
                }
                lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.TEXT);
                continue;
            }
            if (ci.isWhitespace()) {
                lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.WHITESPACE);
                continue;
            }
            lastToken = DefaultTokenizer.registerChar(result, lastToken, c, TokenType.DELIM);
        }
        return result;
    }

    private static SimpleToken registerChar(List<SimpleToken> result, SimpleToken lastToken, char c, TokenType tokenType) {
        if (lastToken == null) {
            logger.debug("Creating new {} token", (Object)tokenType);
            lastToken = new SimpleToken(tokenType, c);
            result.add(lastToken);
        } else if (lastToken.getType() == tokenType) {
            logger.debug("Appending to previous token", (Object)tokenType);
            lastToken.appendChar(c);
        } else {
            logger.debug("Creating new {} token", (Object)tokenType);
            lastToken = new SimpleToken(tokenType, c);
            result.add(lastToken);
        }
        logger.debug("{} registered as {}", (Object)Character.valueOf(c), (Object)tokenType);
        return lastToken;
    }

    public static List<SimpleToken> flattenMixedTokens(List<SimpleToken> tokens) {
        SimpleToken previousToken = null;
        ListIterator<SimpleToken> it = tokens.listIterator();
        while (it.hasNext()) {
            TokenType currentType;
            SimpleToken token = it.next();
            if (previousToken == null) {
                previousToken = token;
                continue;
            }
            boolean mix = false;
            TokenType previousType = previousToken.getType();
            if (previousType != (currentType = token.getType()) && DefaultTokenizer.isMixedCandidate(previousType) && DefaultTokenizer.isMixedCandidate(currentType)) {
                mix = true;
                previousToken.appendString(token.getString());
                previousToken.setType(TokenType.MIXED);
                it.remove();
            }
            if (mix) continue;
            previousToken = token;
        }
        return tokens;
    }

    private static boolean isMixedCandidate(TokenType type) {
        return type == TokenType.MIXED || type == TokenType.NUMBER || type == TokenType.TEXT;
    }
}

