/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.stringpattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.datacleaner.beans.stringpattern.DefaultTokenizer;
import org.datacleaner.beans.stringpattern.Token;
import org.datacleaner.beans.stringpattern.TokenPattern;
import org.datacleaner.beans.stringpattern.TokenPatternImpl;
import org.datacleaner.beans.stringpattern.Tokenizer;
import org.datacleaner.beans.stringpattern.TokenizerConfiguration;

public abstract class PatternFinder<R> {
    private final ConcurrentHashMap<String, Collection<TokenPattern>> _patterns;
    private final TokenizerConfiguration _configuration;
    private final Tokenizer _tokenizer;

    public PatternFinder(Tokenizer tokenizer, TokenizerConfiguration configuration) {
        this._configuration = configuration;
        this._tokenizer = tokenizer;
        this._patterns = new ConcurrentHashMap();
    }

    public PatternFinder(TokenizerConfiguration configuration) {
        this(new DefaultTokenizer(configuration), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(R row, String value, int distinctCount) {
        Collection<TokenPattern> patterns;
        List<Token> tokens;
        try {
            tokens = this._tokenizer.tokenize(value);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error occurred while tokenizing value: " + value, e);
        }
        String patternCode = this.getPatternCode(tokens);
        Collection<TokenPattern> collection = patterns = this.getOrCreatePatterns(patternCode);
        synchronized (collection) {
            boolean match = false;
            for (TokenPattern pattern : patterns) {
                if (!pattern.match(tokens)) continue;
                this.storeMatch(pattern, row, value, distinctCount);
                match = true;
                break;
            }
            if (!match) {
                TokenPatternImpl pattern;
                try {
                    pattern = new TokenPatternImpl(value, tokens, this._configuration);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Error occurred while creating pattern for: " + tokens, e);
                }
                this.storeNewPattern(pattern, row, value, distinctCount);
                patterns.add(pattern);
            }
        }
    }

    private Collection<TokenPattern> getOrCreatePatterns(String patternCode) {
        Collection<TokenPattern> patterns = this._patterns.get(patternCode);
        if (patterns != null) {
            return patterns;
        }
        ArrayList<TokenPattern> newPatterns = new ArrayList<TokenPattern>(3);
        Collection existingPatterns = this._patterns.putIfAbsent(patternCode, newPatterns);
        if (existingPatterns == null) {
            return newPatterns;
        }
        return existingPatterns;
    }

    private String getPatternCode(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.size());
        for (Token token : tokens) {
            sb.append(token.getType().ordinal());
        }
        return sb.toString();
    }

    public Collection<TokenPattern> getPatterns() {
        HashSet<TokenPattern> result = new HashSet<TokenPattern>();
        Collection<Collection<TokenPattern>> values = this._patterns.values();
        for (Collection<TokenPattern> set : values) {
            result.addAll(set);
        }
        return result;
    }

    protected abstract void storeNewPattern(TokenPattern var1, R var2, String var3, int var4);

    protected abstract void storeMatch(TokenPattern var1, R var2, String var3, int var4);
}

