/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Validate;
import org.datacleaner.beans.BooleanAnalyzer;
import org.datacleaner.beans.BooleanAnalyzerResult;
import org.datacleaner.beans.transform.DictionaryMatcherTransformer;
import org.datacleaner.beans.transform.StringPatternMatcherTransformer;
import org.datacleaner.components.convert.ConvertToStringTransformer;
import org.datacleaner.data.MockInputColumn;
import org.datacleaner.data.MockInputRow;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.SynonymCatalog;

@Named(value="Reference data matcher")
@Alias(value={"Matching analyzer"})
@Description(value="Check your data values against multiple forms of reference data in one simple analyzer step.\nThis analyzer provides a handy shortcut for doing matching with dictionaries, synonym lookups or string patterns matching, retrieving matching matrices for all matches.")
public class ReferenceDataMatcherAnalyzer
implements Analyzer<BooleanAnalyzerResult> {
    @Configured(order=1)
    InputColumn<?>[] columns;
    @Configured(order=2, required=false)
    Dictionary[] dictionaries;
    @Configured(order=3, required=false)
    SynonymCatalog[] synonymCatalogs;
    @Configured(order=4, required=false)
    StringPattern[] stringPatterns;
    private BooleanAnalyzer _booleanAnalyzer;
    private DictionaryMatcherTransformer[] _dictionaryMatchers;
    private StringPatternMatcherTransformer[] _stringPatternMatchers;
    private List<InputColumn<Boolean>> _matchColumns;

    public ReferenceDataMatcherAnalyzer(InputColumn<?>[] columns, Dictionary[] dictionaries, SynonymCatalog[] synonymCatalogs, StringPattern[] stringPatterns) {
        this();
        this.columns = columns;
        this.dictionaries = dictionaries;
        this.stringPatterns = stringPatterns;
        this.synonymCatalogs = synonymCatalogs;
    }

    public ReferenceDataMatcherAnalyzer() {
    }

    @Validate
    public void validate() {
        if (!(this.isDictionaryMatchingEnabled() || this.isSynonymCatalogLookupEnabled() || this.isStringPatternMatchingEnabled())) {
            throw new IllegalStateException("No dictionaries, synonym catalogs or string patterns selected");
        }
    }

    @Initialize
    public void init() {
        this._dictionaryMatchers = new DictionaryMatcherTransformer[this.columns.length];
        this._stringPatternMatchers = new StringPatternMatcherTransformer[this.columns.length];
        this._matchColumns = new ArrayList<InputColumn<Boolean>>();
        for (int i = 0; i < this.columns.length; ++i) {
            OutputColumns outputColumns;
            if (this.isDictionaryMatchingEnabled()) {
                DictionaryMatcherTransformer dictionaryMatcher = new DictionaryMatcherTransformer(this.columns[i], this.dictionaries);
                outputColumns = dictionaryMatcher.getOutputColumns();
                this.addMatchColumns(outputColumns);
                this._dictionaryMatchers[i] = dictionaryMatcher;
            }
            if (this.isSynonymCatalogLookupEnabled()) {
                outputColumns = new OutputColumns(this.synonymCatalogs.length, Boolean.class);
                for (int j = 0; j < this.synonymCatalogs.length; ++j) {
                    SynonymCatalog synonymCatalog = this.synonymCatalogs[j];
                    outputColumns.setColumnName(j, this.columns[i].getName() + " in " + synonymCatalog.getName());
                }
                this.addMatchColumns(outputColumns);
            }
            if (!this.isStringPatternMatchingEnabled()) continue;
            StringPatternMatcherTransformer stringPatternMatcher = new StringPatternMatcherTransformer(this.columns[i], this.stringPatterns);
            outputColumns = stringPatternMatcher.getOutputColumns();
            this.addMatchColumns(outputColumns);
            this._stringPatternMatchers[i] = stringPatternMatcher;
        }
        InputColumn[] columnArray = this._matchColumns.toArray(new InputColumn[this._matchColumns.size()]);
        this._booleanAnalyzer = new BooleanAnalyzer(columnArray);
        this._booleanAnalyzer.init();
    }

    private boolean isStringPatternMatchingEnabled() {
        return this.stringPatterns != null && this.stringPatterns.length > 0;
    }

    private boolean isSynonymCatalogLookupEnabled() {
        return this.synonymCatalogs != null && this.synonymCatalogs.length > 0;
    }

    private boolean isDictionaryMatchingEnabled() {
        return this.dictionaries != null && this.dictionaries.length > 0;
    }

    private void addMatchColumns(OutputColumns outputColumns) {
        int count = outputColumns.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName = outputColumns.getColumnName(i);
            MockInputColumn col = new MockInputColumn(columnName, Boolean.class);
            this._matchColumns.add((InputColumn<Boolean>)col);
        }
    }

    public void run(InputRow row, int distinctCount) {
        MockInputRow mockInputRow = new MockInputRow();
        int matchColumnIndex = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            InputColumn<Boolean> matchColumn;
            Object[] matches;
            Object value = row.getValue(this.columns[i]);
            String stringValue = ConvertToStringTransformer.transformValue((Object)value);
            mockInputRow.put(this.columns[i], value);
            if (this.isDictionaryMatchingEnabled()) {
                for (Object match : matches = this._dictionaryMatchers[i].transform(row)) {
                    assert (match instanceof Boolean);
                    matchColumn = this._matchColumns.get(matchColumnIndex);
                    ++matchColumnIndex;
                    mockInputRow.put(matchColumn, match);
                }
            }
            if (this.isSynonymCatalogLookupEnabled()) {
                for (SynonymCatalog synonymCatalog : this.synonymCatalogs) {
                    InputColumn<Boolean> matchColumn2 = this._matchColumns.get(matchColumnIndex);
                    ++matchColumnIndex;
                    String masterTerm = synonymCatalog.getMasterTerm(stringValue);
                    if (masterTerm == null) {
                        mockInputRow.put(matchColumn2, (Object)Boolean.FALSE);
                        continue;
                    }
                    mockInputRow.put(matchColumn2, (Object)Boolean.TRUE);
                }
            }
            if (!this.isStringPatternMatchingEnabled()) continue;
            for (Object match : matches = this._stringPatternMatchers[i].transform(row)) {
                assert (match instanceof Boolean);
                matchColumn = this._matchColumns.get(matchColumnIndex);
                ++matchColumnIndex;
                mockInputRow.put(matchColumn, match);
            }
        }
        this._booleanAnalyzer.run((InputRow)mockInputRow, distinctCount);
    }

    public BooleanAnalyzerResult getResult() {
        return this._booleanAnalyzer.getResult();
    }
}

