/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.filter;

import javax.inject.Named;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Filter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.components.categories.FilterCategory;
import org.datacleaner.reference.Dictionary;

@Named(value="Validate in dictionary")
@Alias(value={"Dictionary lookup"})
@Description(value="Filters values based on their existence in a dictionary")
@Categorized(value={FilterCategory.class})
public class DictionaryFilter
implements Filter<Category> {
    @Configured
    InputColumn<String> column;
    @Configured
    Dictionary dictionary;

    public DictionaryFilter() {
    }

    public DictionaryFilter(InputColumn<String> column, Dictionary dictionary) {
        this();
        this.column = column;
        this.dictionary = dictionary;
    }

    public Category categorize(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value != null && this.dictionary.containsValue(value)) {
            return Category.VALID;
        }
        return Category.INVALID;
    }

    public static enum Category {
        VALID,
        INVALID;

    }
}

