/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import java.util.Arrays;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.beans.transform.MatchOutputType;
import org.datacleaner.components.categories.DateAndTimeCategory;
import org.datacleaner.components.categories.MatchingAndStandardizationCategory;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Named(value="Date mask matcher")
@Description(value="Matches String values against a set of date masks, producing a corresponding set of output columns, specifying whether or not the strings could be interpreted as dates given those date masks")
@Categorized(value={MatchingAndStandardizationCategory.class, DateAndTimeCategory.class})
public class DateMaskMatcherTransformer
implements Transformer {
    public static final String[] DEFAULT_DATE_MASKS = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "dd.MM.yyyy", "dd/MM/yyyy", "MM/dd/yy", "d MMM yyyy HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S"};
    @Configured
    InputColumn<String> _column;
    @Configured
    String[] _dateMasks = DEFAULT_DATE_MASKS;
    @Configured
    MatchOutputType _outputType = MatchOutputType.TRUE_FALSE;
    private DateTimeFormatter[] _dateTimeFormatters;

    public DateMaskMatcherTransformer(InputColumn<String> column) {
        this._column = column;
    }

    public DateMaskMatcherTransformer() {
    }

    @Initialize
    public void init() {
        this._dateTimeFormatters = new DateTimeFormatter[this._dateMasks.length];
        for (int i = 0; i < this._dateTimeFormatters.length; ++i) {
            try {
                this._dateTimeFormatters[i] = DateTimeFormat.forPattern((String)this._dateMasks[i]);
                continue;
            }
            catch (Exception e) {
                this._dateTimeFormatters[i] = null;
            }
        }
    }

    public OutputColumns getOutputColumns() {
        String columnName = this._column.getName();
        String[] names = new String[this._dateMasks.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = columnName + " '" + this._dateMasks[i] + "'";
        }
        Class[] types = new Class[this._dateMasks.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this._outputType.getOutputClass();
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow inputRow) {
        String value;
        Object[] result = new Object[this._dateMasks.length];
        if (this._outputType == MatchOutputType.TRUE_FALSE) {
            Arrays.fill(result, (Object)false);
        }
        if ((value = (String)inputRow.getValue(this._column)) != null) {
            for (int i = 0; i < this._dateTimeFormatters.length; ++i) {
                DateTimeFormatter dateTimeFormatter = this._dateTimeFormatters[i];
                if (dateTimeFormatter == null) continue;
                boolean match = false;
                try {
                    dateTimeFormatter.parseDateTime(value);
                    match = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this._outputType == MatchOutputType.TRUE_FALSE) {
                    result[i] = match;
                    continue;
                }
                if (this._outputType != MatchOutputType.INPUT_OR_NULL) continue;
                result[i] = match ? value : null;
            }
        }
        return result;
    }

    public void setDateMasks(String[] dateMasks) {
        this._dateMasks = dateMasks;
    }

    public String[] getDateMasks() {
        return this._dateMasks;
    }
}

