/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.beans.transform.MatchOutputType;
import org.datacleaner.components.categories.MatchingAndStandardizationCategory;
import org.datacleaner.components.convert.ConvertToStringTransformer;
import org.datacleaner.reference.Dictionary;

@Named(value="Dictionary matcher")
@Description(value="Matches string values against a set of dictionaries, producing a corresponding set of output columns specifying whether or not the values exist in those dictionaries")
@Categorized(value={MatchingAndStandardizationCategory.class})
public class DictionaryMatcherTransformer
implements Transformer {
    @Configured
    Dictionary[] _dictionaries;
    @Configured
    InputColumn<?> _column;
    @Configured
    MatchOutputType _outputType = MatchOutputType.TRUE_FALSE;

    public DictionaryMatcherTransformer() {
    }

    public DictionaryMatcherTransformer(InputColumn<?> column, Dictionary[] dictionaries) {
        this();
        this._column = column;
        this._dictionaries = dictionaries;
    }

    public void setDictionaries(Dictionary[] dictionaries) {
        this._dictionaries = dictionaries;
    }

    public void setColumn(InputColumn<?> column) {
        this._column = column;
    }

    public OutputColumns getOutputColumns() {
        String columnName = this._column.getName();
        String[] names = new String[this._dictionaries.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = columnName + " in '" + this._dictionaries[i].getName() + "'";
        }
        Class[] types = new Class[this._dictionaries.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this._outputType.getOutputClass();
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow inputRow) {
        Object value = inputRow.getValue(this._column);
        return this.transform(value);
    }

    public Object[] transform(Object value) {
        String stringValue = ConvertToStringTransformer.transformValue((Object)value);
        Object[] result = new Object[this._dictionaries.length];
        if (stringValue != null) {
            for (int i = 0; i < result.length; ++i) {
                boolean containsValue = this._dictionaries[i].containsValue(stringValue);
                if (this._outputType == MatchOutputType.TRUE_FALSE) {
                    result[i] = containsValue;
                    continue;
                }
                if (this._outputType != MatchOutputType.INPUT_OR_NULL) continue;
                result[i] = containsValue ? stringValue : null;
            }
        }
        return result;
    }
}

