/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.transform;

import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.beans.transform.MatchOutputType;
import org.datacleaner.components.categories.MatchingAndStandardizationCategory;
import org.datacleaner.components.convert.ConvertToStringTransformer;
import org.datacleaner.reference.StringPattern;

@Named(value="String pattern matcher")
@Description(value="Matches string values against a set of string patterns, producing a corresponding set of output columns specifying whether or not the values matched those string patterns")
@Categorized(value={MatchingAndStandardizationCategory.class})
public class StringPatternMatcherTransformer
implements Transformer {
    @Configured
    StringPattern[] _stringPatterns;
    @Configured
    InputColumn<?> _column;
    @Configured
    MatchOutputType _outputType = MatchOutputType.TRUE_FALSE;

    public StringPatternMatcherTransformer(InputColumn<?> column, StringPattern[] stringPatterns) {
        this();
        this._column = column;
        this._stringPatterns = stringPatterns;
    }

    public StringPatternMatcherTransformer() {
    }

    public OutputColumns getOutputColumns() {
        String columnName = this._column.getName();
        String[] names = new String[this._stringPatterns.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = columnName + " '" + this._stringPatterns[i].getName() + "'";
        }
        Class[] types = new Class[this._stringPatterns.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this._outputType.getOutputClass();
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow inputRow) {
        Object value = inputRow.getValue(this._column);
        Object[] result = this.doMatching(value);
        return result;
    }

    public Object[] doMatching(Object value) {
        Object[] result = new Object[this._stringPatterns.length];
        String stringValue = ConvertToStringTransformer.transformValue((Object)value);
        for (int i = 0; i < result.length; ++i) {
            boolean matches = this._stringPatterns[i].matches(stringValue);
            if (this._outputType == MatchOutputType.TRUE_FALSE) {
                result[i] = matches;
                continue;
            }
            if (this._outputType != MatchOutputType.INPUT_OR_NULL) continue;
            result[i] = matches ? stringValue : null;
        }
        return result;
    }

    public void setStringPatterns(StringPattern[] stringPatterns) {
        this._stringPatterns = stringPatterns;
    }

    public void setColumn(InputColumn<?> column) {
        this._column = column;
    }
}

