/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.restclient;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComponentList {
    private List<ComponentInfo> components = new ArrayList<ComponentInfo>();

    public void add(ComponentInfo componentInfo) {
        this.components.add(componentInfo);
    }

    public List<ComponentInfo> getComponents() {
        return this.components;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"name", "type", "description", "required", "inputColumn"})
    public static class PropertyInfo {
        private String name;
        private String classDetails;
        private String className;
        private JsonSchema schema;
        private String description;
        private boolean required;
        private boolean isInputColumn;
        private Map<String, Map<String, Object>> annotations = new HashMap<String, Map<String, Object>>();
        private JsonNode defaultValue;

        public void setIsInputColumn(boolean inputColumn) {
            this.isInputColumn = inputColumn;
        }

        public boolean isInputColumn() {
            return this.isInputColumn;
        }

        public void setInputColumn(boolean inputColumn) {
            this.isInputColumn = inputColumn;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public JsonSchema getSchema() {
            return this.schema;
        }

        public void setSchema(JsonSchema schema) {
            this.schema = schema;
        }

        public String getClassDetails() {
            return this.classDetails;
        }

        public void setClassDetails(String classDetails) {
            this.classDetails = classDetails;
        }

        public Map<String, Map<String, Object>> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<String, Map<String, Object>> annotations) {
            this.annotations = annotations;
        }

        public JsonNode getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(JsonNode defaultValue) {
            this.defaultValue = defaultValue;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ComponentInfo {
        private String name = "";
        private String description = "";
        private String createURL = "";
        private Set<String> categoryNames = new HashSet<String>();
        private String superCategoryName = null;
        private Map<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
        private byte[] iconData = null;

        public ComponentInfo setProperties(Map<String, PropertyInfo> properties) {
            this.properties = properties;
            return this;
        }

        public Map<String, PropertyInfo> getProperties() {
            return this.properties;
        }

        public String getName() {
            return this.name;
        }

        public ComponentInfo setName(String name) {
            this.name = name;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public ComponentInfo setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getCreateURL() {
            return this.createURL;
        }

        public ComponentInfo setCreateURL(String createURL) {
            this.createURL = createURL;
            return this;
        }

        public Set<String> getCategoryNames() {
            return this.categoryNames;
        }

        public ComponentInfo setCategoryNames(Set<String> categoryNames) {
            this.categoryNames = categoryNames;
            return this;
        }

        public String getSuperCategoryName() {
            return this.superCategoryName;
        }

        public ComponentInfo setSuperCategoryName(String superCategoryName) {
            this.superCategoryName = superCategoryName;
            return this;
        }

        public byte[] getIconData() {
            return this.iconData;
        }

        public ComponentInfo setIconData(byte[] iconData) {
            this.iconData = iconData;
            return this;
        }
    }
}

