/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.restclient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public abstract class ComponentsRestClientUtils {
    public static String encodeUrlPathSegment(String string) {
        try {
            byte[] bytes = ComponentsRestClientUtils.encodeBytes(string.getBytes("UTF-8"));
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String escapeComponentName(String name) {
        return name.replace("/", "_@_");
    }

    public static String unescapeComponentName(String escapedName) {
        return escapedName.replace("_@_", "/");
    }

    public static JsonNode createInputColumnSpecification(String name, Class<?> columnType, String columnTypeName, JsonNodeFactory nodeFac) {
        ObjectNode colSpec = new ObjectNode(nodeFac);
        colSpec.set("name", (JsonNode)new TextNode(name));
        colSpec.set("type", (JsonNode)new TextNode(columnTypeName));
        colSpec.set("className", (JsonNode)new TextNode(columnType.getName()));
        return colSpec;
    }

    private static boolean isPchar(int c) {
        return ComponentsRestClientUtils.isUnreserved(c) || ComponentsRestClientUtils.isSubDelimiter(c) || 58 == c || 64 == c;
    }

    private static boolean isUnreserved(int c) {
        return ComponentsRestClientUtils.isAlpha(c) || ComponentsRestClientUtils.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
    }

    private static boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isSubDelimiter(int c) {
        return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
    }

    private static byte[] encodeBytes(byte[] source) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);
        for (byte b : source) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (ComponentsRestClientUtils.isPchar(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        return bos.toByteArray();
    }
}

