/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.restclient;

import org.datacleaner.restclient.ComponentController;
import org.datacleaner.restclient.ComponentList;
import org.datacleaner.restclient.ComponentNotFoundException;
import org.datacleaner.restclient.ComponentsRestClientUtils;
import org.datacleaner.restclient.CreateInput;
import org.datacleaner.restclient.OutputColumns;
import org.datacleaner.restclient.ProcessInput;
import org.datacleaner.restclient.ProcessOutput;
import org.datacleaner.restclient.ProcessResult;
import org.datacleaner.restclient.ProcessStatelessInput;
import org.datacleaner.restclient.ProcessStatelessOutput;
import org.datacleaner.restclient.RESTClient;
import org.datacleaner.restclient.RESTClientImpl;
import org.datacleaner.restclient.Serializator;

public class ComponentRESTClient
implements ComponentController {
    private RESTClient restClient = null;
    private String tenantName = "";
    private String host = "";

    public ComponentRESTClient(String host, String username, String password) {
        this.tenantName = username;
        this.host = host;
        this.restClient = new RESTClientImpl(username, password);
    }

    @Override
    public ComponentList getAllComponents(String tenant, boolean iconData) {
        this.tenantName = tenant;
        String response = this.call(RESTClient.HttpMethod.GET, this.getURL("?iconData=" + iconData), "");
        return Serializator.componentList(response);
    }

    @Override
    public ComponentList.ComponentInfo getComponentInfo(String tenant, String componentName, boolean iconData) {
        this.tenantName = tenant;
        componentName = this.urlify(componentName);
        String response = this.call(RESTClient.HttpMethod.GET, this.getURL(componentName + "&iconData=" + iconData), "");
        return Serializator.componentInfo(response);
    }

    @Override
    public OutputColumns getOutputColumns(String tenant, String componentName, CreateInput config) {
        componentName = this.urlify(componentName);
        String configuration = Serializator.stringCreateInput(config);
        String response = this.call(RESTClient.HttpMethod.POST, this.getURL(componentName + "/_outputColumns"), configuration);
        return Serializator.outputColumnsOutput(response);
    }

    @Override
    public ProcessStatelessOutput processStateless(String tenant, String componentName, ProcessStatelessInput processStatelessInput) {
        componentName = this.urlify(componentName);
        String configurationAndData = Serializator.stringProcessStatelessInput(processStatelessInput);
        String response = this.call(RESTClient.HttpMethod.PUT, this.getURL(componentName), configurationAndData);
        return Serializator.processStatelessOutput(response);
    }

    @Override
    public String createComponent(String tenant, String componentName, String timeout, CreateInput config) {
        componentName = this.urlify(componentName);
        String configuration = Serializator.stringCreateInput(config);
        return this.call(RESTClient.HttpMethod.POST, this.getURL(componentName + "?timeout=" + timeout), configuration);
    }

    @Override
    public ProcessOutput processComponent(String tenant, String instanceId, ProcessInput processInput) throws ComponentNotFoundException {
        String inputData = Serializator.stringProcessInput(processInput);
        String response = this.call(RESTClient.HttpMethod.PUT, this.getURL("/_instance/" + instanceId), inputData);
        return Serializator.processOutput(response);
    }

    @Override
    public ProcessResult getFinalResult(String tenant, String instanceId) throws ComponentNotFoundException {
        String response = this.call(RESTClient.HttpMethod.GET, this.getURL(instanceId + "/result"), "");
        return Serializator.processResult(response);
    }

    @Override
    public void deleteComponent(String tenant, String instanceId) throws ComponentNotFoundException {
        this.call(RESTClient.HttpMethod.DELETE, this.getURL(instanceId), "");
    }

    private String urlify(String string) {
        return ComponentsRestClientUtils.encodeUrlPathSegment(ComponentsRestClientUtils.escapeComponentName(string));
    }

    private String getURL(String suffix) {
        if (suffix != null && !suffix.isEmpty()) {
            suffix = "/" + suffix;
        }
        return String.format("%s/repository/%s/components%s", this.host, this.tenantName, suffix);
    }

    private String call(RESTClient.HttpMethod httpMethod, String url, String requestBody) {
        String response = this.restClient.getResponse(httpMethod, url, requestBody);
        return response;
    }
}

