/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.restclient;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datacleaner.restclient.RESTClient;

public class RESTClientImpl
implements RESTClient {
    private Client client = null;
    private static Map<String, Client> clientCache = new ConcurrentHashMap<String, Client>();

    public RESTClientImpl(String username, String password) {
        if (username == null) {
            username = "";
        }
        this.client = clientCache.get(username);
        if (this.client == null) {
            this.client = Client.create();
            if (username != null && password != null) {
                this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
            }
            clientCache.put(username, this.client);
        }
    }

    @Override
    public String getResponse(RESTClient.HttpMethod httpMethod, String url, String requestBody) {
        WebResource webResource = this.client.resource(url);
        WebResource.Builder builder = (WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json");
        ClientResponse response = null;
        response = requestBody != null && !requestBody.isEmpty() ? (ClientResponse)builder.method(httpMethod.name(), ClientResponse.class, (Object)requestBody) : (ClientResponse)builder.method(httpMethod.name(), ClientResponse.class);
        if (response.getStatus() != RESTClient.HttpCode.OK.getCode() && response.getStatus() != RESTClient.HttpCode.CREATED.getCode()) {
            throw new RuntimeException("Request failed. HTTP error code: " + response.getStatus());
        }
        String output = (String)response.getEntity(String.class);
        return output;
    }
}

