/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.restclient;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.InputColumn;
import org.datacleaner.restclient.ComponentList;
import org.datacleaner.restclient.CreateInput;
import org.datacleaner.restclient.OutputColumns;
import org.datacleaner.restclient.ProcessInput;
import org.datacleaner.restclient.ProcessOutput;
import org.datacleaner.restclient.ProcessResult;
import org.datacleaner.restclient.ProcessStatelessInput;
import org.datacleaner.restclient.ProcessStatelessOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serializator {
    private static final Logger logger = LoggerFactory.getLogger(Serializator.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getJacksonObjectMapper() {
        return objectMapper;
    }

    public static ComponentList componentList(String response) {
        ComponentList components = Serializator.fromString(response, ComponentList.class);
        Serializator.workaroundJacksonBug(components, response);
        return components;
    }

    private static void workaroundJacksonBug(ComponentList components, String response) {
        try {
            JsonNode rootN = objectMapper.readTree(response);
            JsonNode componentsN = rootN.get("components");
            if (componentsN == null) {
                return;
            }
            for (JsonNode componentN : componentsN) {
                String componentName = componentN.get("name").asText();
                JsonNode propsN = componentN.get("properties");
                if (propsN == null || !propsN.isObject()) continue;
                Iterator propIt = propsN.fields();
                while (propIt.hasNext()) {
                    JsonNode enumN;
                    JsonNode itemsN;
                    JsonNode schemaTypeN;
                    Map.Entry propE = (Map.Entry)propIt.next();
                    String propName = (String)propE.getKey();
                    JsonNode propInfoN = (JsonNode)propE.getValue();
                    JsonNode schemaN = propInfoN.get("schema");
                    if (schemaN == null || (schemaTypeN = schemaN.get("type")) == null || !"array".equals(schemaTypeN.asText()) || (itemsN = schemaN.get("items")) == null || (enumN = itemsN.get("enum")) == null) continue;
                    for (ComponentList.ComponentInfo componentInfo : components.getComponents()) {
                        ComponentList.PropertyInfo propInfo;
                        if (!componentName.equals(componentInfo.getName()) || (propInfo = componentInfo.getProperties().get(propName)) == null) continue;
                        JsonSchema propSchema = propInfo.getSchema();
                        HashSet<String> enumSet = new HashSet<String>();
                        for (JsonNode enumVal : enumN) {
                            enumSet.add(enumVal.asText());
                        }
                        logger.debug("Repaired json enum schema of '{}'.'{}'", (Object)componentName, (Object)propName);
                        ((StringSchema)propSchema.asArraySchema().getItems().asSingleItems().getSchema()).setEnums(enumSet);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ComponentList.ComponentInfo componentInfo(String response) {
        return Serializator.fromString(response, ComponentList.ComponentInfo.class);
    }

    public static String stringProcessStatelessInput(ProcessStatelessInput processStatelessInput) {
        return Serializator.intoString(processStatelessInput);
    }

    public static OutputColumns outputColumnsOutput(String response) {
        return Serializator.fromString(response, OutputColumns.class);
    }

    public static ProcessStatelessOutput processStatelessOutput(String response) {
        return Serializator.fromString(response, ProcessStatelessOutput.class);
    }

    public static String stringCreateInput(CreateInput createInput) {
        return Serializator.intoString(createInput);
    }

    public static String stringProcessInput(ProcessInput processInput) {
        return Serializator.intoString(processInput);
    }

    public static ProcessOutput processOutput(String response) {
        return Serializator.fromString(response, ProcessOutput.class);
    }

    public static ProcessResult processResult(String response) {
        return Serializator.fromString(response, ProcessResult.class);
    }

    private static String intoString(Object value) {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T fromString(String value, Class<T> type) {
        try {
            if (value instanceof String && (value == null || value.equals(""))) {
                return null;
            }
            return (T)objectMapper.readValue(value, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SimpleModule myModule = new SimpleModule("RemoteTransformersModule", new Version(1, 0, 0, null, "org.datacleaner", "DataCleaner-remote-transformers"));
        myModule.addSerializer((JsonSerializer)new MyInputColumnSerializer());
        myModule.addSerializer((JsonSerializer)new MyEnumSerializer());
        objectMapper.registerModule((Module)myModule);
    }

    private static class MyEnumSerializer
    extends StdSerializer<Enum> {
        protected MyEnumSerializer() {
            super(Enum.class);
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            JavaType type;
            ObjectNode objectNode = this.createSchemaNode("string", true);
            if (typeHint != null && (type = provider.constructType(typeHint)).isEnumType()) {
                ArrayNode enumNode = objectNode.putArray("enum");
                for (Object value : type.getRawClass().getEnumConstants()) {
                    enumNode.add(this.enumValueToSchemaString((Enum)value));
                }
            }
            return objectNode;
        }

        public void serialize(Enum value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.name());
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
            if (typeHint != null && stringVisitor != null && typeHint.isEnumType()) {
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                for (Object value : typeHint.getRawClass().getEnumConstants()) {
                    enums.add(this.enumValueToSchemaString((Enum)value));
                }
                stringVisitor.enumTypes(enums);
            }
        }

        protected String enumValueToSchemaString(Enum value) {
            if (value instanceof HasName) {
                return value.name() + "::" + ((HasName)value).getName();
            }
            return value.name() + "::" + String.valueOf(value);
        }
    }

    private static class MyInputColumnSerializer
    extends StdSerializer<InputColumn> {
        protected MyInputColumnSerializer() {
            super(InputColumn.class);
        }

        public void serialize(InputColumn value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getName());
        }
    }
}

