/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.xml.XmlDomDataContext;
import org.datacleaner.connection.CsvDatastore;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.ExcelDatastore;
import org.datacleaner.connection.JdbcDatastore;
import org.datacleaner.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatastoreXmlExternalizer {
    private final Document _document;

    public DatastoreXmlExternalizer() {
        DocumentBuilder documentBuilder;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._document = documentBuilder.newDocument();
    }

    public DatastoreXmlExternalizer(Resource resource) {
        this._document = (Document)resource.read((Func)new Func<InputStream, Document>(){

            public Document eval(InputStream in) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    return documentBuilder.parse(in);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public DatastoreXmlExternalizer(Document document) {
        this._document = document;
    }

    public boolean isExternalizable(Datastore datastore) {
        Resource resource;
        if (datastore == null) {
            return false;
        }
        if (datastore instanceof JdbcDatastore) {
            return true;
        }
        if (datastore instanceof CsvDatastore && (resource = ((CsvDatastore)datastore).getResource()) instanceof FileResource) {
            return true;
        }
        return datastore instanceof ExcelDatastore && (resource = ((ExcelDatastore)datastore).getResource()) instanceof FileResource;
    }

    public boolean removeDatastore(String datastoreName) {
        Element datastoreCatalogElement = this.getDatastoreCatalogElement();
        NodeList childNodes = datastoreCatalogElement.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr[] attributes;
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            for (Attr attr : attributes = XmlDomDataContext.getAttributes((Element)element)) {
                String value;
                if (!"name".equals(attr.getName()) || !datastoreName.equals(value = attr.getValue())) continue;
                datastoreCatalogElement.removeChild(element);
                this.onDocumentChanged(this.getDocument());
                return true;
            }
        }
        return false;
    }

    public Element externalize(Datastore datastore) throws UnsupportedOperationException {
        Element elem;
        Resource resource;
        if (datastore == null) {
            throw new IllegalArgumentException("Datastore cannot be null");
        }
        if (datastore instanceof CsvDatastore) {
            resource = ((CsvDatastore)datastore).getResource();
            String filename = this.toFilename(resource);
            elem = this.toElement((CsvDatastore)datastore, filename);
        } else if (datastore instanceof ExcelDatastore) {
            resource = ((ExcelDatastore)datastore).getResource();
            String filename = this.toFilename(resource);
            elem = this.toElement((ExcelDatastore)datastore, filename);
        } else if (datastore instanceof JdbcDatastore) {
            elem = this.toElement((JdbcDatastore)datastore);
        } else {
            throw new UnsupportedOperationException("Non-supported datastore: " + datastore);
        }
        Element datastoreCatalogElement = this.getDatastoreCatalogElement();
        datastoreCatalogElement.appendChild(elem);
        this.onDocumentChanged(this.getDocument());
        return elem;
    }

    protected void onDocumentChanged(Document document) {
    }

    protected String toFilename(Resource resource) throws UnsupportedOperationException {
        if (resource instanceof FileResource) {
            return ((FileResource)resource).getFile().getPath();
        }
        throw new UnsupportedOperationException("Unsupported resource type: " + resource);
    }

    public Element toElement(JdbcDatastore datastore) {
        String catalogName;
        String jndiUrl;
        Element ds = this.getDocument().createElement("jdbc-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!StringUtils.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        if (Strings.isNullOrEmpty((String)(jndiUrl = datastore.getDatasourceJndiUrl()))) {
            this.appendElement(ds, "url", datastore.getJdbcUrl());
            this.appendElement(ds, "driver", datastore.getDriverClass());
            this.appendElement(ds, "username", datastore.getUsername());
            this.appendElement(ds, "password", datastore.getPassword());
            this.appendElement(ds, "multiple-connections", datastore.isMultipleConnections() + "");
        } else {
            this.appendElement(ds, "datasource-jndi-url", jndiUrl);
        }
        Object[] tableTypes = datastore.getTableTypes();
        if (tableTypes != null && tableTypes.length != 0 && !Arrays.equals(TableType.DEFAULT_TABLE_TYPES, tableTypes)) {
            Element tableTypesElement = this.getDocument().createElement("table-types");
            ds.appendChild(tableTypesElement);
            for (Object tableType : tableTypes) {
                this.appendElement(tableTypesElement, "table-type", tableType.name());
            }
        }
        if (!Strings.isNullOrEmpty((String)(catalogName = datastore.getCatalogName()))) {
            this.appendElement(ds, "catalog-name", catalogName);
        }
        return ds;
    }

    public Element toElement(ExcelDatastore datastore, String filename) {
        Element ds = this.getDocument().createElement("excel-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!StringUtils.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "filename", filename);
        return ds;
    }

    public Element toElement(CsvDatastore datastore, String filename) {
        Element datastoreElement = this.getDocument().createElement("csv-datastore");
        datastoreElement.setAttribute("name", datastore.getName());
        String description = datastore.getDescription();
        if (!StringUtils.isNullOrEmpty((String)description)) {
            datastoreElement.setAttribute("description", description);
        }
        this.appendElement(datastoreElement, "filename", filename);
        this.appendElement(datastoreElement, "quote-char", datastore.getQuoteChar());
        this.appendElement(datastoreElement, "separator-char", datastore.getSeparatorChar());
        this.appendElement(datastoreElement, "escape-char", datastore.getEscapeChar());
        this.appendElement(datastoreElement, "encoding", datastore.getEncoding());
        this.appendElement(datastoreElement, "fail-on-inconsistencies", datastore.isFailOnInconsistencies());
        this.appendElement(datastoreElement, "multiline-values", datastore.isMultilineValues());
        this.appendElement(datastoreElement, "header-line-number", datastore.getHeaderLineNumber());
        return datastoreElement;
    }

    public final Document getDocument() {
        return this._document;
    }

    public Element getDatastoreCatalogElement() {
        Element configurationFileDocumentElement = this.getDocumentElement();
        Element datastoreCatalogElement = this.getOrCreateChildElementByTagName(configurationFileDocumentElement, "datastore-catalog");
        if (datastoreCatalogElement == null) {
            throw new IllegalStateException("Could not find <datastore-catalog> element in configuration file");
        }
        return datastoreCatalogElement;
    }

    private Element getDocumentElement() {
        Document document = this.getDocument();
        Element documentElement = document.getDocumentElement();
        if (documentElement == null) {
            documentElement = document.createElement("configuration");
            document.appendChild(documentElement);
        }
        return documentElement;
    }

    private Element getOrCreateChildElementByTagName(Element element, String tagName) {
        Element elem = this.getChildElementByTagName(element, tagName);
        if (elem == null) {
            elem = this.getDocument().createElement(tagName);
            Element configurationFileDocumentElement = this.getDocumentElement();
            configurationFileDocumentElement.appendChild(elem);
        }
        return elem;
    }

    private Element getChildElementByTagName(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    private void appendElement(Element parent, String elementName, Object value) {
        if (value == null) {
            return;
        }
        String stringValue = value.toString();
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            if (c == '\uffff') {
                stringValue = "NOT_A_CHAR";
            } else if (c == '\t') {
                stringValue = "\\t";
            } else if (c == '\n') {
                stringValue = "\\n";
            } else if (c == '\r') {
                stringValue = "\\r";
            }
        }
        Element element = this.getDocument().createElement(elementName);
        element.setTextContent(stringValue);
        parent.appendChild(element);
    }
}

