/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.xml.XmlSaxTableDef;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.configuration.AnalyzerBeansConfigurationImpl;
import org.datacleaner.configuration.ConfigurationReader;
import org.datacleaner.configuration.ConfigurationReaderInterceptor;
import org.datacleaner.configuration.DefaultConfigurationReaderInterceptor;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.JaxbPojoDatastoreAdaptor;
import org.datacleaner.configuration.jaxb.AbstractDatastoreType;
import org.datacleaner.configuration.jaxb.AccessDatastoreType;
import org.datacleaner.configuration.jaxb.BerkeleyDbStorageProviderType;
import org.datacleaner.configuration.jaxb.CassandraDatastoreType;
import org.datacleaner.configuration.jaxb.ClasspathScannerType;
import org.datacleaner.configuration.jaxb.CombinedStorageProviderType;
import org.datacleaner.configuration.jaxb.CompositeDatastoreType;
import org.datacleaner.configuration.jaxb.Configuration;
import org.datacleaner.configuration.jaxb.ConfigurationMetadataType;
import org.datacleaner.configuration.jaxb.CouchdbDatastoreType;
import org.datacleaner.configuration.jaxb.CsvDatastoreType;
import org.datacleaner.configuration.jaxb.CustomElementType;
import org.datacleaner.configuration.jaxb.DatastoreCatalogType;
import org.datacleaner.configuration.jaxb.DatastoreDictionaryType;
import org.datacleaner.configuration.jaxb.DatastoreSynonymCatalogType;
import org.datacleaner.configuration.jaxb.DbaseDatastoreType;
import org.datacleaner.configuration.jaxb.ElasticSearchDatastoreType;
import org.datacleaner.configuration.jaxb.ExcelDatastoreType;
import org.datacleaner.configuration.jaxb.FixedWidthDatastoreType;
import org.datacleaner.configuration.jaxb.H2StorageProviderType;
import org.datacleaner.configuration.jaxb.HbaseDatastoreType;
import org.datacleaner.configuration.jaxb.HsqldbStorageProviderType;
import org.datacleaner.configuration.jaxb.InMemoryStorageProviderType;
import org.datacleaner.configuration.jaxb.JdbcDatastoreType;
import org.datacleaner.configuration.jaxb.JsonDatastoreType;
import org.datacleaner.configuration.jaxb.MongodbDatastoreType;
import org.datacleaner.configuration.jaxb.MultithreadedTaskrunnerType;
import org.datacleaner.configuration.jaxb.ObjectFactory;
import org.datacleaner.configuration.jaxb.OpenOfficeDatabaseDatastoreType;
import org.datacleaner.configuration.jaxb.PojoDatastoreType;
import org.datacleaner.configuration.jaxb.ReferenceDataCatalogType;
import org.datacleaner.configuration.jaxb.RegexPatternType;
import org.datacleaner.configuration.jaxb.SalesforceDatastoreType;
import org.datacleaner.configuration.jaxb.SasDatastoreType;
import org.datacleaner.configuration.jaxb.SimplePatternType;
import org.datacleaner.configuration.jaxb.SinglethreadedTaskrunnerType;
import org.datacleaner.configuration.jaxb.StorageProviderType;
import org.datacleaner.configuration.jaxb.SugarCrmDatastoreType;
import org.datacleaner.configuration.jaxb.TableTypeEnum;
import org.datacleaner.configuration.jaxb.TextFileDictionaryType;
import org.datacleaner.configuration.jaxb.TextFileSynonymCatalogType;
import org.datacleaner.configuration.jaxb.ValueListDictionaryType;
import org.datacleaner.configuration.jaxb.XmlDatastoreType;
import org.datacleaner.connection.AccessDatastore;
import org.datacleaner.connection.CassandraDatastore;
import org.datacleaner.connection.CompositeDatastore;
import org.datacleaner.connection.CouchDbDatastore;
import org.datacleaner.connection.CsvDatastore;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreCatalogImpl;
import org.datacleaner.connection.DbaseDatastore;
import org.datacleaner.connection.ElasticSearchDatastore;
import org.datacleaner.connection.ExcelDatastore;
import org.datacleaner.connection.FixedWidthDatastore;
import org.datacleaner.connection.HBaseDatastore;
import org.datacleaner.connection.JdbcDatastore;
import org.datacleaner.connection.JsonDatastore;
import org.datacleaner.connection.MongoDbDatastore;
import org.datacleaner.connection.OdbDatastore;
import org.datacleaner.connection.PojoDatastore;
import org.datacleaner.connection.SalesforceDatastore;
import org.datacleaner.connection.SasDatastore;
import org.datacleaner.connection.SugarCrmDatastore;
import org.datacleaner.connection.XmlDatastore;
import org.datacleaner.descriptors.ClasspathScanDescriptorProvider;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.job.concurrent.MultiThreadedTaskRunner;
import org.datacleaner.job.concurrent.SingleThreadedTaskRunner;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.reference.DatastoreDictionary;
import org.datacleaner.reference.DatastoreSynonymCatalog;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.ReferenceData;
import org.datacleaner.reference.ReferenceDataCatalog;
import org.datacleaner.reference.ReferenceDataCatalogImpl;
import org.datacleaner.reference.RegexStringPattern;
import org.datacleaner.reference.SimpleDictionary;
import org.datacleaner.reference.SimpleStringPattern;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.reference.TextFileDictionary;
import org.datacleaner.reference.TextFileSynonymCatalog;
import org.datacleaner.storage.BerkeleyDbStorageProvider;
import org.datacleaner.storage.CombinedStorageProvider;
import org.datacleaner.storage.H2StorageProvider;
import org.datacleaner.storage.HsqldbStorageProvider;
import org.datacleaner.storage.InMemoryStorageProvider;
import org.datacleaner.storage.StorageProvider;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.JaxbValidationEventHandler;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.convert.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaxbConfigurationReader
implements ConfigurationReader<InputStream> {
    private static final Logger logger = LoggerFactory.getLogger(JaxbConfigurationReader.class);
    private final JAXBContext _jaxbContext;
    private final ConfigurationReaderInterceptor _interceptor;
    private final Deque<String> _variablePathBuilder;

    public JaxbConfigurationReader() {
        this(null);
    }

    public JaxbConfigurationReader(ConfigurationReaderInterceptor configurationReaderCallback) {
        if (configurationReaderCallback == null) {
            configurationReaderCallback = new DefaultConfigurationReaderInterceptor();
        }
        this._interceptor = configurationReaderCallback;
        this._variablePathBuilder = new ArrayDeque<String>(4);
        try {
            this._jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public AnalyzerBeansConfiguration read(InputStream input) {
        return this.create(input);
    }

    public AnalyzerBeansConfiguration create(FileObject file) {
        AnalyzerBeansConfiguration analyzerBeansConfiguration;
        InputStream inputStream = null;
        try {
            inputStream = file.getContent().getInputStream();
            analyzerBeansConfiguration = this.create(inputStream);
        }
        catch (FileSystemException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analyzerBeansConfiguration;
    }

    public AnalyzerBeansConfiguration create(File file) {
        AnalyzerBeansConfiguration analyzerBeansConfiguration;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            analyzerBeansConfiguration = this.create(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analyzerBeansConfiguration;
    }

    public AnalyzerBeansConfiguration create(InputStream inputStream) {
        Configuration configuration = this.unmarshall(inputStream);
        return this.create(configuration);
    }

    public Configuration unmarshall(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Configuration configuration = (Configuration)unmarshaller.unmarshal(inputStream);
            return configuration;
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public void marshall(Configuration configuration, OutputStream outputStream) {
        try {
            Marshaller marshaller = this._jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            marshaller.marshal((Object)configuration, outputStream);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public AnalyzerBeansConfiguration create(Configuration configuration) {
        ConfigurationMetadataType metadata = configuration.getConfigurationMetadata();
        if (metadata != null) {
            logger.info("Configuration name: {}", (Object)metadata.getConfigurationName());
            logger.info("Configuration version: {}", (Object)metadata.getConfigurationVersion());
            logger.info("Configuration description: {}", (Object)metadata.getConfigurationDescription());
            logger.info("Author: {}", (Object)metadata.getAuthor());
            logger.info("Created date: {}", (Object)metadata.getCreatedDate());
            logger.info("Updated date: {}", (Object)metadata.getUpdatedDate());
        }
        AnalyzerBeansConfigurationImpl analyzerBeansConfiguration = this._interceptor.createBaseConfiguration();
        InjectionManager injectionManager = analyzerBeansConfiguration.getInjectionManager(null);
        TaskRunner taskRunner = this.createTaskRunner(configuration, injectionManager);
        analyzerBeansConfiguration = analyzerBeansConfiguration.replace(taskRunner);
        injectionManager = analyzerBeansConfiguration.getInjectionManager(null);
        DescriptorProvider descriptorProvider = this.createDescriptorProvider(configuration, taskRunner, injectionManager);
        analyzerBeansConfiguration = analyzerBeansConfiguration.replace(descriptorProvider);
        injectionManager = analyzerBeansConfiguration.getInjectionManager(null);
        this.addVariablePath("datastoreCatalog");
        DatastoreCatalog datastoreCatalog = this.createDatastoreCatalog(configuration.getDatastoreCatalog(), injectionManager);
        this.removeVariablePath();
        analyzerBeansConfiguration = analyzerBeansConfiguration.replace(datastoreCatalog);
        injectionManager = analyzerBeansConfiguration.getInjectionManager(null);
        this.addVariablePath("referenceDataCatalog");
        ReferenceDataCatalog referenceDataCatalog = this.createReferenceDataCatalog(configuration.getReferenceDataCatalog(), injectionManager);
        this.removeVariablePath();
        analyzerBeansConfiguration = analyzerBeansConfiguration.replace(referenceDataCatalog);
        injectionManager = analyzerBeansConfiguration.getInjectionManager(null);
        StorageProvider storageProvider = this.createStorageProvider(configuration.getStorageProvider(), injectionManager);
        analyzerBeansConfiguration = analyzerBeansConfiguration.replace(storageProvider);
        return analyzerBeansConfiguration;
    }

    private DescriptorProvider createDescriptorProvider(Configuration configuration, TaskRunner taskRunner, InjectionManager injectionManager) {
        DescriptorProvider descriptorProvider;
        CustomElementType customDescriptorProviderElement = configuration.getCustomDescriptorProvider();
        ClasspathScannerType classpathScannerElement = configuration.getClasspathScanner();
        if (customDescriptorProviderElement != null) {
            descriptorProvider = this.createCustomElement(customDescriptorProviderElement, DescriptorProvider.class, injectionManager, true);
        } else {
            HashSet<Class> excludedRenderingFormats = new HashSet<Class>();
            if (classpathScannerElement != null) {
                List<String> excludedRenderingFormatList = classpathScannerElement.getExcludedRenderingFormat();
                for (String excludedRenderingFormat : excludedRenderingFormatList) {
                    try {
                        Class cls = this._interceptor.loadClass(excludedRenderingFormat);
                        excludedRenderingFormats.add(cls);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Could not find excluded rendering format class: " + excludedRenderingFormat, (Throwable)e);
                    }
                }
            }
            ClasspathScanDescriptorProvider classpathScanner = new ClasspathScanDescriptorProvider(taskRunner, excludedRenderingFormats);
            if (classpathScannerElement != null) {
                List<ClasspathScannerType.Package> packages = classpathScannerElement.getPackage();
                for (ClasspathScannerType.Package pkg : packages) {
                    String packageName = pkg.getValue();
                    if (packageName == null) continue;
                    packageName = packageName.trim();
                    Boolean recursive = pkg.isRecursive();
                    if (recursive == null) {
                        recursive = true;
                    }
                    classpathScanner.scanPackage(packageName, recursive.booleanValue());
                }
            }
            descriptorProvider = classpathScanner;
        }
        return descriptorProvider;
    }

    private StorageProvider createStorageProvider(StorageProviderType storageProviderType, InjectionManager injectionManager) {
        if (storageProviderType == null) {
            return new InMemoryStorageProvider();
        }
        CombinedStorageProviderType combinedStorageProvider = storageProviderType.getCombined();
        if (combinedStorageProvider != null) {
            StorageProviderType collectionsStorage = combinedStorageProvider.getCollectionsStorage();
            StorageProviderType rowAnnotationStorage = combinedStorageProvider.getRowAnnotationStorage();
            StorageProvider collectionsStorageProvider = this.createStorageProvider(collectionsStorage, injectionManager);
            StorageProvider rowAnnotationStorageProvider = this.createStorageProvider(rowAnnotationStorage, injectionManager);
            return new CombinedStorageProvider(collectionsStorageProvider, rowAnnotationStorageProvider);
        }
        InMemoryStorageProviderType inMemoryStorageProvider = storageProviderType.getInMemory();
        if (inMemoryStorageProvider != null) {
            int maxRowsThreshold = inMemoryStorageProvider.getMaxRowsThreshold();
            return new InMemoryStorageProvider(maxRowsThreshold);
        }
        CustomElementType customStorageProvider = storageProviderType.getCustomStorageProvider();
        if (customStorageProvider != null) {
            return this.createCustomElement(customStorageProvider, StorageProvider.class, injectionManager, true);
        }
        BerkeleyDbStorageProviderType berkeleyDbStorageProvider = storageProviderType.getBerkeleyDb();
        if (berkeleyDbStorageProvider != null) {
            File parentDirectory = new File(this._interceptor.getTemporaryStorageDirectory());
            BerkeleyDbStorageProvider storageProvider = new BerkeleyDbStorageProvider(parentDirectory);
            Boolean cleanDirectoryOnStartup = berkeleyDbStorageProvider.isCleanDirectoryOnStartup();
            if (cleanDirectoryOnStartup != null && cleanDirectoryOnStartup.booleanValue()) {
                storageProvider.cleanDirectory();
            }
            return storageProvider;
        }
        HsqldbStorageProviderType hsqldbStorageProvider = storageProviderType.getHsqldb();
        if (hsqldbStorageProvider != null) {
            String directoryPath = hsqldbStorageProvider.getTempDirectory();
            if (directoryPath == null) {
                directoryPath = this._interceptor.getTemporaryStorageDirectory();
            }
            if ((directoryPath = this.createFilename(directoryPath)) == null) {
                return new HsqldbStorageProvider();
            }
            return new HsqldbStorageProvider(directoryPath);
        }
        H2StorageProviderType h2StorageProvider = storageProviderType.getH2Database();
        if (h2StorageProvider != null) {
            String directoryPath = h2StorageProvider.getTempDirectory();
            if (directoryPath == null) {
                directoryPath = this._interceptor.getTemporaryStorageDirectory();
            }
            if ((directoryPath = this.createFilename(directoryPath)) == null) {
                return new H2StorageProvider();
            }
            return new H2StorageProvider(directoryPath);
        }
        throw new IllegalStateException("Unknown storage provider type: " + storageProviderType);
    }

    private String createFilename(String filename) {
        return this._interceptor.createFilename(filename);
    }

    private ReferenceDataCatalog createReferenceDataCatalog(ReferenceDataCatalogType referenceDataCatalog, InjectionManager injectionManager) {
        ArrayList<Object> dictionaryList = new ArrayList<Object>();
        ArrayList<Object> synonymCatalogList = new ArrayList<Object>();
        ArrayList<Object> stringPatterns = new ArrayList<Object>();
        if (referenceDataCatalog != null) {
            ReferenceDataCatalogType.StringPatterns stringPatternTypes;
            ReferenceDataCatalogType.SynonymCatalogs synonymCatalogs;
            ReferenceDataCatalogType.Dictionaries dictionaries = referenceDataCatalog.getDictionaries();
            if (dictionaries != null) {
                for (Object dictionaryType : dictionaries.getTextFileDictionaryOrValueListDictionaryOrDatastoreDictionary()) {
                    String name;
                    if (dictionaryType instanceof DatastoreDictionaryType) {
                        DatastoreDictionaryType datastoreDictionaryType = (DatastoreDictionaryType)dictionaryType;
                        name = datastoreDictionaryType.getName();
                        JaxbConfigurationReader.checkName(name, Dictionary.class, dictionaryList);
                        this.addVariablePath(name);
                        String dsName = this.getStringVariable("datastoreName", datastoreDictionaryType.getDatastoreName());
                        String columnPath = this.getStringVariable("columnPath", datastoreDictionaryType.getColumnPath());
                        DatastoreDictionary dict = new DatastoreDictionary(name, dsName, columnPath);
                        dict.setDescription(datastoreDictionaryType.getDescription());
                        dictionaryList.add(dict);
                        this.removeVariablePath();
                        continue;
                    }
                    if (dictionaryType instanceof TextFileDictionaryType) {
                        TextFileDictionaryType textFileDictionaryType = (TextFileDictionaryType)dictionaryType;
                        name = textFileDictionaryType.getName();
                        JaxbConfigurationReader.checkName(name, Dictionary.class, dictionaryList);
                        this.addVariablePath(name);
                        String filenamePath = this.getStringVariable("filename", textFileDictionaryType.getFilename());
                        String filename = this.createFilename(filenamePath);
                        String encoding = this.getStringVariable("encoding", textFileDictionaryType.getEncoding());
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        TextFileDictionary dict = new TextFileDictionary(name, filename, encoding);
                        dict.setDescription(textFileDictionaryType.getDescription());
                        dictionaryList.add(dict);
                        this.removeVariablePath();
                        continue;
                    }
                    if (dictionaryType instanceof ValueListDictionaryType) {
                        ValueListDictionaryType valueListDictionaryType = (ValueListDictionaryType)dictionaryType;
                        name = valueListDictionaryType.getName();
                        JaxbConfigurationReader.checkName(name, Dictionary.class, dictionaryList);
                        List<String> values = valueListDictionaryType.getValue();
                        SimpleDictionary dict = new SimpleDictionary(name, values);
                        dict.setDescription(valueListDictionaryType.getDescription());
                        dictionaryList.add(dict);
                        continue;
                    }
                    if (dictionaryType instanceof CustomElementType) {
                        Dictionary dictionary = this.createCustomElement((CustomElementType)dictionaryType, Dictionary.class, injectionManager, false);
                        JaxbConfigurationReader.checkName(dictionary.getName(), Dictionary.class, dictionaryList);
                        dictionaryList.add(dictionary);
                        continue;
                    }
                    throw new IllegalStateException("Unsupported dictionary type: " + dictionaryType);
                }
            }
            if ((synonymCatalogs = referenceDataCatalog.getSynonymCatalogs()) != null) {
                for (Object e : synonymCatalogs.getTextFileSynonymCatalogOrDatastoreSynonymCatalogOrCustomSynonymCatalog()) {
                    String name;
                    if (e instanceof TextFileSynonymCatalogType) {
                        TextFileSynonymCatalogType tfsct = (TextFileSynonymCatalogType)e;
                        name = tfsct.getName();
                        JaxbConfigurationReader.checkName(name, SynonymCatalog.class, synonymCatalogList);
                        this.addVariablePath(name);
                        String filenamePath = this.getStringVariable("filename", tfsct.getFilename());
                        String filename = this.createFilename(filenamePath);
                        String encoding = this.getStringVariable("encoding", tfsct.getEncoding());
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        boolean caseSensitive = this.getBooleanVariable("caseSensitive", tfsct.isCaseSensitive(), true);
                        TextFileSynonymCatalog sc = new TextFileSynonymCatalog(name, filename, caseSensitive, encoding);
                        sc.setDescription(tfsct.getDescription());
                        synonymCatalogList.add(sc);
                        this.removeVariablePath();
                        continue;
                    }
                    if (e instanceof CustomElementType) {
                        SynonymCatalog customSynonymCatalog = this.createCustomElement((CustomElementType)e, SynonymCatalog.class, injectionManager, false);
                        JaxbConfigurationReader.checkName(customSynonymCatalog.getName(), SynonymCatalog.class, synonymCatalogList);
                        synonymCatalogList.add(customSynonymCatalog);
                        continue;
                    }
                    if (e instanceof DatastoreSynonymCatalogType) {
                        DatastoreSynonymCatalogType datastoreSynonymCatalogType = (DatastoreSynonymCatalogType)e;
                        name = datastoreSynonymCatalogType.getName();
                        JaxbConfigurationReader.checkName(name, SynonymCatalog.class, synonymCatalogList);
                        this.addVariablePath(name);
                        String dataStoreName = this.getStringVariable("datastoreName", datastoreSynonymCatalogType.getDatastoreName());
                        String masterTermColumnPath = this.getStringVariable("masterTermColumnPath", datastoreSynonymCatalogType.getMasterTermColumnPath());
                        String[] synonymColumnPaths = datastoreSynonymCatalogType.getSynonymColumnPath().toArray(new String[0]);
                        DatastoreSynonymCatalog sc = new DatastoreSynonymCatalog(name, dataStoreName, masterTermColumnPath, synonymColumnPaths);
                        sc.setDescription(datastoreSynonymCatalogType.getDescription());
                        synonymCatalogList.add(sc);
                        this.removeVariablePath();
                        continue;
                    }
                    throw new IllegalStateException("Unsupported synonym catalog type: " + e);
                }
            }
            if ((stringPatternTypes = referenceDataCatalog.getStringPatterns()) != null) {
                for (Object obj : stringPatternTypes.getRegexPatternOrSimplePattern()) {
                    String expression;
                    String name;
                    if (obj instanceof RegexPatternType) {
                        RegexPatternType regexPatternType = (RegexPatternType)obj;
                        name = regexPatternType.getName();
                        JaxbConfigurationReader.checkName(name, StringPattern.class, stringPatterns);
                        this.addVariablePath(name);
                        expression = this.getStringVariable("expression", regexPatternType.getExpression());
                        boolean matchEntireString = this.getBooleanVariable("matchEntireString", regexPatternType.isMatchEntireString(), true);
                        RegexStringPattern sp = new RegexStringPattern(name, expression, matchEntireString);
                        sp.setDescription(regexPatternType.getDescription());
                        stringPatterns.add(sp);
                        this.removeVariablePath();
                        continue;
                    }
                    if (obj instanceof SimplePatternType) {
                        SimplePatternType simplePatternType = (SimplePatternType)obj;
                        name = simplePatternType.getName();
                        JaxbConfigurationReader.checkName(name, StringPattern.class, stringPatterns);
                        this.addVariablePath(name);
                        expression = this.getStringVariable("expression", simplePatternType.getExpression());
                        SimpleStringPattern sp = new SimpleStringPattern(name, expression);
                        sp.setDescription(simplePatternType.getDescription());
                        stringPatterns.add(sp);
                        this.removeVariablePath();
                        continue;
                    }
                    throw new IllegalStateException("Unsupported string pattern type: " + obj);
                }
            }
        }
        return new ReferenceDataCatalogImpl(dictionaryList, synonymCatalogList, stringPatterns);
    }

    private DatastoreCatalog createDatastoreCatalog(DatastoreCatalogType datastoreCatalogType, InjectionManager injectionManager) {
        String name;
        Datastore ds;
        HashMap<String, Object> datastores = new HashMap<String, Object>();
        List<AbstractDatastoreType> datastoreTypes = datastoreCatalogType.getJdbcDatastoreOrAccessDatastoreOrCsvDatastore();
        for (AbstractDatastoreType abstractDatastoreType : datastoreTypes) {
            String string = abstractDatastoreType.getName();
            JaxbConfigurationReader.checkName(string, Datastore.class, datastores);
            this.addVariablePath(string);
            if (abstractDatastoreType instanceof CsvDatastoreType) {
                ds = this.createDatastore(string, (CsvDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof JdbcDatastoreType) {
                ds = this.createDatastore(string, (JdbcDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof FixedWidthDatastoreType) {
                ds = this.createDatastore(string, (FixedWidthDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof SasDatastoreType) {
                ds = this.createDatastore(string, (SasDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof AccessDatastoreType) {
                ds = this.createDatastore(string, (AccessDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof XmlDatastoreType) {
                ds = this.createDatastore(string, (XmlDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof ExcelDatastoreType) {
                ds = this.createDatastore(string, (ExcelDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof JsonDatastoreType) {
                ds = this.createDatastore(string, (JsonDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof DbaseDatastoreType) {
                ds = this.createDatastore(string, (DbaseDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof OpenOfficeDatabaseDatastoreType) {
                ds = this.createDatastore(string, (OpenOfficeDatabaseDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof PojoDatastoreType) {
                ds = this.createDatastore(string, (PojoDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof CouchdbDatastoreType) {
                ds = this.createDatastore(string, (CouchdbDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof MongodbDatastoreType) {
                ds = this.createDatastore(string, (MongodbDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof ElasticSearchDatastoreType) {
                ds = this.createDatastore(string, (ElasticSearchDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof CassandraDatastoreType) {
                ds = this.createDatastore(string, (CassandraDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof HbaseDatastoreType) {
                ds = this.createDatastore(string, (HbaseDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof SalesforceDatastoreType) {
                ds = this.createDatastore(string, (SalesforceDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof SugarCrmDatastoreType) {
                ds = this.createDatastore(string, (SugarCrmDatastoreType)abstractDatastoreType);
            } else {
                if (abstractDatastoreType instanceof CompositeDatastoreType) continue;
                throw new UnsupportedOperationException("Unsupported datastore type: " + abstractDatastoreType);
            }
            String datastoreDescription = abstractDatastoreType.getDescription();
            ds.setDescription(datastoreDescription);
            this.removeVariablePath();
            datastores.put(string, ds);
        }
        List<CustomElementType> customDatastores = datastoreCatalogType.getCustomDatastore();
        for (CustomElementType customElementType : customDatastores) {
            ds = this.createCustomElement(customElementType, Datastore.class, injectionManager, true);
            name = ds.getName();
            JaxbConfigurationReader.checkName(name, Datastore.class, datastores);
            datastores.put(name, ds);
        }
        List list = CollectionUtils2.filterOnClass(datastoreTypes, CompositeDatastoreType.class);
        for (CompositeDatastoreType compositeDatastoreType : list) {
            name = compositeDatastoreType.getName();
            JaxbConfigurationReader.checkName(name, Datastore.class, datastores);
            List<String> datastoreNames = compositeDatastoreType.getDatastoreName();
            ArrayList<Datastore> childDatastores = new ArrayList<Datastore>(datastoreNames.size());
            for (String datastoreName : datastoreNames) {
                Datastore datastore = (Datastore)datastores.get(datastoreName);
                if (datastore == null) {
                    throw new IllegalStateException("No such datastore: " + datastoreName + " (found in composite datastore: " + name + ")");
                }
                childDatastores.add(datastore);
            }
            CompositeDatastore ds2 = new CompositeDatastore(name, childDatastores);
            ds2.setDescription(compositeDatastoreType.getDescription());
            datastores.put(name, ds2);
        }
        DatastoreCatalogImpl datastoreCatalogImpl = new DatastoreCatalogImpl(datastores.values());
        return datastoreCatalogImpl;
    }

    private Datastore createDatastore(String name, CassandraDatastoreType datastoreType) {
        SimpleTableDef[] tableDefs;
        String hostname = this.getStringVariable("hostname", datastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", datastoreType.getPort());
        if (port == null) {
            port = 9042;
        }
        String keySpace = this.getStringVariable("keyspace", datastoreType.getKeyspace());
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getStringVariable("password", datastoreType.getPassword());
        boolean ssl = this.getBooleanVariable("ssl", datastoreType.isSsl(), false);
        List<CassandraDatastoreType.TableDef> tableDefList = datastoreType.getTableDef();
        if (tableDefList == null || tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                CassandraDatastoreType.TableDef tableDef = tableDefList.get(i);
                String tableName = tableDef.getTableName();
                List<CassandraDatastoreType.TableDef.Column> columnList = tableDef.getColumn();
                String[] columnNames = new String[columnList.size()];
                ColumnType[] columnTypes = new ColumnType[columnList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = columnList.get(j).getName();
                    String propertyTypeName = columnList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    columnNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(tableName, columnNames, columnTypes);
            }
        }
        return new CassandraDatastore(name, hostname, port.intValue(), keySpace, username, password, ssl, tableDefs);
    }

    private Datastore createDatastore(String name, ElasticSearchDatastoreType datastoreType) {
        SimpleTableDef[] tableDefs;
        String clusterName = this.getStringVariable("clusterName", datastoreType.getClusterName());
        String hostname = this.getStringVariable("hostname", datastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", datastoreType.getPort());
        if (port == null) {
            port = 9300;
        }
        String indexName = this.getStringVariable("indexName", datastoreType.getIndexName());
        List<ElasticSearchDatastoreType.TableDef> tableDefList = datastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                ElasticSearchDatastoreType.TableDef tableDef = tableDefList.get(i);
                String docType = tableDef.getDocumentType();
                List<ElasticSearchDatastoreType.TableDef.Field> fieldList = tableDef.getField();
                String[] columnNames = new String[fieldList.size()];
                ColumnType[] columnTypes = new ColumnType[fieldList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = fieldList.get(j).getName();
                    String propertyTypeName = fieldList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    columnNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(docType, columnNames, columnTypes);
            }
        }
        return new ElasticSearchDatastore(name, hostname, port.intValue(), clusterName, indexName, tableDefs);
    }

    private Datastore createDatastore(String name, JsonDatastoreType datastoreType) {
        String filename = this.getStringVariable("filename", datastoreType.getFilename());
        Resource resource = this._interceptor.createResource(filename);
        return new JsonDatastore(name, resource);
    }

    private Datastore createDatastore(String name, HbaseDatastoreType datastoreType) {
        SimpleTableDef[] tableDefs;
        String zookeeperHostname = this.getStringVariable("zookeeperHostname", datastoreType.getZookeeperHostname());
        int zookeeperPort = this.getIntegerVariable("zookeeperPort", datastoreType.getZookeeperPort());
        List<HbaseDatastoreType.TableDef> tableDefList = datastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                HbaseDatastoreType.TableDef tableDef = tableDefList.get(i);
                String tableName = tableDef.getName();
                List<HbaseDatastoreType.TableDef.Column> columnList = tableDef.getColumn();
                String[] columnNames = new String[columnList.size()];
                ColumnType[] columnTypes = new ColumnType[columnList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    HbaseDatastoreType.TableDef.Column column = columnList.get(j);
                    String family = column.getFamily();
                    String columnName = Strings.isNullOrEmpty((String)family) ? column.getName() : family + ":" + column.getName();
                    String columnTypeName = column.getType();
                    ColumnType columnType = StringUtils.isNullOrEmpty((String)columnTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)columnTypeName);
                    columnNames[j] = columnName;
                    columnTypes[j] = columnType;
                }
                tableDefs[i] = new SimpleTableDef(tableName, columnNames, columnTypes);
            }
        }
        return new HBaseDatastore(name, zookeeperHostname, zookeeperPort, tableDefs);
    }

    private Datastore createDatastore(String name, SalesforceDatastoreType datastoreType) {
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getStringVariable("password", datastoreType.getPassword());
        String securityToken = this.getStringVariable("securityToken", datastoreType.getSecurityToken());
        return new SalesforceDatastore(name, username, password, securityToken);
    }

    private Datastore createDatastore(String name, SugarCrmDatastoreType datastoreType) {
        String baseUrl = this.getStringVariable("baseUrl", datastoreType.getBaseUrl());
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getStringVariable("password", datastoreType.getPassword());
        return new SugarCrmDatastore(name, baseUrl, username, password);
    }

    private Datastore createDatastore(String name, MongodbDatastoreType mongodbDatastoreType) {
        SimpleTableDef[] tableDefs;
        String hostname = this.getStringVariable("hostname", mongodbDatastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", mongodbDatastoreType.getPort());
        String databaseName = this.getStringVariable("databaseName", mongodbDatastoreType.getDatabaseName());
        String username = this.getStringVariable("username", mongodbDatastoreType.getUsername());
        String password = this.getStringVariable("password", mongodbDatastoreType.getPassword());
        List<MongodbDatastoreType.TableDef> tableDefList = mongodbDatastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                MongodbDatastoreType.TableDef tableDef = tableDefList.get(i);
                String collectionName = tableDef.getCollection();
                List<MongodbDatastoreType.TableDef.Property> propertyList = tableDef.getProperty();
                String[] propertyNames = new String[propertyList.size()];
                ColumnType[] columnTypes = new ColumnType[propertyList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = propertyList.get(j).getName();
                    String propertyTypeName = propertyList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    propertyNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(collectionName, propertyNames, columnTypes);
            }
        }
        MongoDbDatastore ds = new MongoDbDatastore(name, hostname, port, databaseName, username, password, tableDefs);
        return ds;
    }

    private Datastore createDatastore(String name, CouchdbDatastoreType couchdbDatastoreType) {
        SimpleTableDef[] tableDefs;
        String hostname = this.getStringVariable("hostname", couchdbDatastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", couchdbDatastoreType.getPort());
        String username = this.getStringVariable("username", couchdbDatastoreType.getUsername());
        String password = this.getStringVariable("password", couchdbDatastoreType.getPassword());
        boolean sslEnabled = this.getBooleanVariable("ssl", couchdbDatastoreType.isSsl(), false);
        List<CouchdbDatastoreType.TableDef> tableDefList = couchdbDatastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                CouchdbDatastoreType.TableDef tableDef = tableDefList.get(i);
                String databaseName = tableDef.getDatabase();
                List<CouchdbDatastoreType.TableDef.Field> fieldList = tableDef.getField();
                String[] propertyNames = new String[fieldList.size()];
                ColumnType[] columnTypes = new ColumnType[fieldList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = fieldList.get(j).getName();
                    String propertyTypeName = fieldList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    propertyNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(databaseName, propertyNames, columnTypes);
            }
        }
        CouchDbDatastore ds = new CouchDbDatastore(name, hostname, port, username, password, sslEnabled, tableDefs);
        return ds;
    }

    private Datastore createDatastore(String name, PojoDatastoreType pojoDatastore) {
        JaxbPojoDatastoreAdaptor adaptor = new JaxbPojoDatastoreAdaptor();
        PojoDatastore datastore = adaptor.read(pojoDatastore);
        return datastore;
    }

    private Datastore createDatastore(String name, OpenOfficeDatabaseDatastoreType odbDatastoreType) {
        String filenamePath = this.getStringVariable("filename", odbDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        OdbDatastore ds = new OdbDatastore(name, filename);
        return ds;
    }

    private Datastore createDatastore(String name, DbaseDatastoreType dbaseDatastoreType) {
        String filenamePath = this.getStringVariable("filename", dbaseDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        DbaseDatastore ds = new DbaseDatastore(name, filename);
        return ds;
    }

    private Datastore createDatastore(String name, ExcelDatastoreType excelDatastoreType) {
        String filename = this.getStringVariable("filename", excelDatastoreType.getFilename());
        Resource resource = this._interceptor.createResource(filename);
        ExcelDatastore ds = new ExcelDatastore(name, resource, filename);
        return ds;
    }

    private Datastore createDatastore(String name, XmlDatastoreType xmlDatastoreType) {
        XmlSaxTableDef[] tableDefs;
        String filenamePath = this.getStringVariable("filename", xmlDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        List<XmlDatastoreType.TableDef> tableDefList = xmlDatastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new XmlSaxTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                String rowXpath = tableDefList.get(i).getRowXpath();
                String[] valueXpaths = tableDefList.get(i).getValueXpath().toArray(new String[0]);
                tableDefs[i] = new XmlSaxTableDef(rowXpath, valueXpaths);
            }
        }
        XmlDatastore ds = new XmlDatastore(name, filename, tableDefs);
        return ds;
    }

    private Datastore createDatastore(String name, AccessDatastoreType accessDatastoreType) {
        String filenamePath = this.getStringVariable("filename", accessDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        AccessDatastore ds = new AccessDatastore(name, filename);
        return ds;
    }

    private Datastore createDatastore(String name, SasDatastoreType sasDatastoreType) {
        String directoryPath = this.getStringVariable("directory", sasDatastoreType.getDirectory());
        File directory = new File(directoryPath);
        SasDatastore ds = new SasDatastore(name, directory);
        return ds;
    }

    private Datastore createDatastore(String name, FixedWidthDatastoreType fixedWidthDatastore) {
        FixedWidthDatastore ds;
        FixedWidthDatastoreType.WidthSpecification widthSpecification;
        Integer fixedValueWidth;
        String filename = this._interceptor.createFilename(this.getStringVariable("filename", fixedWidthDatastore.getFilename()));
        String encoding = this.getStringVariable("encoding", fixedWidthDatastore.getEncoding());
        if (!StringUtils.isNullOrEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        boolean failOnInconsistencies = this.getBooleanVariable("failOnInconsistencies", fixedWidthDatastore.isFailOnInconsistencies(), true);
        Integer headerLineNumber = this.getIntegerVariable("headerLineNumber", fixedWidthDatastore.getHeaderLineNumber());
        if (headerLineNumber == null) {
            headerLineNumber = 1;
        }
        if ((fixedValueWidth = this.getIntegerVariable("fixedValueWidth", (widthSpecification = fixedWidthDatastore.getWidthSpecification()).getFixedValueWidth())) == null) {
            List<Integer> valueWidthsBoxed = widthSpecification.getValueWidth();
            int[] valueWidths = new int[valueWidthsBoxed.size()];
            for (int i = 0; i < valueWidths.length; ++i) {
                valueWidths[i] = valueWidthsBoxed.get(i);
            }
            ds = new FixedWidthDatastore(name, filename, encoding, valueWidths, failOnInconsistencies, headerLineNumber.intValue());
        } else {
            ds = new FixedWidthDatastore(name, filename, encoding, fixedValueWidth.intValue(), failOnInconsistencies, headerLineNumber.intValue());
        }
        return ds;
    }

    private Datastore createDatastore(String name, JdbcDatastoreType jdbcDatastoreType) {
        JdbcDatastore ds;
        TableType[] tableTypes;
        JdbcDatastoreType.TableTypes jaxbTableTypes = jdbcDatastoreType.getTableTypes();
        if (jaxbTableTypes == null) {
            tableTypes = null;
        } else {
            List<TableTypeEnum> jaxbTableTypeList = jaxbTableTypes.getTableType();
            tableTypes = new TableType[jaxbTableTypeList.size()];
            for (int i = 0; i < tableTypes.length; ++i) {
                TableTypeEnum tableTypeEnum = jaxbTableTypeList.get(i);
                tableTypes[i] = TableType.valueOf((String)tableTypeEnum.toString());
            }
        }
        String catalogName = this.getStringVariable("catalogName", jdbcDatastoreType.getCatalogName());
        String datasourceJndiUrl = this.getStringVariable("jndiUrl", jdbcDatastoreType.getDatasourceJndiUrl());
        if (datasourceJndiUrl == null) {
            String url = this.getStringVariable("url", jdbcDatastoreType.getUrl());
            String driver = this.getStringVariable("driver", jdbcDatastoreType.getDriver());
            String username = this.getStringVariable("username", jdbcDatastoreType.getUsername());
            String password = this.getStringVariable("password", jdbcDatastoreType.getPassword());
            boolean multipleConnections = this.getBooleanVariable("multipleConnections", jdbcDatastoreType.isMultipleConnections(), true);
            ds = new JdbcDatastore(name, url, driver, username, password, multipleConnections, tableTypes, catalogName);
        } else {
            ds = new JdbcDatastore(name, datasourceJndiUrl, tableTypes, catalogName);
        }
        return ds;
    }

    private Datastore createDatastore(String name, CsvDatastoreType csvDatastoreType) {
        String filename = this.getStringVariable("filename", csvDatastoreType.getFilename());
        Resource resource = this._interceptor.createResource(filename);
        String quoteCharString = this.getStringVariable("quoteChar", csvDatastoreType.getQuoteChar());
        char quoteChar = this.getChar(quoteCharString, '\"', '\uffff');
        String separatorCharString = this.getStringVariable("separatorChar", csvDatastoreType.getSeparatorChar());
        char separatorChar = this.getChar(separatorCharString, ',', '\uffff');
        String escapeCharString = this.getStringVariable("escapeChar", csvDatastoreType.getEscapeChar());
        char escapeChar = this.getChar(escapeCharString, '\\', '\uffff');
        String encoding = this.getStringVariable("encoding", csvDatastoreType.getEncoding());
        if (StringUtils.isNullOrEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        boolean failOnInconsistencies = this.getBooleanVariable("failOnInconsistencies", csvDatastoreType.isFailOnInconsistencies(), true);
        boolean multilineValues = this.getBooleanVariable("multilineValues", csvDatastoreType.isMultilineValues(), true);
        Integer headerLineNumber = this.getIntegerVariable("headerLineNumber", csvDatastoreType.getHeaderLineNumber());
        if (headerLineNumber == null) {
            headerLineNumber = 1;
        }
        CsvDatastore ds = new CsvDatastore(name, resource, filename, Character.valueOf(quoteChar), Character.valueOf(separatorChar), Character.valueOf(escapeChar), encoding, failOnInconsistencies, multilineValues, headerLineNumber.intValue());
        return ds;
    }

    private char getChar(String charString, char ifNull, char ifBlank) {
        if (charString == null) {
            return ifNull;
        }
        if ("".equals(charString)) {
            return ifBlank;
        }
        if (charString.length() == 1) {
            return charString.charAt(0);
        }
        if ("\\t".equals(charString)) {
            return '\t';
        }
        if ("\\\n".equals(charString)) {
            return '\n';
        }
        if ("\\r".equals(charString)) {
            return '\r';
        }
        if ("\\\\".equals(charString)) {
            return '\\';
        }
        if ("NOT_A_CHAR".equals(charString)) {
            return '\uffff';
        }
        logger.warn("Char string contained more than 1 character and was not identified as a special char: '{}'", (Object)charString);
        return charString.charAt(0);
    }

    private void addVariablePath(String name) {
        name = StringUtils.toCamelCase((String)name);
        this._variablePathBuilder.add(name);
    }

    private void removeVariablePath() {
        this._variablePathBuilder.pollLast();
    }

    private String getStringVariable(String key, String valueIfNull) {
        StringBuilder sb = new StringBuilder();
        for (String keyElement : this._variablePathBuilder) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(keyElement);
        }
        sb.append('.');
        sb.append(key);
        String variablePath = sb.toString();
        String value = this._interceptor.getPropertyOverride(variablePath);
        if (value == null) {
            return valueIfNull;
        }
        logger.info("Overriding variable '{}' with value: {}", (Object)variablePath, (Object)value);
        return value;
    }

    public Integer getIntegerVariable(String key, Integer valueIfNull) {
        String value = this.getStringVariable(key, null);
        if (value == null) {
            return valueIfNull;
        }
        return Integer.parseInt(value);
    }

    private boolean getBooleanVariable(String key, Boolean valueIfNull, boolean valueIfNull2) {
        String value = this.getStringVariable(key, null);
        if (StringUtils.isNullOrEmpty((String)value)) {
            if (valueIfNull == null) {
                return valueIfNull2;
            }
            return valueIfNull;
        }
        return Boolean.parseBoolean(value);
    }

    private static void checkName(String name, Class<?> type, Map<String, ?> previousEntries) throws IllegalStateException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalStateException(type.getSimpleName() + " name cannot be null");
        }
        if (previousEntries.containsKey(name)) {
            throw new IllegalStateException(type.getSimpleName() + " name is not unique: " + name);
        }
    }

    private static void checkName(String name, Class<?> type, List<? extends ReferenceData> previousEntries) throws IllegalStateException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalStateException(type.getSimpleName() + " name cannot be null");
        }
        for (ReferenceData referenceData : previousEntries) {
            if (!name.equals(referenceData.getName())) continue;
            throw new IllegalStateException(type.getSimpleName() + " name is not unique: " + name);
        }
    }

    private TaskRunner createTaskRunner(Configuration configuration, InjectionManager injectionManager) {
        Short maxThreads;
        SinglethreadedTaskrunnerType singlethreadedTaskrunner = configuration.getSinglethreadedTaskrunner();
        MultithreadedTaskrunnerType multithreadedTaskrunner = configuration.getMultithreadedTaskrunner();
        CustomElementType customTaskrunner = configuration.getCustomTaskrunner();
        Object taskRunner = singlethreadedTaskrunner != null ? new SingleThreadedTaskRunner() : (multithreadedTaskrunner != null ? ((maxThreads = multithreadedTaskrunner.getMaxThreads()) != null ? new MultiThreadedTaskRunner(maxThreads.intValue()) : new MultiThreadedTaskRunner()) : (customTaskrunner != null ? this.createCustomElement(customTaskrunner, TaskRunner.class, injectionManager, true) : new MultiThreadedTaskRunner()));
        return taskRunner;
    }

    private <E> E createCustomElement(CustomElementType customElementType, Class<E> expectedClazz, InjectionManager injectionManager, boolean initialize) {
        Class foundClass;
        String className = customElementType.getClassName();
        assert (className != null);
        try {
            foundClass = this._interceptor.loadClass(className);
        }
        catch (Exception e) {
            logger.error("Failed to load class: {}", (Object)className);
            throw new IllegalStateException(e);
        }
        if (!ReflectionUtils.is((Type)foundClass, expectedClazz)) {
            throw new IllegalStateException(className + " is not a valid " + expectedClazz);
        }
        Object result = ReflectionUtils.newInstance((Class)foundClass);
        ComponentDescriptor descriptor = Descriptors.ofComponent((Class)foundClass);
        StringConverter stringConverter = new StringConverter(injectionManager);
        List<CustomElementType.Property> propertyTypes = customElementType.getProperty();
        if (propertyTypes != null) {
            for (CustomElementType.Property property : propertyTypes) {
                String propertyName = property.getName();
                String propertyValue = property.getValue();
                ConfiguredPropertyDescriptor configuredProperty = descriptor.getConfiguredProperty(propertyName);
                if (configuredProperty == null) {
                    logger.warn("Missing configured property name: {}", (Object)propertyName);
                    if (logger.isInfoEnabled()) {
                        Set configuredProperties = descriptor.getConfiguredProperties();
                        for (ConfiguredPropertyDescriptor configuredPropertyDescriptor : configuredProperties) {
                            logger.info("Available configured property name: {}, {}", (Object)configuredPropertyDescriptor.getName(), (Object)configuredPropertyDescriptor.getType());
                        }
                    }
                    throw new IllegalStateException("No such property in " + foundClass.getName() + ": " + propertyName);
                }
                Object configuredValue = stringConverter.deserialize(propertyValue, configuredProperty.getType(), configuredProperty.getCustomConverter());
                configuredProperty.setValue(result, configuredValue);
            }
        }
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, null, true);
        lifeCycleHelper.assignProvidedProperties(descriptor, result);
        if (initialize) {
            lifeCycleHelper.initialize(descriptor, result);
        }
        return (E)result;
    }
}

