/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.pojo.ArrayTableDataProvider;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.configuration.jaxb.AbstractDatastoreType;
import org.datacleaner.configuration.jaxb.PojoDatastoreType;
import org.datacleaner.configuration.jaxb.PojoTableType;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.PojoDatastore;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.convert.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxbPojoDatastoreAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(JaxbPojoDatastoreAdaptor.class);
    private final StringConverter _converter = new StringConverter(null);

    public PojoDatastore read(PojoDatastoreType pojoDatastore) {
        String name = pojoDatastore.getName();
        String schemaName = pojoDatastore.getSchemaName() == null ? name : pojoDatastore.getSchemaName();
        ArrayList<ArrayTableDataProvider> tableDataProviders = new ArrayList<ArrayTableDataProvider>();
        List<PojoTableType> tables = pojoDatastore.getTable();
        for (PojoTableType table : tables) {
            String tableName = table.getName();
            List<PojoTableType.Columns.Column> columns = table.getColumns().getColumn();
            int columnCount = columns.size();
            String[] columnNames = new String[columnCount];
            ColumnType[] columnTypes = new ColumnType[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                PojoTableType.Columns.Column column = columns.get(i);
                columnNames[i] = column.getName();
                columnTypes[i] = ColumnTypeImpl.valueOf((String)column.getType());
            }
            SimpleTableDef tableDef = new SimpleTableDef(tableName, columnNames, columnTypes);
            ArrayList<Object[]> arrays = new ArrayList<Object[]>();
            PojoTableType.Rows rowsType = table.getRows();
            if (rowsType != null) {
                List<PojoTableType.Rows.Row> rows = rowsType.getRow();
                for (PojoTableType.Rows.Row row : rows) {
                    List<Object> values = row.getV();
                    if (values.size() != columnCount) {
                        throw new IllegalStateException("Row value count is not equal to column count in datastore '" + name + "'. Expected " + columnCount + " values, found " + values.size() + " (table " + tableName + ", row no. " + arrays.size() + ")");
                    }
                    Object[] array = new Object[columnCount];
                    for (int i = 0; i < array.length; ++i) {
                        Object value;
                        Class expectedClass = columnTypes[i].getJavaEquivalentClass();
                        Object rawValue = values.get(i);
                        array[i] = value = this.deserializeValue(rawValue, expectedClass);
                    }
                    arrays.add(array);
                }
            }
            ArrayTableDataProvider tableDataProvider = new ArrayTableDataProvider(tableDef, arrays);
            tableDataProviders.add(tableDataProvider);
        }
        PojoDatastore ds = new PojoDatastore(name, schemaName, tableDataProviders);
        return ds;
    }

    private Object deserializeValue(Object value, Class<?> expectedClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof Node) {
            Node node = (Node)value;
            logger.debug("Value is a DOM node: {}", (Object)node);
            return this.getNodeValue(node, expectedClass);
        }
        if (value instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)value;
            logger.debug("Value is a JAXBElement: {}", (Object)element);
            Object jaxbValue = element.getValue();
            return this.deserializeValue(jaxbValue, expectedClass);
        }
        if (value instanceof String) {
            String str = (String)value;
            return this._converter.deserialize(str, expectedClass);
        }
        throw new UnsupportedOperationException("Unknown value type: " + value);
    }

    private <T> T getNodeValue(Node node, Class<T> expectedClass) {
        if (node.getNodeType() == 3) {
            String str = node.getNodeValue();
            if (expectedClass == null) {
                expectedClass = String.class;
            }
            Object result = this._converter.deserialize(str, this.determineExpectedClass(node, expectedClass));
            return (T)result;
        }
        List<Node> childNodes = this.getChildNodes(node);
        if (childNodes.isEmpty()) {
            return null;
        }
        if (childNodes.size() == 1 && childNodes.get(0).getNodeType() == 3) {
            expectedClass = this.determineExpectedClass(node, expectedClass);
            Node child = childNodes.get(0);
            return (T)this.getNodeValue(child, expectedClass);
        }
        if (expectedClass == null) {
            Node firstChild = childNodes.get(0);
            if ("i".equals(firstChild.getNodeName())) {
                List<Object> list = this.getNodeList(childNodes);
                return (T)list;
            }
            if ("e".equals(firstChild.getNodeName())) {
                Map<String, Object> map = this.getNodeMap(childNodes);
                return (T)map;
            }
            throw new UnsupportedOperationException("Unexpected child nodes. First child: " + this.printNode(firstChild));
        }
        if (ReflectionUtils.is(expectedClass, List.class)) {
            List<Object> list = this.getNodeList(childNodes);
            return (T)list;
        }
        if (ReflectionUtils.is(expectedClass, Map.class)) {
            Map<String, Object> map = this.getNodeMap(childNodes);
            return (T)map;
        }
        if (expectedClass.isArray()) {
            List<Object> list = this.getNodeList(childNodes);
            Class<?> componentType = expectedClass.getComponentType();
            return (T)CollectionUtils2.toArray(list, componentType);
        }
        throw new UnsupportedOperationException("Not a value (v) node type: " + this.printNode(node));
    }

    private Class<?> determineExpectedClass(Node node, Class<?> fallbackType) {
        String className;
        Node attribute;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem("class")) != null && !StringUtils.isNullOrEmpty((String)(className = attribute.getTextContent()))) {
            try {
                Class<?> cls = Class.forName(className);
                return cls;
            }
            catch (ClassNotFoundException e) {
                logger.error("Could not load class: " + className + ". Falling back to String type.", (Throwable)e);
            }
        }
        return fallbackType;
    }

    private List<Object> getNodeList(List<Node> childNodes) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Node childNode : childNodes) {
            Object value = this.getNodeValue(childNode, null);
            list.add(value);
        }
        return list;
    }

    private List<Node> getChildNodes(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        block4: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    list.add(child);
                }
                case 3: {
                    String text = child.getNodeValue();
                    if (StringUtils.isNullOrEmpty((String)text)) continue block4;
                    list.add(child);
                }
            }
        }
        return list;
    }

    private Map<String, Object> getNodeMap(List<Node> entryNodes) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Node entryNode : entryNodes) {
            String entryNodeName = entryNode.getNodeName();
            if (!"e".equals(entryNodeName)) {
                throw new UnsupportedOperationException("Node passed as Map entry does not appear to be the right type: " + this.printNode(entryNode));
            }
            String key = null;
            Object value = null;
            List<Node> keyOrValueNodes = this.getChildNodes(entryNode);
            assert (keyOrValueNodes.size() == 2);
            for (Node keyOrValueNode : keyOrValueNodes) {
                String keyOrValueNodeName = keyOrValueNode.getNodeName();
                if ("k".equals(keyOrValueNodeName)) {
                    key = this.getNodeValue(keyOrValueNode, String.class);
                    continue;
                }
                if (!"v".equals(keyOrValueNodeName)) continue;
                value = this.getNodeValue(keyOrValueNode, null);
            }
            if (key == null) {
                throw new UnsupportedOperationException("Map key (k) node not set in entry: " + this.printNode(entryNode));
            }
            map.put(key, value);
        }
        return map;
    }

    private String printNode(Node node) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerException e) {
            logger.warn("Could not transform node '" + node + "' to pretty string: " + e.getMessage(), (Throwable)e);
            return node.toString();
        }
    }

    private PojoTableType.Rows.Row createPojoRow(Row row, Document document) {
        Object[] values;
        PojoTableType.Rows.Row rowType = new PojoTableType.Rows.Row();
        for (Object value : values = row.getValues()) {
            Element elem = document.createElement("v");
            this.createPojoValue(value, elem, document, false);
            rowType.getV().add(elem);
        }
        return rowType;
    }

    private void createPojoValue(Object value, Element elem, Document document, boolean explicitType) {
        Class<?> componentType;
        if (value == null) {
            return;
        }
        if (value.getClass().isArray() && !(componentType = value.getClass().getComponentType()).isPrimitive() && componentType != String.class) {
            value = CollectionUtils.toList((Object)value);
        }
        if (value instanceof List) {
            List list = (List)value;
            for (Object item : list) {
                Element itemElement = document.createElement("i");
                this.createPojoValue(item, itemElement, document, true);
                elem.appendChild(itemElement);
            }
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Element keyElement = document.createElement("k");
                this.createPojoValue(entry.getKey(), keyElement, document, true);
                Element valueElement = document.createElement("v");
                this.createPojoValue(entry.getValue(), valueElement, document, true);
                Element entryElement = document.createElement("e");
                entryElement.appendChild(keyElement);
                entryElement.appendChild(valueElement);
                elem.appendChild(entryElement);
            }
            return;
        }
        try {
            String stringValue = this._converter.serialize(value);
            elem.setTextContent(stringValue);
            if (explicitType) {
                elem.setAttribute("class", value.getClass().getName());
            }
        }
        catch (RuntimeException e) {
            logger.warn("Failed to serialize value: " + value + ". Returning null.", (Throwable)e);
        }
    }

    protected DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failed to create DocumentBuilder", e);
        }
    }

    private PojoTableType.Columns.Column createPojoColumn(String name, ColumnType type) {
        PojoTableType.Columns.Column columnType = new PojoTableType.Columns.Column();
        columnType.setName(name);
        columnType.setType(type.toString());
        return columnType;
    }

    public PojoTableType createPojoTable(DataContext dataContext, Table table, Column[] usedColumns, int maxRows) {
        PojoTableType tableType = new PojoTableType();
        tableType.setName(table.getName());
        PojoTableType.Columns columnsType = new PojoTableType.Columns();
        for (Column column : usedColumns) {
            columnsType.getColumn().add(this.createPojoColumn(column.getName(), column.getType()));
        }
        tableType.setColumns(columnsType);
        if (maxRows > 0) {
            Query q = dataContext.query().from(table).select(usedColumns).toQuery();
            q.setMaxRows(Integer.valueOf(maxRows));
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Document document = documentBuilder.newDocument();
            PojoTableType.Rows rowsType = new PojoTableType.Rows();
            try (DataSet ds = dataContext.executeQuery(q);){
                while (ds.next()) {
                    Row row = ds.getRow();
                    rowsType.getRow().add(this.createPojoRow(row, document));
                }
            }
            tableType.setRows(rowsType);
        }
        return tableType;
    }

    public AbstractDatastoreType createPojoDatastore(String datastoreName, String schemaName, Collection<PojoTableType> tables) {
        PojoDatastoreType datastoreType = new PojoDatastoreType();
        datastoreType.setName(datastoreName);
        datastoreType.setSchemaName(schemaName);
        datastoreType.getTable().addAll(tables);
        return datastoreType;
    }

    public AbstractDatastoreType createPojoDatastore(Datastore datastore, Set<Column> columns, int maxRowsToQuery) {
        PojoDatastoreType datastoreType = new PojoDatastoreType();
        datastoreType.setName(datastore.getName());
        datastoreType.setDescription(datastore.getDescription());
        try (DatastoreConnection con = datastore.openConnection();){
            Table[] tables;
            Schema schema;
            DataContext dataContext = con.getDataContext();
            if (columns == null || columns.isEmpty()) {
                schema = dataContext.getDefaultSchema();
                tables = schema.getTables();
            } else {
                tables = MetaModelHelper.getTables(columns);
                schema = tables[0].getSchema();
            }
            datastoreType.setSchemaName(schema.getName());
            for (Table table : tables) {
                Column[] usedColumns = columns == null || columns.isEmpty() ? table.getColumns() : MetaModelHelper.getTableColumns((Table)table, columns);
                PojoTableType tableType = this.createPojoTable(dataContext, table, usedColumns, maxRowsToQuery);
                datastoreType.getTable().add(tableType);
            }
        }
        return datastoreType;
    }
}

