/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalysisJobMetadata;
import org.datacleaner.job.JaxbJobMetadataFactory;
import org.datacleaner.job.jaxb.JobMetadataType;
import org.datacleaner.job.jaxb.MetadataProperties;

public class JaxbJobMetadataFactoryImpl
implements JaxbJobMetadataFactory {
    private final DatatypeFactory _datatypeFactory;
    private final String _author;
    private final String _jobName;
    private final String _jobDescription;
    private final String _jobVersion;

    public JaxbJobMetadataFactoryImpl() {
        this(null, null, null, null);
    }

    public JaxbJobMetadataFactoryImpl(String author, String jobName, String jobDescription, String jobVersion) {
        this._author = author;
        this._jobName = jobName;
        this._jobDescription = jobDescription;
        this._jobVersion = jobVersion;
        try {
            this._datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final JobMetadataType create(AnalysisJob analysisJob) throws Exception {
        JobMetadataType jobMetadata = new JobMetadataType();
        this.buildMainSection(jobMetadata, analysisJob);
        this.buildProperties(jobMetadata, analysisJob);
        return jobMetadata;
    }

    protected void buildProperties(JobMetadataType jobMetadata, AnalysisJob analysisJob) throws Exception {
        Map properties;
        AnalysisJobMetadata metadata = this.getMetadata(analysisJob);
        if (metadata != null && (properties = metadata.getProperties()) != null && !properties.isEmpty()) {
            MetadataProperties propertiesType = new MetadataProperties();
            List<MetadataProperties.Property> propertyList = propertiesType.getProperty();
            for (Map.Entry entry : properties.entrySet()) {
                MetadataProperties.Property property = new MetadataProperties.Property();
                property.setName((String)entry.getKey());
                property.setValue((String)entry.getValue());
                propertyList.add(property);
            }
            jobMetadata.setMetadataProperties(propertiesType);
        }
    }

    protected void buildMainSection(JobMetadataType jobMetadata, AnalysisJob analysisJob) throws Exception {
        AnalysisJobMetadata metadata = this.getMetadata(analysisJob);
        Date createdDate = metadata.getCreatedDate();
        if (createdDate != null) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(createdDate);
            jobMetadata.setCreatedDate(this._datatypeFactory.newXMLGregorianCalendar(c));
        }
        jobMetadata.setUpdatedDate(this._datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        jobMetadata.setAuthor(this._author == null ? metadata.getAuthor() : this._author);
        jobMetadata.setJobName(this._jobName == null ? metadata.getJobName() : this._jobName);
        jobMetadata.setJobDescription(this._jobDescription == null ? metadata.getJobDescription() : this._jobDescription);
        jobMetadata.setJobVersion(this._jobVersion == null ? metadata.getJobVersion() : this._jobVersion);
    }

    protected AnalysisJobMetadata getMetadata(AnalysisJob analysisJob) {
        AnalysisJobMetadata metadata = analysisJob.getMetadata();
        if (metadata == null) {
            return AnalysisJobMetadata.EMPTY_METADATA;
        }
        return metadata;
    }
}

