/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.datacleaner.api.ExpressionBasedInputColumn;
import org.datacleaner.api.InputColumn;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.CompoundComponentRequirement;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.JaxbJobMetadataFactory;
import org.datacleaner.job.JaxbJobMetadataFactoryImpl;
import org.datacleaner.job.JobWriter;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.jaxb.AnalysisType;
import org.datacleaner.job.jaxb.AnalyzerType;
import org.datacleaner.job.jaxb.ColumnType;
import org.datacleaner.job.jaxb.ColumnsType;
import org.datacleaner.job.jaxb.ComponentType;
import org.datacleaner.job.jaxb.ConfiguredPropertiesType;
import org.datacleaner.job.jaxb.DataContextType;
import org.datacleaner.job.jaxb.DescriptorType;
import org.datacleaner.job.jaxb.FilterType;
import org.datacleaner.job.jaxb.InputType;
import org.datacleaner.job.jaxb.Job;
import org.datacleaner.job.jaxb.JobMetadataType;
import org.datacleaner.job.jaxb.JobType;
import org.datacleaner.job.jaxb.MetadataProperties;
import org.datacleaner.job.jaxb.ObjectFactory;
import org.datacleaner.job.jaxb.OutcomeType;
import org.datacleaner.job.jaxb.OutputType;
import org.datacleaner.job.jaxb.SourceType;
import org.datacleaner.job.jaxb.TransformationType;
import org.datacleaner.job.jaxb.TransformerType;
import org.datacleaner.util.JaxbValidationEventHandler;
import org.datacleaner.util.convert.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbJobWriter
implements JobWriter<OutputStream> {
    private static final String COLUMN_PATH_QUALIFICATION_FULL = "full";
    private static final String COLUMN_PATH_QUALIFICATION_TABLE = "table";
    private static final String COLUMN_PATH_QUALIFICATION_COLUMN = "column";
    private static final Logger logger = LoggerFactory.getLogger(JaxbJobWriter.class);
    private final DataCleanerConfiguration _configuration;
    private final JAXBContext _jaxbContext;
    private final JaxbJobMetadataFactory _jobMetadataFactory;

    public JaxbJobWriter(DataCleanerConfiguration configuration, JaxbJobMetadataFactory jobMetadataFactory) {
        this._configuration = configuration;
        this._jobMetadataFactory = jobMetadataFactory;
        try {
            this._jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public JaxbJobWriter(DataCleanerConfiguration configuration) {
        this(configuration, new JaxbJobMetadataFactoryImpl());
    }

    public void write(AnalysisJob analysisJob, OutputStream outputStream) {
        logger.debug("write({},{}}", (Object)analysisJob, (Object)outputStream);
        Job jobType = new Job();
        try {
            JobMetadataType jobMetadata = this._jobMetadataFactory.create(analysisJob);
            jobType.setJobMetadata(jobMetadata);
        }
        catch (Exception e) {
            logger.warn("Exception occurred while creating job metadata", (Throwable)e);
        }
        SourceType sourceType = new SourceType();
        sourceType.setColumns(new ColumnsType());
        jobType.setSource(sourceType);
        Datastore datastore = analysisJob.getDatastore();
        DataContextType dataContextType = new DataContextType();
        if (datastore == null) {
            logger.warn("No datastore specified for analysis job: {}", (Object)analysisJob);
        } else {
            dataContextType.setRef(datastore.getName());
        }
        sourceType.setDataContext(dataContextType);
        HashBiMap columnMappings = HashBiMap.create((int)50);
        LinkedHashMap<FilterOutcome, String> outcomeMappings = new LinkedHashMap<FilterOutcome, String>();
        LinkedHashMap<TransformerJob, TransformerType> transformerMappings = new LinkedHashMap<TransformerJob, TransformerType>();
        LinkedHashMap<FilterJob, FilterType> filterMappings = new LinkedHashMap<FilterJob, FilterType>();
        LinkedHashMap<AnalyzerJob, AnalyzerType> analyzerMappings = new LinkedHashMap<AnalyzerJob, AnalyzerType>();
        List sourceColumns = analysisJob.getSourceColumns();
        String columnPathQualification = this.getColumnPathQualification(datastore, sourceColumns);
        for (InputColumn inputColumn : sourceColumns) {
            ColumnType jaxbColumn = new ColumnType();
            Column physicalColumn = inputColumn.getPhysicalColumn();
            jaxbColumn.setPath(this.getColumnPath(physicalColumn, columnPathQualification));
            jaxbColumn.setId(JaxbJobWriter.getColumnId(inputColumn, columnMappings));
            org.apache.metamodel.schema.ColumnType columnType = physicalColumn.getType();
            if (columnType != null) {
                jaxbColumn.setType(columnType.toString());
            }
            sourceType.getColumns().getColumn().add(jaxbColumn);
        }
        this.addComponents(jobType, analysisJob, transformerMappings, filterMappings, analyzerMappings);
        this.addTransformedColumns((BiMap<InputColumn<?>, String>)columnMappings, (Map<TransformerJob, TransformerType>)transformerMappings);
        this.addRequirements((Map<FilterOutcome, String>)outcomeMappings, (Map<TransformerJob, TransformerType>)transformerMappings, (Map<FilterJob, FilterType>)filterMappings, (Map<AnalyzerJob, AnalyzerType>)analyzerMappings, (Map<InputColumn<?>, String>)columnMappings);
        this.addConfiguration(analysisJob, (Map<TransformerJob, TransformerType>)transformerMappings, (Map<FilterJob, FilterType>)filterMappings, (Map<AnalyzerJob, AnalyzerType>)analyzerMappings, (BiMap<InputColumn<?>, String>)columnMappings);
        try {
            Marshaller marshaller = this._jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            marshaller.marshal((Object)jobType, outputStream);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getColumnPath(Column column, String columnPathQualification) {
        switch (columnPathQualification) {
            case "column": {
                String columnName = column.getName();
                if (Strings.isNullOrEmpty((String)columnName)) {
                    return column.getTable().getName() + '.' + column.getName();
                }
                return column.getName();
            }
            case "table": {
                return column.getTable().getName() + '.' + column.getName();
            }
        }
        return column.getQualifiedLabel();
    }

    private String getColumnPathQualification(Datastore datastore, Collection<InputColumn<?>> sourceColumns) {
        if (datastore == null || sourceColumns == null || sourceColumns.isEmpty()) {
            return COLUMN_PATH_QUALIFICATION_FULL;
        }
        try (DatastoreConnection connection = datastore.openConnection();){
            String string;
            SchemaNavigator schemaNavigator = connection.getSchemaNavigator();
            Schema[] schemas = schemaNavigator.getSchemas();
            Schema singleSchema = null;
            int realSchemas = 0;
            for (Schema schema : schemas) {
                if (MetaModelHelper.isInformationSchema((Schema)schema)) continue;
                ++realSchemas;
                singleSchema = schema;
            }
            if (realSchemas == 1) {
                if (singleSchema.getTableCount() == 1) {
                    string = COLUMN_PATH_QUALIFICATION_COLUMN;
                    return string;
                }
                string = COLUMN_PATH_QUALIFICATION_TABLE;
                return string;
            }
            string = COLUMN_PATH_QUALIFICATION_FULL;
            return string;
        }
    }

    private void addConfiguration(AnalysisJob analysisJob, Map<TransformerJob, TransformerType> transformerMappings, Map<FilterJob, FilterType> filterMappings, Map<AnalyzerJob, AnalyzerType> analyzerMappings, BiMap<InputColumn<?>, String> columnMappings) {
        Set configuredProperties;
        ComponentConfiguration configuration;
        ComponentType elementType;
        TransformerJob job;
        StringConverter stringConverter = new StringConverter(this._configuration, analysisJob);
        for (Map.Entry<TransformerJob, TransformerType> entry : transformerMappings.entrySet()) {
            job = entry.getKey();
            elementType = entry.getValue();
            configuration = job.getConfiguration();
            configuredProperties = job.getDescriptor().getConfiguredPropertiesForInput();
            elementType.getInput().addAll(this.createInputConfiguration(configuration, configuredProperties, columnMappings, stringConverter));
            configuredProperties = job.getDescriptor().getConfiguredProperties();
            elementType.setProperties(this.createPropertyConfiguration(configuration, configuredProperties, stringConverter));
            elementType.setMetadataProperties(this.createMetadataProperties(job.getMetadataProperties()));
        }
        for (Map.Entry<Object, ComponentType> entry : filterMappings.entrySet()) {
            job = (FilterJob)entry.getKey();
            elementType = (FilterType)entry.getValue();
            configuration = job.getConfiguration();
            configuredProperties = job.getDescriptor().getConfiguredPropertiesForInput();
            elementType.getInput().addAll(this.createInputConfiguration(configuration, configuredProperties, columnMappings, stringConverter));
            configuredProperties = job.getDescriptor().getConfiguredProperties();
            elementType.setProperties(this.createPropertyConfiguration(configuration, configuredProperties, stringConverter));
            elementType.setMetadataProperties(this.createMetadataProperties(job.getMetadataProperties()));
        }
        for (Map.Entry<Object, ComponentType> entry : analyzerMappings.entrySet()) {
            job = (AnalyzerJob)entry.getKey();
            elementType = (AnalyzerType)entry.getValue();
            configuration = job.getConfiguration();
            configuredProperties = job.getDescriptor().getConfiguredPropertiesForInput();
            elementType.getInput().addAll(this.createInputConfiguration(configuration, configuredProperties, columnMappings, stringConverter));
            configuredProperties = job.getDescriptor().getConfiguredProperties();
            elementType.setProperties(this.createPropertyConfiguration(configuration, configuredProperties, stringConverter));
            elementType.setMetadataProperties(this.createMetadataProperties(job.getMetadataProperties()));
        }
    }

    private MetadataProperties createMetadataProperties(Map<String, String> metadataProperties) {
        if (metadataProperties == null || metadataProperties.isEmpty()) {
            return null;
        }
        MetadataProperties result = new MetadataProperties();
        Set<Map.Entry<String, String>> entries = metadataProperties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            MetadataProperties.Property property = new MetadataProperties.Property();
            property.setName(entry.getKey());
            property.setValue(entry.getValue());
            result.getProperty().add(property);
        }
        return result;
    }

    private List<InputType> createInputConfiguration(ComponentConfiguration configuration, Set<ConfiguredPropertyDescriptor> configuredProperties, BiMap<InputColumn<?>, String> columnMappings, StringConverter stringConverter) {
        configuredProperties = new TreeSet<ConfiguredPropertyDescriptor>(configuredProperties);
        int numInputProperties = configuredProperties.size();
        ArrayList<InputType> result = new ArrayList<InputType>();
        for (ConfiguredPropertyDescriptor property : configuredProperties) {
            Object value;
            if (!property.isInputColumn() || (value = configuration.getProperty(property)) == null) continue;
            InputColumn[] columns = property.isArray() ? (InputColumn[])value : new InputColumn[]{(InputColumn)value};
            for (InputColumn inputColumn : columns) {
                if (inputColumn == null) continue;
                InputType inputType = new InputType();
                if (inputColumn instanceof ExpressionBasedInputColumn) {
                    ExpressionBasedInputColumn expressionBasedInputColumn = (ExpressionBasedInputColumn)inputColumn;
                    String columnValue = expressionBasedInputColumn.getExpression();
                    inputType.setValue(stringConverter.serialize((Object)columnValue, property.getCustomConverter()));
                } else {
                    inputType.setRef(JaxbJobWriter.getColumnId(inputColumn, columnMappings));
                }
                if (numInputProperties != 1) {
                    inputType.setName(property.getName());
                }
                result.add(inputType);
            }
        }
        return result;
    }

    private ConfiguredPropertiesType createPropertyConfiguration(ComponentConfiguration configuration, Set<ConfiguredPropertyDescriptor> configuredProperties, StringConverter stringConverter) {
        configuredProperties = new TreeSet<ConfiguredPropertyDescriptor>(configuredProperties);
        ArrayList<ConfiguredPropertiesType.Property> result = new ArrayList<ConfiguredPropertiesType.Property>();
        for (ConfiguredPropertyDescriptor property : configuredProperties) {
            if (property.isInputColumn()) continue;
            Object value = configuration.getProperty(property);
            String stringValue = stringConverter.serialize(value, property.getCustomConverter());
            ConfiguredPropertiesType.Property propertyType = new ConfiguredPropertiesType.Property();
            propertyType.setName(property.getName());
            if (stringValue != null && stringValue.indexOf(10) != -1) {
                propertyType.setValue(stringValue);
            } else {
                propertyType.setValueAttribute(stringValue);
            }
            result.add(propertyType);
        }
        ConfiguredPropertiesType configuredPropertiesType = new ConfiguredPropertiesType();
        configuredPropertiesType.getProperty().addAll(result);
        return configuredPropertiesType;
    }

    private void addTransformedColumns(BiMap<InputColumn<?>, String> columnMappings, Map<TransformerJob, TransformerType> transformerMappings) {
        for (Map.Entry<TransformerJob, TransformerType> entry : transformerMappings.entrySet()) {
            InputColumn[] columns;
            TransformerJob transformerJob = entry.getKey();
            TransformerType transformerType = entry.getValue();
            for (InputColumn inputColumn : columns = transformerJob.getOutput()) {
                boolean hidden;
                String id = JaxbJobWriter.getColumnId(inputColumn, columnMappings);
                OutputType outputType = new OutputType();
                outputType.setId(id);
                outputType.setName(inputColumn.getName());
                if (inputColumn instanceof MutableInputColumn && (hidden = ((MutableInputColumn)inputColumn).isHidden())) {
                    outputType.setHidden(hidden);
                }
                transformerType.getOutput().add(outputType);
            }
        }
    }

    private void addRequirements(Map<FilterOutcome, String> outcomeMappings, Map<TransformerJob, TransformerType> transformerMappings, Map<FilterJob, FilterType> filterMappings, Map<AnalyzerJob, AnalyzerType> analyzerMappings, Map<InputColumn<?>, String> columnMappings) {
        String id;
        ComponentRequirement requirement;
        TransformerJob job;
        for (Map.Entry<TransformerJob, TransformerType> entry : transformerMappings.entrySet()) {
            job = entry.getKey();
            requirement = job.getComponentRequirement();
            if (requirement == null) continue;
            id = this.getId(requirement, outcomeMappings);
            entry.getValue().setRequires(id);
        }
        for (Map.Entry<Object, ComponentType> entry : filterMappings.entrySet()) {
            job = (FilterJob)entry.getKey();
            requirement = job.getComponentRequirement();
            if (requirement == null) continue;
            id = this.getId(requirement, outcomeMappings);
            ((FilterType)entry.getValue()).setRequires(id);
        }
        for (Map.Entry<Object, ComponentType> entry : analyzerMappings.entrySet()) {
            job = (AnalyzerJob)entry.getKey();
            requirement = job.getComponentRequirement();
            if (requirement == null) continue;
            id = this.getId(requirement, outcomeMappings);
            ((AnalyzerType)entry.getValue()).setRequires(id);
        }
        for (Map.Entry<Object, ComponentType> entry : filterMappings.entrySet()) {
            job = (FilterJob)entry.getKey();
            FilterType filterType = (FilterType)entry.getValue();
            Collection outcomes = job.getFilterOutcomes();
            for (FilterOutcome outcome : outcomes) {
                String id2 = this.getId(outcome, outcomeMappings, false);
                if (id2 == null) continue;
                OutcomeType outcomeType = new OutcomeType();
                outcomeType.setCategory(outcome.getCategory().name());
                outcomeType.setId(id2);
                filterType.getOutcome().add(outcomeType);
            }
        }
    }

    private String getId(ComponentRequirement requirement, Map<FilterOutcome, String> outcomeMappings) {
        if (requirement instanceof AnyComponentRequirement) {
            return "_any_";
        }
        if (requirement instanceof SimpleComponentRequirement) {
            FilterOutcome outcome = ((SimpleComponentRequirement)requirement).getOutcome();
            return this.getId(outcome, outcomeMappings, true);
        }
        if (requirement instanceof CompoundComponentRequirement) {
            Set outcomes = ((CompoundComponentRequirement)requirement).getOutcomes();
            StringBuilder sb = new StringBuilder();
            for (FilterOutcome outcome : outcomes) {
                if (sb.length() != 0) {
                    sb.append(" OR ");
                }
                String id = this.getId(outcome, outcomeMappings, true);
                sb.append(id);
            }
            return sb.toString();
        }
        throw new UnsupportedOperationException("Unsupported ComponentRequirement type: " + requirement);
    }

    private String getId(FilterOutcome outcome, Map<FilterOutcome, String> outcomeMappings, boolean create) {
        String id = outcomeMappings.get(outcome);
        if (id == null && create) {
            id = "outcome_" + outcomeMappings.size();
            outcomeMappings.put(outcome, id);
        }
        return id;
    }

    private void addComponents(JobType jobType, AnalysisJob analysisJob, Map<TransformerJob, TransformerType> transformerMappings, Map<FilterJob, FilterType> filterMappings, Map<AnalyzerJob, AnalyzerType> analyzerMappings) {
        TransformationType transformationType = new TransformationType();
        jobType.setTransformation(transformationType);
        AnalysisType analysisType = new AnalysisType();
        jobType.setAnalysis(analysisType);
        List transformerJobs = analysisJob.getTransformerJobs();
        for (TransformerJob transformerJob : transformerJobs) {
            TransformerType transformerType = new TransformerType();
            transformerType.setName(transformerJob.getName());
            this.setDescriptor(transformerType, (ComponentDescriptor<?>)transformerJob.getDescriptor());
            transformationType.getTransformerOrFilter().add(transformerType);
            transformerMappings.put(transformerJob, transformerType);
        }
        List filterJobs = analysisJob.getFilterJobs();
        for (FilterJob filterJob : filterJobs) {
            FilterType filterType = new FilterType();
            filterType.setName(filterJob.getName());
            this.setDescriptor(filterType, (ComponentDescriptor<?>)filterJob.getDescriptor());
            transformationType.getTransformerOrFilter().add(filterType);
            filterMappings.put(filterJob, filterType);
        }
        List analyzerJobs = analysisJob.getAnalyzerJobs();
        for (AnalyzerJob analyzerJob : analyzerJobs) {
            AnalyzerType analyzerType = new AnalyzerType();
            analyzerType.setName(analyzerJob.getName());
            this.setDescriptor(analyzerType, (ComponentDescriptor<?>)analyzerJob.getDescriptor());
            analysisType.getAnalyzer().add(analyzerType);
            analyzerMappings.put(analyzerJob, analyzerType);
        }
    }

    private void setDescriptor(ComponentType componentType, ComponentDescriptor<?> descriptor) {
        DescriptorType descriptorType = new DescriptorType();
        descriptorType.setRef(descriptor.getDisplayName());
        componentType.setDescriptor(descriptorType);
    }

    private static String getColumnId(InputColumn<?> inputColumn, BiMap<InputColumn<?>, String> columnMappings) {
        if (inputColumn == null) {
            throw new IllegalArgumentException("InputColumn cannot be null");
        }
        String id = (String)columnMappings.get(inputColumn);
        if (id == null) {
            String baseColumnId;
            id = baseColumnId = JaxbJobWriter.getBaseColumnId(inputColumn);
            int addition = 1;
            while (columnMappings.containsValue((Object)id)) {
                id = baseColumnId + ++addition;
            }
            columnMappings.put(inputColumn, (Object)id);
        }
        return id;
    }

    private static String getBaseColumnId(InputColumn<?> inputColumn) {
        String cleansedColumnName = "col_" + Strings.nullToEmpty((String)inputColumn.getName());
        cleansedColumnName = cleansedColumnName.toLowerCase().trim();
        cleansedColumnName = cleansedColumnName.replaceAll("[^a-z0-9_]", "");
        return cleansedColumnName;
    }
}

