/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Set;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.HdfsResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.xml.XmlDomDataContext;
import org.datacleaner.configuration.ServerInformation;
import org.datacleaner.connection.CouchDbDatastore;
import org.datacleaner.connection.CsvDatastore;
import org.datacleaner.connection.DataHubDatastore;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.ElasticSearchDatastore;
import org.datacleaner.connection.ExcelDatastore;
import org.datacleaner.connection.JdbcDatastore;
import org.datacleaner.connection.MongoDbDatastore;
import org.datacleaner.connection.SalesforceDatastore;
import org.datacleaner.reference.DatastoreDictionary;
import org.datacleaner.reference.DatastoreSynonymCatalog;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.RegexStringPattern;
import org.datacleaner.reference.SimpleDictionary;
import org.datacleaner.reference.SimpleStringPattern;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.reference.TextFileDictionary;
import org.datacleaner.reference.TextFileSynonymCatalog;
import org.datacleaner.server.DirectConnectionHadoopClusterInformation;
import org.datacleaner.server.DirectoryBasedHadoopClusterInformation;
import org.datacleaner.server.EnvironmentBasedHadoopClusterInformation;
import org.datacleaner.server.HadoopClusterInformation;
import org.datacleaner.util.HadoopResource;
import org.datacleaner.util.SecurityUtils;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.xml.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomConfigurationWriter {
    private final Document _document;

    public DomConfigurationWriter() {
        this._document = XmlUtils.createDocument();
    }

    public DomConfigurationWriter(Resource resource) {
        this._document = (Document)resource.read(XmlUtils::parseDocument);
    }

    public DomConfigurationWriter(Document document) {
        this._document = document;
    }

    public boolean isExternalizable(ServerInformation serverInformation) {
        if (serverInformation == null) {
            return false;
        }
        return serverInformation instanceof HadoopClusterInformation;
    }

    public boolean isExternalizable(Datastore datastore) {
        SimpleTableDef[] tableDefs;
        Resource resource;
        if (datastore == null) {
            return false;
        }
        if (datastore instanceof JdbcDatastore) {
            return true;
        }
        if (datastore instanceof CsvDatastore) {
            resource = ((CsvDatastore)datastore).getResource();
            if (resource instanceof FileResource) {
                return true;
            }
            if (resource instanceof HdfsResource) {
                return true;
            }
        }
        if (datastore instanceof ExcelDatastore && (resource = ((ExcelDatastore)datastore).getResource()) instanceof FileResource) {
            return true;
        }
        if (datastore instanceof ElasticSearchDatastore && (tableDefs = ((ElasticSearchDatastore)datastore).getTableDefs()) == null) {
            return true;
        }
        if (datastore instanceof MongoDbDatastore && (tableDefs = ((MongoDbDatastore)datastore).getTableDefs()) == null) {
            return true;
        }
        if (datastore instanceof CouchDbDatastore && (tableDefs = ((CouchDbDatastore)datastore).getTableDefs()) == null) {
            return true;
        }
        if (datastore instanceof SalesforceDatastore) {
            return true;
        }
        return datastore instanceof DataHubDatastore;
    }

    public boolean isExternalizable(Dictionary dict) {
        return dict instanceof SimpleDictionary || dict instanceof TextFileDictionary || dict instanceof DatastoreDictionary;
    }

    public boolean isExternalizable(SynonymCatalog sc) {
        return sc instanceof TextFileSynonymCatalog || sc instanceof DatastoreSynonymCatalog;
    }

    public boolean isExternalizable(StringPattern sp) {
        return sp instanceof SimpleStringPattern || sp instanceof RegexStringPattern;
    }

    public boolean removeHadoopClusterServerInformation(String serverName) {
        Element serverInformationCatalogElement = this.getServerInformationCatalogElement();
        Element hadoopClustersElement = this.getOrCreateChildElementByTagName(serverInformationCatalogElement, "hadoop-clusters");
        return this.removeChildElementByNameAttribute(serverName, hadoopClustersElement);
    }

    public boolean removeDatastore(String datastoreName) {
        Element datastoreCatalogElement = this.getDatastoreCatalogElement();
        return this.removeChildElementByNameAttribute(datastoreName, datastoreCatalogElement);
    }

    public boolean removeDictionary(String dictionaryName) {
        Element dictionariesElement = this.getDictionariesElement();
        return this.removeChildElementByNameAttribute(dictionaryName, dictionariesElement);
    }

    public boolean removeSynonymCatalog(String synonymCatalogName) {
        Element synonymCatalogsElement = this.getSynonymCatalogsElement();
        return this.removeChildElementByNameAttribute(synonymCatalogName, synonymCatalogsElement);
    }

    public boolean removeStringPattern(String stringPatternName) {
        Element stringPatternsElement = this.getStringPatternsElement();
        return this.removeChildElementByNameAttribute(stringPatternName, stringPatternsElement);
    }

    private boolean removeChildElementByNameAttribute(String dictionaryName, Element dictionariesElement) {
        NodeList childNodes = dictionariesElement.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr[] attributes;
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            for (Attr attr : attributes = XmlDomDataContext.getAttributes((Element)element)) {
                String value;
                if (!"name".equals(attr.getName()) || !dictionaryName.equals(value = attr.getValue())) continue;
                dictionariesElement.removeChild(element);
                this.onDocumentChanged(this.getDocument());
                return true;
            }
        }
        return false;
    }

    public Element externalize(ServerInformation serverInformation) throws UnsupportedOperationException {
        if (serverInformation == null) {
            throw new IllegalArgumentException("ServerInformation cannot be null");
        }
        if (!(serverInformation instanceof HadoopClusterInformation)) {
            throw new UnsupportedOperationException("Non-supported serverInformation: " + serverInformation);
        }
        Element elem = this.toElement((HadoopClusterInformation)serverInformation);
        Element serverInformationCatalogElement = this.getHadoopClustersElement();
        serverInformationCatalogElement.appendChild(elem);
        this.onDocumentChanged(this.getDocument());
        return elem;
    }

    public Element externalize(Datastore datastore) throws UnsupportedOperationException {
        Element elem;
        Resource resource;
        if (datastore == null) {
            throw new IllegalArgumentException("Datastore cannot be null");
        }
        if (datastore instanceof CsvDatastore) {
            resource = ((CsvDatastore)datastore).getResource();
            String filename = this.toFilename(resource);
            elem = this.toElement((CsvDatastore)datastore, filename);
        } else if (datastore instanceof ExcelDatastore) {
            resource = ((ExcelDatastore)datastore).getResource();
            String filename = this.toFilename(resource);
            elem = this.toElement((ExcelDatastore)datastore, filename);
        } else if (datastore instanceof JdbcDatastore) {
            elem = this.toElement((JdbcDatastore)datastore);
        } else if (datastore instanceof ElasticSearchDatastore) {
            elem = this.toElement((ElasticSearchDatastore)datastore);
        } else if (datastore instanceof MongoDbDatastore) {
            elem = this.toElement((MongoDbDatastore)datastore);
        } else if (datastore instanceof CouchDbDatastore) {
            elem = this.toElement((CouchDbDatastore)datastore);
        } else if (datastore instanceof SalesforceDatastore) {
            elem = this.toElement((SalesforceDatastore)datastore);
        } else if (datastore instanceof DataHubDatastore) {
            elem = this.toElement((DataHubDatastore)datastore);
        } else {
            throw new UnsupportedOperationException("Non-supported datastore: " + datastore);
        }
        Element datastoreCatalogElement = this.getDatastoreCatalogElement();
        datastoreCatalogElement.appendChild(elem);
        this.onDocumentChanged(this.getDocument());
        return elem;
    }

    public Element externalize(Dictionary dictionary) throws UnsupportedOperationException {
        Element elem;
        if (dictionary == null) {
            throw new IllegalArgumentException("Dictionary cannot be null");
        }
        if (dictionary instanceof SimpleDictionary) {
            elem = this.toElement((SimpleDictionary)dictionary);
        } else if (dictionary instanceof TextFileDictionary) {
            elem = this.toElement((TextFileDictionary)dictionary);
        } else if (dictionary instanceof DatastoreDictionary) {
            elem = this.toElement((DatastoreDictionary)dictionary);
        } else {
            throw new UnsupportedOperationException("Non-supported dictionary: " + dictionary);
        }
        Element dictionariesElement = this.getDictionariesElement();
        dictionariesElement.appendChild(elem);
        this.onDocumentChanged(this.getDocument());
        return elem;
    }

    public Element externalize(SynonymCatalog sc) throws UnsupportedOperationException {
        Element elem;
        if (sc == null) {
            throw new IllegalArgumentException("SynonymCatalog cannot be null");
        }
        if (sc instanceof TextFileSynonymCatalog) {
            elem = this.toElement((TextFileSynonymCatalog)sc);
        } else if (sc instanceof DatastoreSynonymCatalog) {
            elem = this.toElement((DatastoreSynonymCatalog)sc);
        } else {
            throw new UnsupportedOperationException("Non-supported synonym catalog: " + sc);
        }
        Element synonymCatalogsElement = this.getSynonymCatalogsElement();
        synonymCatalogsElement.appendChild(elem);
        this.onDocumentChanged(this.getDocument());
        return elem;
    }

    public Element externalize(StringPattern sp) throws UnsupportedOperationException {
        Element elem;
        if (sp == null) {
            throw new IllegalArgumentException("StringPattern cannot be null");
        }
        if (sp instanceof SimpleStringPattern) {
            elem = this.toElement((SimpleStringPattern)sp);
        } else if (sp instanceof RegexStringPattern) {
            elem = this.toElement((RegexStringPattern)sp);
        } else {
            throw new UnsupportedOperationException("Non-supported string pattern: " + sp);
        }
        Element stringPatternsElement = this.getStringPatternsElement();
        stringPatternsElement.appendChild(elem);
        this.onDocumentChanged(this.getDocument());
        return elem;
    }

    private Element toElement(RegexStringPattern sp) {
        Element elem = this.getDocument().createElement("regex-pattern");
        elem.setAttribute("name", sp.getName());
        if (!Strings.isNullOrEmpty((String)sp.getDescription())) {
            elem.setAttribute("description", sp.getDescription());
        }
        this.appendElement(elem, "expression", sp.getExpression());
        this.appendElement(elem, "match-entire-string", sp.isMatchEntireString());
        return elem;
    }

    private Element toElement(SimpleStringPattern sp) {
        Element elem = this.getDocument().createElement("simple-pattern");
        elem.setAttribute("name", sp.getName());
        if (!Strings.isNullOrEmpty((String)sp.getDescription())) {
            elem.setAttribute("description", sp.getDescription());
        }
        this.appendElement(elem, "expression", sp.getExpression());
        return elem;
    }

    private Element toElement(DatastoreSynonymCatalog sc) {
        String[] synonymColumnPaths;
        Element elem = this.getDocument().createElement("datastore-synonym-catalog");
        elem.setAttribute("name", sc.getName());
        if (!Strings.isNullOrEmpty((String)sc.getDescription())) {
            elem.setAttribute("description", sc.getDescription());
        }
        this.appendElement(elem, "datastore-name", sc.getDatastoreName());
        this.appendElement(elem, "master-term-column-path", sc.getMasterTermColumnPath());
        for (String path : synonymColumnPaths = sc.getSynonymColumnPaths()) {
            this.appendElement(elem, "synonym-column-path", path);
        }
        this.appendElement(elem, "load-into-memory", sc.isLoadIntoMemory());
        return elem;
    }

    private Element toElement(TextFileSynonymCatalog sc) {
        Element elem = this.getDocument().createElement("text-file-synonym-catalog");
        elem.setAttribute("name", sc.getName());
        if (!Strings.isNullOrEmpty((String)sc.getDescription())) {
            elem.setAttribute("description", sc.getDescription());
        }
        this.appendElement(elem, "filename", sc.getFilename());
        this.appendElement(elem, "encoding", sc.getEncoding());
        this.appendElement(elem, "case-sensitive", sc.isCaseSensitive());
        return elem;
    }

    private Element toElement(SimpleDictionary dictionary) {
        Element elem = this.getDocument().createElement("value-list-dictionary");
        elem.setAttribute("name", dictionary.getName());
        if (!Strings.isNullOrEmpty((String)dictionary.getDescription())) {
            elem.setAttribute("description", dictionary.getDescription());
        }
        Set values = dictionary.getValueSet();
        for (String value : values) {
            this.appendElement(elem, "value", value);
        }
        this.appendElement(elem, "case-sensitive", dictionary.isCaseSensitive());
        return elem;
    }

    private Element toElement(TextFileDictionary dictionary) {
        Element elem = this.getDocument().createElement("text-file-dictionary");
        elem.setAttribute("name", dictionary.getName());
        if (!Strings.isNullOrEmpty((String)dictionary.getDescription())) {
            elem.setAttribute("description", dictionary.getDescription());
        }
        this.appendElement(elem, "filename", dictionary.getFilename());
        this.appendElement(elem, "encoding", dictionary.getEncoding());
        this.appendElement(elem, "case-sensitive", dictionary.isCaseSensitive());
        return elem;
    }

    private Element toElement(DatastoreDictionary dictionary) {
        Element elem = this.getDocument().createElement("datastore-dictionary");
        elem.setAttribute("name", dictionary.getName());
        if (!Strings.isNullOrEmpty((String)dictionary.getDescription())) {
            elem.setAttribute("description", dictionary.getDescription());
        }
        this.appendElement(elem, "datastore-name", dictionary.getDatastoreName());
        this.appendElement(elem, "column-path", dictionary.getQualifiedColumnName());
        this.appendElement(elem, "load-into-memory", dictionary.isLoadIntoMemory());
        return elem;
    }

    protected void onDocumentChanged(Document document) {
    }

    protected String toFilename(Resource resource) throws UnsupportedOperationException {
        if (resource instanceof FileResource) {
            return ((FileResource)resource).getFile().getPath();
        }
        if (resource instanceof HadoopResource) {
            return ((HadoopResource)resource).getTemplatedPath();
        }
        if (resource instanceof HdfsResource) {
            return resource.getQualifiedPath();
        }
        throw new UnsupportedOperationException("Unsupported resource type: " + resource);
    }

    public Element toElement(JdbcDatastore datastore) {
        String catalogName;
        String jndiUrl;
        Element ds = this.getDocument().createElement("jdbc-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        if (Strings.isNullOrEmpty((String)(jndiUrl = datastore.getDatasourceJndiUrl()))) {
            this.appendElement(ds, "url", datastore.getJdbcUrl());
            this.appendElement(ds, "driver", datastore.getDriverClass());
            this.appendElement(ds, "username", datastore.getUsername());
            this.appendElement(ds, "password", this.encodePassword(datastore.getPassword()));
            this.appendElement(ds, "multiple-connections", datastore.isMultipleConnections() + "");
        } else {
            this.appendElement(ds, "datasource-jndi-url", jndiUrl);
        }
        Object[] tableTypes = datastore.getTableTypes();
        if (tableTypes != null && tableTypes.length != 0 && !Arrays.equals(TableType.DEFAULT_TABLE_TYPES, tableTypes)) {
            Element tableTypesElement = this.getDocument().createElement("table-types");
            ds.appendChild(tableTypesElement);
            for (Object tableType : tableTypes) {
                this.appendElement(tableTypesElement, "table-type", tableType.name());
            }
        }
        if (!Strings.isNullOrEmpty((String)(catalogName = datastore.getCatalogName()))) {
            this.appendElement(ds, "catalog-name", catalogName);
        }
        return ds;
    }

    private String encodePassword(String password) {
        if (password == null) {
            return null;
        }
        return SecurityUtils.encodePasswordWithPrefix((String)password);
    }

    private String encodePassword(char[] password) {
        return this.encodePassword(new String(password));
    }

    public Element toElement(HadoopClusterInformation hadoopClusterInformation) {
        Element hadoopClusterElement = this.getDocument().createElement("hadoop-cluster");
        hadoopClusterElement.setAttribute("name", hadoopClusterInformation.getName());
        String description = hadoopClusterInformation.getDescription();
        if (!Strings.isNullOrEmpty((String)description)) {
            hadoopClusterElement.setAttribute("description", description);
        }
        if (hadoopClusterInformation instanceof DirectConnectionHadoopClusterInformation) {
            this.appendElement(hadoopClusterElement, "namenode-url", ((DirectConnectionHadoopClusterInformation)hadoopClusterInformation).getNameNodeUri().toString());
        } else if (hadoopClusterInformation instanceof EnvironmentBasedHadoopClusterInformation) {
            this.appendElement(hadoopClusterElement, "environment-configured", "");
        } else if (hadoopClusterInformation instanceof DirectoryBasedHadoopClusterInformation) {
            DirectoryBasedHadoopClusterInformation directoryBasedHadoopClusterInformation = (DirectoryBasedHadoopClusterInformation)hadoopClusterInformation;
            Element directoriesElement = this.getDocument().createElement("directories");
            hadoopClusterElement.appendChild(directoriesElement);
            for (String directory : directoryBasedHadoopClusterInformation.getDirectories()) {
                this.appendElement(directoriesElement, "directory", directory);
            }
        } else {
            throw new UnsupportedOperationException("Unknown Hadoop cluster configuration");
        }
        return hadoopClusterElement;
    }

    public Element toElement(ElasticSearchDatastore datastore) {
        Element ds = this.getDocument().createElement("elasticsearch-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "hostname", datastore.getHostname());
        this.appendElement(ds, "port", datastore.getPort());
        this.appendElement(ds, "cluster-name", datastore.getClusterName());
        this.appendElement(ds, "index-name", datastore.getIndexName());
        this.appendElement(ds, "client-type", datastore.getClientType().name());
        this.appendElement(ds, "username", datastore.getUsername());
        this.appendElement(ds, "password", this.encodePassword(datastore.getPassword()));
        this.appendElement(ds, "ssl", datastore.getSsl());
        if (datastore.getSsl()) {
            this.appendElement(ds, "keystore-path", datastore.getKeystorePath());
            this.appendElement(ds, "keystore-password", this.encodePassword(datastore.getKeystorePassword()));
        }
        return ds;
    }

    public Element toElement(MongoDbDatastore datastore) {
        Element ds = this.getDocument().createElement("mongodb-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "hostname", datastore.getHostname());
        this.appendElement(ds, "port", datastore.getPort());
        this.appendElement(ds, "database-name", datastore.getDatabaseName());
        this.appendElement(ds, "username", datastore.getUsername());
        this.appendElement(ds, "password", this.encodePassword(datastore.getPassword()));
        return ds;
    }

    public Element toElement(CouchDbDatastore datastore) {
        Element ds = this.getDocument().createElement("couchdb-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "hostname", datastore.getHostname());
        this.appendElement(ds, "port", datastore.getPort());
        this.appendElement(ds, "username", datastore.getUsername());
        this.appendElement(ds, "password", this.encodePassword(datastore.getPassword()));
        this.appendElement(ds, "ssl", datastore.isSslEnabled());
        return ds;
    }

    public Element toElement(SalesforceDatastore datastore) {
        Element ds = this.getDocument().createElement("salesforce-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "username", datastore.getUsername());
        this.appendElement(ds, "password", this.encodePassword(datastore.getPassword()));
        this.appendElement(ds, "security-token", datastore.getSecurityToken());
        String endpointUrl = datastore.getEndpointUrl();
        if (!Strings.isNullOrEmpty((String)endpointUrl)) {
            this.appendElement(ds, "endpoint-url", endpointUrl);
        }
        return ds;
    }

    private Element toElement(DataHubDatastore datastore) {
        Element ds = this.getDocument().createElement("datahub-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "host", datastore.getHost());
        this.appendElement(ds, "port", datastore.getPort());
        this.appendElement(ds, "username", datastore.getUsername());
        this.appendElement(ds, "password", this.encodePassword(datastore.getPassword()));
        this.appendElement(ds, "https", datastore.isHttps());
        this.appendElement(ds, "acceptunverifiedsslpeers", datastore.isAcceptUnverifiedSslPeers());
        this.appendElement(ds, "datahubsecuritymode", datastore.getSecurityMode());
        return ds;
    }

    public Element toElement(ExcelDatastore datastore, String filename) {
        Element ds = this.getDocument().createElement("excel-datastore");
        ds.setAttribute("name", datastore.getName());
        if (!Strings.isNullOrEmpty((String)datastore.getDescription())) {
            ds.setAttribute("description", datastore.getDescription());
        }
        this.appendElement(ds, "filename", filename);
        return ds;
    }

    public Element toElement(CsvDatastore datastore, String filename) {
        Element datastoreElement = this.getDocument().createElement("csv-datastore");
        datastoreElement.setAttribute("name", datastore.getName());
        String description = datastore.getDescription();
        if (!Strings.isNullOrEmpty((String)description)) {
            datastoreElement.setAttribute("description", description);
        }
        this.appendElement(datastoreElement, "filename", filename);
        this.appendElement(datastoreElement, "quote-char", datastore.getQuoteChar());
        this.appendElement(datastoreElement, "separator-char", datastore.getSeparatorChar());
        this.appendElement(datastoreElement, "escape-char", datastore.getEscapeChar());
        this.appendElement(datastoreElement, "encoding", datastore.getEncoding());
        this.appendElement(datastoreElement, "fail-on-inconsistencies", datastore.isFailOnInconsistencies());
        this.appendElement(datastoreElement, "multiline-values", datastore.isMultilineValues());
        this.appendElement(datastoreElement, "header-line-number", datastore.getHeaderLineNumber());
        return datastoreElement;
    }

    public final Document getDocument() {
        return this._document;
    }

    public Element getDatastoreCatalogElement() {
        Element configurationFileDocumentElement = this.getDocumentElement();
        Element datastoreCatalogElement = this.getOrCreateChildElementByTagName(configurationFileDocumentElement, "datastore-catalog");
        if (datastoreCatalogElement == null) {
            throw new IllegalStateException("Could not find <datastore-catalog> element in configuration file");
        }
        return datastoreCatalogElement;
    }

    public Element getServerInformationCatalogElement() {
        Element configurationFileDocumentElement = this.getDocumentElement();
        return this.getOrCreateChildElementByTagName(configurationFileDocumentElement, "servers");
    }

    public Element getHadoopClustersElement() {
        Element hadoopClustersElement = this.getServerInformationCatalogElement();
        return this.getOrCreateChildElementByTagName(hadoopClustersElement, "hadoop-clusters");
    }

    public Element getDictionariesElement() {
        Element referenceDataCatalogElement = this.getReferenceDataCatalogElement();
        Element dictionariesElement = this.getOrCreateChildElementByTagName(referenceDataCatalogElement, "dictionaries");
        if (dictionariesElement == null) {
            throw new IllegalStateException("Could not find <dictionaries> element in configuration file");
        }
        return dictionariesElement;
    }

    public Element getSynonymCatalogsElement() {
        Element referenceDataCatalogElement = this.getReferenceDataCatalogElement();
        Element synonymCatalogsElement = this.getOrCreateChildElementByTagName(referenceDataCatalogElement, "synonym-catalogs");
        if (synonymCatalogsElement == null) {
            throw new IllegalStateException("Could not find <synonym-catalogs> element in configuration file");
        }
        return synonymCatalogsElement;
    }

    public Element getStringPatternsElement() {
        Element referenceDataCatalogElement = this.getReferenceDataCatalogElement();
        Element stringPatternsElement = this.getOrCreateChildElementByTagName(referenceDataCatalogElement, "string-patterns");
        if (stringPatternsElement == null) {
            throw new IllegalStateException("Could not find <string-patterns> element in configuration file");
        }
        return stringPatternsElement;
    }

    private Element getReferenceDataCatalogElement() {
        Element configurationFileDocumentElement = this.getDocumentElement();
        Element referenceDataCatalogElement = this.getOrCreateChildElementByTagName(configurationFileDocumentElement, "reference-data-catalog");
        if (referenceDataCatalogElement == null) {
            throw new IllegalStateException("Could not find <reference-data-catalog> element in configuration file");
        }
        return referenceDataCatalogElement;
    }

    private Element getDocumentElement() {
        Document document = this.getDocument();
        Element documentElement = document.getDocumentElement();
        if (documentElement == null) {
            documentElement = document.createElement("configuration");
            documentElement.setAttribute("xmlns", "http://eobjects.org/analyzerbeans/configuration/1.0");
            document.appendChild(documentElement);
        }
        return documentElement;
    }

    private Element getOrCreateChildElementByTagName(Element element, String tagName) {
        Element elem = this.getChildElementByTagName(element, tagName);
        if (elem == null) {
            elem = this.getDocument().createElement(tagName);
            element.appendChild(elem);
        }
        return elem;
    }

    private Element getChildElementByTagName(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    private void appendElement(Element parent, String elementName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof char[]) {
            value = new String((char[])value);
        }
        String stringValue = value.toString();
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            if (c == '\uffff') {
                stringValue = "NOT_A_CHAR";
            } else if (c == '\t') {
                stringValue = "\\t";
            } else if (c == '\n') {
                stringValue = "\\n";
            } else if (c == '\r') {
                stringValue = "\\r";
            }
        }
        Element element = this.getDocument().createElement(elementName);
        element.setTextContent(stringValue);
        parent.appendChild(element);
    }

    public void addRemoteServer(String serverName, String url, String username, String password) {
        Element descriptorProviderElement = this.getOrCreateChildElementByTagName(this.getDocumentElement(), "descriptor-providers");
        Element remoteComponentsElement = this.getOrCreateChildElementByTagName(descriptorProviderElement, "remote-components");
        Element serverElement = this.getDocument().createElement("server");
        remoteComponentsElement.appendChild(serverElement);
        if (!StringUtils.isNullOrEmpty((String)serverName)) {
            this.appendElement(serverElement, "name", serverName);
        }
        if (!StringUtils.isNullOrEmpty((String)url)) {
            this.appendElement(serverElement, "url", url);
        }
        this.appendElement(serverElement, "username", username);
        this.appendElement(serverElement, "password", SecurityUtils.encodePasswordWithPrefix((String)password));
        this.onDocumentChanged(this.getDocument());
    }

    public void updateRemoteServerCredentials(String serverName, String username, String password) {
        Element remoteComponents = this.getChildElementByTagName(this.getDocumentElement(), "remote-components");
        NodeList servers = remoteComponents.getElementsByTagName("server");
        for (int i = 0; i < servers.getLength(); ++i) {
            Element server;
            Element name;
            if (!(servers.item(i) instanceof Element) || (name = this.getChildElementByTagName(server = (Element)servers.item(i), "name")) == null || !serverName.equals(name.getTextContent())) continue;
            Element usernameElemet = this.getOrCreateChildElementByTagName(server, "username");
            usernameElemet.setTextContent(username);
            Element passwordElement = this.getOrCreateChildElementByTagName(server, "password");
            passwordElement.setTextContent(SecurityUtils.encodePasswordWithPrefix((String)password));
            break;
        }
        this.onDocumentChanged(this.getDocument());
    }
}

