/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.composition;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.FileProperty;
import org.datacleaner.api.InputColumn;
import org.datacleaner.components.categories.CompositionCategory;
import org.datacleaner.components.composition.AbstractWrappedAnalysisJobTransformer;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.JaxbJobReader;
import org.datacleaner.job.builder.AnalysisJobBuilder;

@Named(value="Invoke child Analysis job")
@Description(value="Wraps another (external) Analysis job's transformations and invokes them as an integrated part of the current job. Using this transformation you can compose parent and child jobs for more coarse or more fine granularity of transformations.")
@Categorized(value={CompositionCategory.class})
public class InvokeChildAnalysisJobTransformer
extends AbstractWrappedAnalysisJobTransformer {
    public static final String PROPERTY_JOB_RESOURCE = "Analysis job";
    @Configured
    InputColumn<?>[] input;
    @Configured(value="Analysis job")
    @FileProperty(accessMode=FileProperty.FileAccessMode.OPEN, extension={".analysis.xml"})
    Resource analysisJobResource;

    protected AnalysisJob createWrappedAnalysisJob() {
        AnalysisJob job = (AnalysisJob)this.analysisJobResource.read((Func)new Func<InputStream, AnalysisJob>(){

            public AnalysisJob eval(InputStream in) {
                JaxbJobReader reader = new JaxbJobReader(InvokeChildAnalysisJobTransformer.this.getDataCleanerConfiguration());
                AnalysisJobBuilder jobBuilder = reader.create(in);
                AnalysisJob job = jobBuilder.toAnalysisJob(false);
                return job;
            }
        });
        return job;
    }

    protected Map<InputColumn<?>, InputColumn<?>> getInputColumnConversion(AnalysisJob wrappedAnalysisJob) {
        List sourceColumns = wrappedAnalysisJob.getSourceColumns();
        if (this.input.length < sourceColumns.size()) {
            throw new IllegalStateException("Wrapped job defines " + sourceColumns.size() + " columns, but transformer input only defines " + this.input.length);
        }
        LinkedHashMap result = new LinkedHashMap();
        int i = 0;
        Iterator it = sourceColumns.iterator();
        while (it.hasNext()) {
            InputColumn<?> parentColumn = this.input[i];
            InputColumn childColumn = (InputColumn)it.next();
            result.put(parentColumn, childColumn);
            ++i;
        }
        return result;
    }
}

