/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.api.Converter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.beans.transform.PlainSearchReplaceTransformer;
import org.datacleaner.components.fuse.CoalesceUnit;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.SourceColumnMapping;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.data.ConstantInputColumn;
import org.datacleaner.data.ELInputColumn;
import org.datacleaner.data.MetaModelInputColumn;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalysisJobMetadata;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentConfigurationException;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.CompoundComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.ImmutableAnalysisJobMetadata;
import org.datacleaner.job.JobReader;
import org.datacleaner.job.NoSuchColumnException;
import org.datacleaner.job.NoSuchComponentException;
import org.datacleaner.job.NoSuchDatastoreException;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.job.builder.MutableAnalysisJobMetadata;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.job.jaxb.AnalysisType;
import org.datacleaner.job.jaxb.ColumnType;
import org.datacleaner.job.jaxb.ColumnsType;
import org.datacleaner.job.jaxb.ComponentType;
import org.datacleaner.job.jaxb.ConfiguredPropertiesType;
import org.datacleaner.job.jaxb.DataContextType;
import org.datacleaner.job.jaxb.DescriptorType;
import org.datacleaner.job.jaxb.FilterType;
import org.datacleaner.job.jaxb.InputType;
import org.datacleaner.job.jaxb.JobMetadataType;
import org.datacleaner.job.jaxb.JobType;
import org.datacleaner.job.jaxb.MetadataProperties;
import org.datacleaner.job.jaxb.ObjectFactory;
import org.datacleaner.job.jaxb.OutcomeType;
import org.datacleaner.job.jaxb.OutputDataStreamType;
import org.datacleaner.job.jaxb.OutputType;
import org.datacleaner.job.jaxb.SourceType;
import org.datacleaner.job.jaxb.TransformationType;
import org.datacleaner.job.jaxb.TransformerType;
import org.datacleaner.job.jaxb.VariableType;
import org.datacleaner.job.jaxb.VariablesType;
import org.datacleaner.util.JaxbValidationEventHandler;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.convert.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbJobReader
implements JobReader<InputStream> {
    public static final String DATACLEANER_JAXB_VARIABLE_PREFIX = "datacleaner.jaxb.variable.";
    private static final Logger logger = LoggerFactory.getLogger(JaxbJobReader.class);
    private static final JAXBContext _jaxbContext;
    private final DataCleanerConfiguration _configuration;

    public JaxbJobReader(DataCleanerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this._configuration = configuration;
    }

    public AnalysisJob read(InputStream inputStream) throws NoSuchDatastoreException, NoSuchColumnException, NoSuchComponentException, ComponentConfigurationException, IllegalStateException {
        try (AnalysisJobBuilder ajb = this.create(inputStream);){
            AnalysisJob analysisJob = ajb.toAnalysisJob();
            return analysisJob;
        }
    }

    public AnalysisJob read(InputStream inputStream, SourceColumnMapping sourceColumnMapping) {
        try (AnalysisJobBuilder ajb = this.create(inputStream, sourceColumnMapping);){
            AnalysisJob analysisJob = ajb.toAnalysisJob();
            return analysisJob;
        }
    }

    public AnalysisJobMetadata readMetadata(FileObject file) {
        AnalysisJobMetadata analysisJobMetadata;
        InputStream inputStream = null;
        try {
            inputStream = file.getContent().getInputStream();
            analysisJobMetadata = this.readMetadata(inputStream);
        }
        catch (FileSystemException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analysisJobMetadata;
    }

    public AnalysisJobMetadata readMetadata(File file) {
        AnalysisJobMetadata analysisJobMetadata;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            analysisJobMetadata = this.readMetadata(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analysisJobMetadata;
    }

    public AnalysisJobMetadata readMetadata(InputStream inputStream) {
        JobType job = this.unmarshallJob(inputStream);
        return this.readMetadata(job);
    }

    public AnalysisJobMetadata readMetadata(JobType job) {
        Map<Object, Object> metadataProperties;
        Date updatedDate;
        Date createdDate;
        String author;
        String jobDescription;
        String jobVersion;
        String jobName;
        String datastoreName = job.getSource().getDataContext().getRef();
        List<String> sourceColumnPaths = this.getSourceColumnPaths(job);
        List<org.apache.metamodel.schema.ColumnType> sourceColumnTypes = this.getSourceColumnTypes(job);
        Map<String, String> variables = this.getVariables(job);
        JobMetadataType metadata = job.getJobMetadata();
        if (metadata == null) {
            jobName = null;
            jobVersion = null;
            jobDescription = null;
            author = null;
            createdDate = null;
            updatedDate = null;
            metadataProperties = Collections.emptyMap();
        } else {
            jobName = metadata.getJobName();
            jobVersion = metadata.getJobVersion();
            jobDescription = metadata.getJobDescription();
            author = metadata.getAuthor();
            metadataProperties = this.getMetadataProperties(metadata);
            XMLGregorianCalendar createdDateCal = metadata.getCreatedDate();
            createdDate = createdDateCal == null ? null : createdDateCal.toGregorianCalendar().getTime();
            XMLGregorianCalendar updatedDateCal = metadata.getUpdatedDate();
            updatedDate = updatedDateCal == null ? null : updatedDateCal.toGregorianCalendar().getTime();
        }
        return new ImmutableAnalysisJobMetadata(jobName, jobVersion, jobDescription, author, createdDate, updatedDate, datastoreName, sourceColumnPaths, sourceColumnTypes, variables, metadataProperties);
    }

    private Map<String, String> getMetadataProperties(JobMetadataType metadata) {
        MetadataProperties properties = metadata.getMetadataProperties();
        if (properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> metadataProperties = new HashMap<String, String>();
        List<MetadataProperties.Property> property = properties.getProperty();
        for (int i = 0; i < property.size(); ++i) {
            String name = property.get(i).getName();
            String value = property.get(i).getValue();
            metadataProperties.put(name, value);
        }
        return metadataProperties;
    }

    public Map<String, String> getVariables(JobType job) {
        HashMap<String, String> result = new HashMap<String, String>();
        VariablesType variablesType = job.getSource().getVariables();
        if (variablesType != null) {
            List<VariableType> variables = variablesType.getVariable();
            for (VariableType variableType : variables) {
                String id = variableType.getId();
                String value = variableType.getValue();
                result.put(id, value);
            }
        }
        return result;
    }

    public List<String> getSourceColumnPaths(JobType job) {
        List<String> paths;
        ColumnsType columnsType = job.getSource().getColumns();
        if (columnsType != null) {
            List<ColumnType> columns = columnsType.getColumn();
            paths = new ArrayList<String>(columns.size());
            for (ColumnType columnType : columns) {
                String path = columnType.getPath();
                paths.add(path);
            }
        } else {
            paths = Collections.emptyList();
        }
        return paths;
    }

    private List<org.apache.metamodel.schema.ColumnType> getSourceColumnTypes(JobType job) {
        List<org.apache.metamodel.schema.ColumnType> types;
        ColumnsType columnsType = job.getSource().getColumns();
        if (columnsType != null) {
            List<ColumnType> columns = columnsType.getColumn();
            types = new ArrayList<org.apache.metamodel.schema.ColumnType>(columns.size());
            for (ColumnType columnType : columns) {
                String typeName = columnType.getType();
                if (StringUtils.isNullOrEmpty((String)typeName)) {
                    types.add(null);
                    continue;
                }
                try {
                    org.apache.metamodel.schema.ColumnType type = ColumnTypeImpl.valueOf((String)typeName);
                    types.add(type);
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Unrecognized column type: {}", (Object)typeName);
                    types.add(null);
                }
            }
        } else {
            types = Collections.emptyList();
        }
        return types;
    }

    public AnalysisJobBuilder create(FileObject file) {
        AnalysisJobBuilder analysisJobBuilder;
        InputStream inputStream = null;
        try {
            inputStream = file.getContent().getInputStream();
            analysisJobBuilder = this.create(inputStream);
        }
        catch (FileSystemException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analysisJobBuilder;
    }

    public AnalysisJobBuilder create(File file) {
        AnalysisJobBuilder analysisJobBuilder;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            analysisJobBuilder = this.create(inputStream);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analysisJobBuilder;
    }

    public AnalysisJobBuilder create(InputStream inputStream) throws NoSuchDatastoreException {
        return this.create(this.unmarshallJob(inputStream), null, null);
    }

    public AnalysisJobBuilder create(InputStream inputStream, SourceColumnMapping sourceColumnMapping) throws NoSuchDatastoreException {
        return this.create(inputStream, sourceColumnMapping, null);
    }

    public AnalysisJobBuilder create(InputStream inputStream, SourceColumnMapping sourceColumnMapping, Map<String, String> variableOverrides) throws NoSuchDatastoreException {
        return this.create(this.unmarshallJob(inputStream), sourceColumnMapping, variableOverrides);
    }

    public AnalysisJobBuilder create(InputStream inputStream, Map<String, String> variableOverrides) throws NoSuchDatastoreException {
        return this.create(this.unmarshallJob(inputStream), null, variableOverrides);
    }

    public AnalysisJobBuilder create(InputStream inputStream, Map<String, String> variableOverrides, Datastore datastore) {
        JobType jobType = this.unmarshallJob(inputStream);
        SourceColumnMapping sourceColumnMapping = new SourceColumnMapping(this.readMetadata(jobType));
        sourceColumnMapping.autoMap(datastore);
        return this.create(jobType, sourceColumnMapping, variableOverrides);
    }

    private JobType unmarshallJob(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = _jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            JobType job = (JobType)unmarshaller.unmarshal(inputStream);
            return job;
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public AnalysisJobBuilder create(JobType job) {
        return this.create(job, null, null);
    }

    public AnalysisJobBuilder create(JobType job, SourceColumnMapping sourceColumnMapping, Map<String, String> variableOverrides) throws NoSuchDatastoreException {
        JobMetadataType metadata;
        if (job == null) {
            throw new IllegalArgumentException("Job cannot be null");
        }
        if (sourceColumnMapping != null && !sourceColumnMapping.isSatisfied()) {
            throw new IllegalArgumentException("Source column mapping is not satisfied!");
        }
        Map<String, String> variables = this.getVariables(job);
        if (variableOverrides != null) {
            Set<Map.Entry<String, String>> entrySet = variableOverrides.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String value;
                String key = entry.getKey();
                String originalValue = variables.put(key, value = entry.getValue());
                if (originalValue == null) {
                    logger.debug("Setting variable: {}={}", (Object)key, (Object)value);
                    continue;
                }
                logger.info("Overriding variable: {}={} (original value was {})", new Object[]{key, value, originalValue});
            }
        }
        if ((metadata = job.getJobMetadata()) != null) {
            logger.info("Job name: {}", (Object)metadata.getJobName());
            logger.info("Job version: {}", (Object)metadata.getJobVersion());
            logger.info("Job description: {}", (Object)metadata.getJobDescription());
            logger.info("Author: {}", (Object)metadata.getAuthor());
            logger.info("Created date: {}", (Object)metadata.getCreatedDate());
            logger.info("Updated date: {}", (Object)metadata.getUpdatedDate());
            logger.info("Job metadata properties: {}", this.getMetadataProperties(metadata));
        }
        AnalysisJobBuilder builder = new AnalysisJobBuilder(this._configuration);
        try {
            AnalysisJobBuilder result = this.create(job, sourceColumnMapping, metadata, variables, builder);
            return result;
        }
        catch (RuntimeException e) {
            FileHelper.safeClose((Object[])new Object[]{builder});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnalysisJobBuilder create(JobType job, SourceColumnMapping sourceColumnMapping, JobMetadataType metadata, Map<String, String> variables, AnalysisJobBuilder analysisJobBuilder) {
        DatastoreConnection datastoreConnection;
        Datastore datastore;
        SourceType source = job.getSource();
        if (sourceColumnMapping == null) {
            DataContextType dataContext = source.getDataContext();
            String ref = dataContext.getRef();
            if (StringUtils.isNullOrEmpty((String)ref)) {
                throw new IllegalStateException("Datastore ref cannot be null");
            }
            datastore = this._configuration.getDatastoreCatalog().getDatastore(ref);
            if (datastore == null) {
                throw new NoSuchDatastoreException(ref);
            }
            datastoreConnection = datastore.openConnection();
            List<String> sourceColumnPaths = this.getSourceColumnPaths(job);
            sourceColumnMapping = new SourceColumnMapping(sourceColumnPaths);
            sourceColumnMapping.autoMap(datastore);
        } else {
            datastore = sourceColumnMapping.getDatastore();
            datastoreConnection = datastore.openConnection();
        }
        try {
            analysisJobBuilder.setDatastore(datastore);
            if (metadata != null) {
                ImmutableAnalysisJobMetadata immutableAnalysisJobMetadata = new ImmutableAnalysisJobMetadata(metadata.getJobName(), metadata.getJobVersion(), metadata.getJobDescription(), metadata.getAuthor(), this.convertToDate(metadata.getCreatedDate()), this.convertToDate(metadata.getUpdatedDate()), datastore.getName(), this.getSourceColumnPaths(job), this.getSourceColumnTypes(job), variables, this.getMetadataProperties(metadata));
                analysisJobBuilder.setAnalysisJobMetadata((AnalysisJobMetadata)immutableAnalysisJobMetadata);
            } else if (variables.size() > 0) {
                MutableAnalysisJobMetadata mutableAnalysisJobMetadata = new MutableAnalysisJobMetadata();
                mutableAnalysisJobMetadata.getVariables().putAll(variables);
                analysisJobBuilder.setAnalysisJobMetadata((AnalysisJobMetadata)mutableAnalysisJobMetadata);
            }
            Map<String, InputColumn<?>> inputColumns = this.readSourceColumns(sourceColumnMapping, analysisJobBuilder, source);
            this.configureComponents(job, variables, analysisJobBuilder, inputColumns);
            AnalysisJobBuilder analysisJobBuilder2 = analysisJobBuilder;
            return analysisJobBuilder2;
        }
        finally {
            datastoreConnection.close();
        }
    }

    private void configureComponents(JobType job, Map<String, String> variables, AnalysisJobBuilder analysisJobBuilder, Map<String, InputColumn<?>> inputColumns) {
        StringConverter stringConverter = this.createStringConverter(analysisJobBuilder);
        DescriptorProvider descriptorProvider = this._configuration.getEnvironment().getDescriptorProvider();
        HashMap<ComponentType, ComponentBuilder> componentBuilders = new HashMap<ComponentType, ComponentBuilder>();
        List<ColumnType> columnsTypes = job.getSource().getColumns().getColumn();
        List<ComponentType> allComponentTypes = this.getAllComponentTypes(job);
        for (ComponentType componentType : allComponentTypes) {
            ComponentBuilder componentBuilder = this.createComponentBuilder(analysisJobBuilder, descriptorProvider, componentType);
            this.initializeComponentBuilder(variables, stringConverter, componentBuilders, componentType, componentBuilder, inputColumns, columnsTypes);
        }
        this.wireInputColumns(inputColumns, componentBuilders);
        this.wireRequirements(componentBuilders);
        this.wireOutputDataStreams(componentBuilders);
    }

    private void wireOutputDataStreams(Map<ComponentType, ComponentBuilder> componentBuilders) {
        for (Map.Entry<ComponentType, ComponentBuilder> entry : componentBuilders.entrySet()) {
            ComponentType componentType = entry.getKey();
            ComponentBuilder componentBuilder = entry.getValue();
            for (OutputDataStreamType outputDataStreamType : componentType.getOutputDataStream()) {
                String name = outputDataStreamType.getName();
                OutputDataStream outputDataStream = componentBuilder.getOutputDataStream(name);
                AnalysisJobBuilder outputDataStreamJobBuilder = componentBuilder.getOutputDataStreamJobBuilder(outputDataStream);
                JobType job = outputDataStreamType.getJob();
                List<ColumnType> sourceColumnTypes = job.getSource().getColumns().getColumn();
                List sourceColumns = outputDataStreamJobBuilder.getSourceColumns();
                HashMap inputColumns = new HashMap();
                for (int i = 0; i < sourceColumnTypes.size(); ++i) {
                    ColumnType sourceColumnPath = sourceColumnTypes.get(i);
                    String outputStreamColumnPathName = this.getOutputStreamColumnPath(sourceColumnTypes.get(i).getPath(), componentType, componentBuilder, i);
                    sourceColumns.stream().filter(inputColumn -> inputColumn.getName().equals(outputStreamColumnPathName)).forEach(inputColumn -> {
                        InputColumn cfr_ignored_0 = (InputColumn)inputColumns.put(sourceColumnPath.getId(), (InputColumn<?>)inputColumn);
                    });
                }
                this.configureComponents(job, this.getVariables(job), outputDataStreamJobBuilder, inputColumns);
            }
        }
    }

    private String getOutputStreamColumnPath(String suggestedPath, ComponentType componentType, ComponentBuilder componentBuilder, int sourceColumnIndex) {
        if (componentType.getDescriptor().getRef().equals("Union")) {
            ConfiguredPropertyDescriptor configuredPropertyDescriptor = componentBuilder.getDescriptor().getConfiguredProperty("Units");
            CoalesceUnit[] units = (CoalesceUnit[])componentBuilder.getConfiguredProperty(configuredPropertyDescriptor);
            CoalesceUnit unit = units[sourceColumnIndex];
            return unit.getSuggestedOutputColumnName();
        }
        return suggestedPath;
    }

    private void wireRequirements(Map<ComponentType, ComponentBuilder> componentBuilders) {
        HashMap<String, FilterOutcome> outcomeMapping = new HashMap<String, FilterOutcome>();
        for (ComponentType componentType : componentBuilders.keySet()) {
            if (!(componentType instanceof FilterType)) continue;
            FilterType filterType = (FilterType)componentType;
            FilterComponentBuilder filterBuilder = (FilterComponentBuilder)componentBuilders.get(componentType);
            List<OutcomeType> outcomeTypes = filterType.getOutcome();
            for (OutcomeType outcomeType : outcomeTypes) {
                String categoryName = outcomeType.getCategory();
                Enum category = ((FilterDescriptor)filterBuilder.getDescriptor()).getOutcomeCategoryByName(categoryName);
                if (category == null) {
                    throw new ComponentConfigurationException("No such outcome category name: " + categoryName + " (in " + ((FilterDescriptor)filterBuilder.getDescriptor()).getDisplayName() + ")");
                }
                String id = outcomeType.getId();
                if (StringUtils.isNullOrEmpty((String)id)) {
                    throw new IllegalStateException("Outcome id cannot be null");
                }
                if (outcomeMapping.containsKey(id)) {
                    throw new ComponentConfigurationException("Outcome id '" + id + "' is not unique");
                }
                outcomeMapping.put(id, filterBuilder.getFilterOutcome((Object)category));
            }
        }
        for (ComponentType componentType : componentBuilders.keySet()) {
            this.wireRequirement(outcomeMapping, componentBuilders, componentType);
        }
    }

    private ComponentBuilder createComponentBuilder(AnalysisJobBuilder analysisJobBuilder, DescriptorProvider descriptorProvider, ComponentType componentType) {
        String ref = componentType.getDescriptor().getRef();
        if (StringUtils.isNullOrEmpty((String)ref)) {
            throw new IllegalStateException(componentType.getClass().getSimpleName() + " descriptor ref cannot be null");
        }
        ComponentDescriptor descriptor = descriptorProvider.getComponentDescriptorByDisplayName(ref);
        if (descriptor == null) {
            throw new NoSuchComponentException(componentType.getClass(), ref);
        }
        return analysisJobBuilder.addComponent(descriptor);
    }

    private List<ComponentType> getAllComponentTypes(JobType job) {
        AnalysisType analysis;
        ArrayList<ComponentType> result = new ArrayList<ComponentType>();
        TransformationType transformation = job.getTransformation();
        if (transformation != null) {
            result.addAll(transformation.getTransformerOrFilter());
        }
        if ((analysis = job.getAnalysis()) != null) {
            result.addAll(analysis.getAnalyzer());
        }
        return result;
    }

    private void wireInputColumns(Map<String, InputColumn<?>> inputColumns, Map<ComponentType, ComponentBuilder> componentBuilders) {
        LinkedList<ComponentType> unconfiguredComponentKeys = new LinkedList<ComponentType>(componentBuilders.keySet());
        while (!unconfiguredComponentKeys.isEmpty()) {
            boolean progress = false;
            Iterator it = unconfiguredComponentKeys.iterator();
            while (it.hasNext()) {
                boolean configurable = true;
                ComponentType unconfiguredTransformerKey = (ComponentType)it.next();
                List<InputType> input = unconfiguredTransformerKey.getInput();
                for (InputType inputType : input) {
                    String ref = inputType.getRef();
                    if (StringUtils.isNullOrEmpty((String)ref)) {
                        String value = inputType.getValue();
                        if (value != null) continue;
                        throw new IllegalStateException("Component input column ref & value cannot be null");
                    }
                    if (inputColumns.containsKey(ref)) continue;
                    configurable = false;
                    break;
                }
                if (!configurable) continue;
                progress = true;
                ComponentBuilder componentBuilder = componentBuilders.get(unconfiguredTransformerKey);
                this.applyInputColumns(input, inputColumns, componentBuilder);
                if (componentBuilder instanceof TransformerComponentBuilder) {
                    TransformerComponentBuilder transformerBuilder = (TransformerComponentBuilder)componentBuilder;
                    TransformerType transformerType = (TransformerType)unconfiguredTransformerKey;
                    List outputColumns = transformerBuilder.getOutputColumns();
                    List<OutputType> output = transformerType.getOutput();
                    if (outputColumns.size() < output.size()) {
                        String message = "Expected " + outputColumns.size() + " output column(s), but found " + output.size() + " (" + transformerBuilder + ")";
                        if (outputColumns.isEmpty()) {
                            try {
                                transformerBuilder.isConfigured(true);
                            }
                            catch (Exception e) {
                                throw new ComponentConfigurationException(message, (Throwable)e);
                            }
                        }
                        throw new ComponentConfigurationException(message);
                    }
                    for (int i = 0; i < output.size(); ++i) {
                        String id;
                        Boolean hidden;
                        OutputType o1 = output.get(i);
                        MutableInputColumn o2 = (MutableInputColumn)outputColumns.get(i);
                        String name = o1.getName();
                        if (!StringUtils.isNullOrEmpty((String)name)) {
                            o2.setName(name);
                        }
                        if ((hidden = o1.isHidden()) != null && hidden.booleanValue()) {
                            o2.setHidden(true);
                        }
                        if (StringUtils.isNullOrEmpty((String)(id = o1.getId()))) {
                            throw new IllegalStateException("Transformer output column id cannot be null");
                        }
                        this.registerInputColumn(inputColumns, id, (InputColumn<?>)o2);
                    }
                }
                it.remove();
            }
            if (progress) continue;
            StringBuilder sb = new StringBuilder();
            for (ComponentType transformerType : unconfiguredComponentKeys) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                DescriptorType descriptor = transformerType.getDescriptor();
                sb.append(descriptor.getRef());
                sb.append("(input: ");
                List<InputType> input = transformerType.getInput();
                int i = 0;
                for (InputType inputType : input) {
                    String ref;
                    if (i != 0) {
                        sb.append(", ");
                    }
                    if (StringUtils.isNullOrEmpty((String)(ref = inputType.getRef()))) {
                        sb.append("value=" + inputType.getValue());
                    } else {
                        sb.append("ref=" + ref);
                    }
                    ++i;
                }
                sb.append(")");
            }
            throw new ComponentConfigurationException("Could not connect column dependencies for components: " + sb.toString());
        }
    }

    private void initializeComponentBuilder(Map<String, String> variables, StringConverter stringConverter, Map<ComponentType, ComponentBuilder> componentBuilders, ComponentType componentType, ComponentBuilder componentBuilder, Map<String, InputColumn<?>> inputColumns, List<ColumnType> columnsTypes) {
        componentBuilder.setName(componentType.getName());
        this.applyProperties(componentBuilder, componentType.getProperties(), componentType.getMetadataProperties(), stringConverter, variables, inputColumns, columnsTypes);
        componentBuilders.put(componentType, componentBuilder);
    }

    private void wireRequirement(Map<String, FilterOutcome> outcomeMapping, Map<ComponentType, ComponentBuilder> componentBuilders, ComponentType componentType) {
        String ref = componentType.getRequires();
        if (ref != null) {
            ComponentBuilder builder = componentBuilders.get(componentType);
            ComponentRequirement requirement = this.getRequirement(ref, outcomeMapping);
            builder.setComponentRequirement(requirement);
        }
    }

    private Map<String, InputColumn<?>> readSourceColumns(SourceColumnMapping sourceColumnMapping, AnalysisJobBuilder analysisJobBuilder, SourceType source) {
        HashMap inputColumns = new HashMap();
        ColumnsType columnsType = source.getColumns();
        if (columnsType != null) {
            List<ColumnType> columns = columnsType.getColumn();
            for (ColumnType column : columns) {
                org.apache.metamodel.schema.ColumnType actualType;
                String path = column.getPath();
                if (StringUtils.isNullOrEmpty((String)path)) {
                    throw new IllegalStateException("Column path cannot be null");
                }
                Column physicalColumn = sourceColumnMapping.getColumn(path);
                if (physicalColumn == null) {
                    logger.error("Column {} not found in {}", (Object)path, (Object)sourceColumnMapping);
                    throw new NoSuchColumnException(path);
                }
                MetaModelInputColumn inputColumn = new MetaModelInputColumn(physicalColumn);
                String id = column.getId();
                if (StringUtils.isNullOrEmpty((String)id)) {
                    throw new IllegalStateException("Source column id cannot be null");
                }
                String expectedType = column.getType();
                if (expectedType != null && (actualType = physicalColumn.getType()) != null && !expectedType.equals(actualType.toString())) {
                    logger.warn("Column '{}' had type '{}', but '{}' was expected.", new Object[]{path, actualType, expectedType});
                }
                this.registerInputColumn(inputColumns, id, (InputColumn<?>)inputColumn);
                analysisJobBuilder.addSourceColumn(inputColumn);
            }
        }
        return inputColumns;
    }

    private Date convertToDate(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            return calendar.toGregorianCalendar().getTime();
        }
        return null;
    }

    private ComponentRequirement getRequirement(String ref, Map<String, FilterOutcome> outcomeMapping) {
        if ("_any_".equals(ref)) {
            return AnyComponentRequirement.get();
        }
        FilterOutcome filterOutcome = outcomeMapping.get(ref);
        if (filterOutcome != null) {
            return new SimpleComponentRequirement(filterOutcome);
        }
        ArrayList tokens = Lists.newArrayList((Iterable)Splitter.on((String)" OR ").omitEmptyStrings().trimResults().split((CharSequence)ref));
        if (tokens.size() > 1) {
            ArrayList<FilterOutcome> list = new ArrayList<FilterOutcome>(tokens.size());
            for (String token : tokens) {
                FilterOutcome filterOutcome2 = outcomeMapping.get(token);
                if (filterOutcome2 == null) {
                    throw new ComponentConfigurationException("Could not resolve outcome '" + token + "' in requirement: " + ref);
                }
                list.add(filterOutcome2);
            }
            return new CompoundComponentRequirement(list);
        }
        throw new ComponentConfigurationException("Could not resolve requirement: " + ref);
    }

    private void applyInputColumns(List<InputType> input, Map<String, InputColumn<?>> inputColumns, ComponentBuilder componentBuilder) {
        ArrayListMultimap inputMap = ArrayListMultimap.create();
        for (InputType inputType : input) {
            ConfiguredPropertyDescriptor propertyDescriptor;
            String name = inputType.getName();
            String ref = inputType.getRef();
            InputColumn<?> inputColumn = StringUtils.isNullOrEmpty((String)ref) ? this.createExpressionBasedInputColumn(inputType) : inputColumns.get(ref);
            if (StringUtils.isNullOrEmpty((String)name)) {
                propertyDescriptor = componentBuilder.getDefaultConfiguredPropertyForInput();
                inputMap.put((Object)propertyDescriptor, inputColumn);
                continue;
            }
            propertyDescriptor = componentBuilder.getDescriptor().getConfiguredProperty(name);
            inputMap.put((Object)propertyDescriptor, inputColumn);
        }
        Set keys = inputMap.keySet();
        for (ConfiguredPropertyDescriptor propertyDescriptor : keys) {
            List inputColumnsForProperty = inputMap.get((Object)propertyDescriptor);
            componentBuilder.addInputColumns((Collection)inputColumnsForProperty, propertyDescriptor);
        }
    }

    private StringConverter createStringConverter(AnalysisJobBuilder analysisJobBuilder) {
        AnalysisJob job = analysisJobBuilder.toAnalysisJob(false);
        return new StringConverter(this._configuration, job);
    }

    private InputColumn<?> createExpressionBasedInputColumn(InputType inputType) {
        String expression = inputType.getValue();
        if (expression == null) {
            throw new IllegalStateException("Input ref & value cannot both be null");
        }
        if (expression.indexOf("#{") == -1) {
            return new ConstantInputColumn(expression);
        }
        return new ELInputColumn(expression);
    }

    private void registerInputColumn(Map<String, InputColumn<?>> inputColumns, String id, InputColumn<?> inputColumn) {
        if (StringUtils.isNullOrEmpty((String)id)) {
            throw new IllegalStateException("Column id cannot be null");
        }
        if (inputColumns.containsKey(id)) {
            throw new ComponentConfigurationException("Column id is not unique: " + id);
        }
        inputColumns.put(id, inputColumn);
    }

    private void applyProperties(ComponentBuilder builder, ConfiguredPropertiesType configuredPropertiesType, MetadataProperties metadataPropertiesType, StringConverter stringConverter, Map<String, String> variables, Map<String, InputColumn<?>> mappingInputColumns, List<ColumnType> columnsTypes) {
        if (configuredPropertiesType != null) {
            List<ConfiguredPropertiesType.Property> properties = configuredPropertiesType.getProperty();
            ComponentDescriptor descriptor = builder.getDescriptor();
            HashMap<String, String> removedProperties = new HashMap<String, String>();
            for (ConfiguredPropertiesType.Property property : properties) {
                String name = property.getName();
                if (JaxbJobReader.isRemovedProperty(descriptor, name)) {
                    removedProperties.put(name, this.getValue(property));
                    continue;
                }
                ConfiguredPropertyDescriptor configuredProperty = descriptor.getConfiguredProperty(name);
                if (configuredProperty == null) {
                    throw new ComponentConfigurationException("No such property: " + name);
                }
                String stringValue = this.getValue(property);
                if (stringValue == null) {
                    String variableRef = property.getRef();
                    if (variableRef == null) {
                        throw new IllegalStateException("Neither value nor ref was specified for property: " + name);
                    }
                    stringValue = variables.get(variableRef);
                    if (stringValue == null) {
                        throw new ComponentConfigurationException("No such variable: " + variableRef);
                    }
                    builder.getMetadataProperties().put(DATACLEANER_JAXB_VARIABLE_PREFIX + configuredProperty.getName(), variableRef);
                }
                Converter customConverter = configuredProperty.createCustomConverter();
                Object value = stringConverter.deserialize(stringValue, configuredProperty.getType(), customConverter);
                if (value instanceof CoalesceUnit[]) {
                    CoalesceUnit[] units = (CoalesceUnit[])value;
                    ArrayList<CoalesceUnit> newUnitsList = new ArrayList<CoalesceUnit>();
                    Set<Map.Entry<String, InputColumn<?>>> mappingColumnsSet = mappingInputColumns.entrySet();
                    for (int i = 0; i < units.length; ++i) {
                        String[] oldInputColumns = units[i].getInputColumnNames();
                        ArrayList<String> newInputColumns = new ArrayList<String>();
                        for (int j = 0; j < oldInputColumns.length; ++j) {
                            String oldColumn = oldInputColumns[j];
                            boolean found = false;
                            for (Map.Entry<String, InputColumn<?>> entry : mappingColumnsSet) {
                                String column_id = entry.getKey();
                                String path = this.getPath(columnsTypes, column_id);
                                if (!oldColumn.contains('.' + path)) continue;
                                InputColumn<?> entryValue = entry.getValue();
                                if (entryValue.isPhysicalColumn()) {
                                    newInputColumns.add(entryValue.getPhysicalColumn().getQualifiedLabel());
                                } else {
                                    newInputColumns.add(entryValue.getName());
                                }
                                found = true;
                                break;
                            }
                            if (found) continue;
                            newInputColumns.add(oldInputColumns[j]);
                        }
                        if (newInputColumns.isEmpty()) continue;
                        CoalesceUnit newCoalesceUnit = new CoalesceUnit(newInputColumns.toArray(new String[0]));
                        newUnitsList.add(newCoalesceUnit);
                    }
                    if (!newUnitsList.isEmpty()) {
                        CoalesceUnit[] newUnits = newUnitsList.toArray(new CoalesceUnit[0]);
                        builder.setConfiguredProperty(configuredProperty, (Object)newUnits);
                    } else {
                        builder.setConfiguredProperty(configuredProperty, value);
                    }
                } else {
                    builder.setConfiguredProperty(configuredProperty, value);
                }
                logger.debug("Setting property '{}' to {}", (Object)name, value);
            }
            JaxbJobReader.processRemovedProperties(builder, stringConverter, descriptor, removedProperties);
        }
        if (metadataPropertiesType != null) {
            List<MetadataProperties.Property> propertyList = metadataPropertiesType.getProperty();
            for (MetadataProperties.Property property : propertyList) {
                String name = property.getName();
                String value = property.getValue();
                builder.setMetadataProperty(name, value);
            }
        }
    }

    private String getPath(List<ColumnType> columnsTypes, String column_id) {
        for (ColumnType column : columnsTypes) {
            if (!column_id.equals(column.getId())) continue;
            return column.getPath();
        }
        return null;
    }

    private static void processRemovedProperties(ComponentBuilder builder, StringConverter stringConverter, ComponentDescriptor<?> descriptor, Map<String, String> removedProperties) {
        if (descriptor.getComponentClass() == PlainSearchReplaceTransformer.class) {
            PlainSearchReplaceTransformer.processRemovedProperties((ComponentBuilder)builder, (StringConverter)stringConverter, descriptor, removedProperties);
        }
    }

    private static boolean isRemovedProperty(ComponentDescriptor<?> descriptor, String name) {
        return PlainSearchReplaceTransformer.isRemovedProperty(descriptor, (String)name);
    }

    private String getValue(ConfiguredPropertiesType.Property property) {
        String value = property.getValue();
        if (StringUtils.isNullOrEmpty((String)value)) {
            String valueAttribute = property.getValueAttribute();
            if (value != null) {
                value = valueAttribute;
            }
        }
        return value;
    }

    static {
        try {
            _jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

