/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.xml.XmlSaxTableDef;
import org.datacleaner.configuration.ConfigurationReader;
import org.datacleaner.configuration.ConfigurationReaderInterceptor;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.DataCleanerEnvironment;
import org.datacleaner.configuration.DataCleanerEnvironmentImpl;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.configuration.DefaultConfigurationReaderInterceptor;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.JaxbPojoDatastoreAdaptor;
import org.datacleaner.configuration.RemoteServerConfiguration;
import org.datacleaner.configuration.RemoteServerConfigurationImpl;
import org.datacleaner.configuration.RemoteServerData;
import org.datacleaner.configuration.RemoteServerDataImpl;
import org.datacleaner.configuration.ServerInformation;
import org.datacleaner.configuration.ServerInformationCatalog;
import org.datacleaner.configuration.ServerInformationCatalogImpl;
import org.datacleaner.configuration.TemporaryMutableDataCleanerEnvironment;
import org.datacleaner.configuration.jaxb.AbstractDatastoreType;
import org.datacleaner.configuration.jaxb.AccessDatastoreType;
import org.datacleaner.configuration.jaxb.BerkeleyDbStorageProviderType;
import org.datacleaner.configuration.jaxb.CassandraDatastoreType;
import org.datacleaner.configuration.jaxb.ClasspathScannerType;
import org.datacleaner.configuration.jaxb.CombinedStorageProviderType;
import org.datacleaner.configuration.jaxb.CompositeDatastoreType;
import org.datacleaner.configuration.jaxb.Configuration;
import org.datacleaner.configuration.jaxb.ConfigurationMetadataType;
import org.datacleaner.configuration.jaxb.CouchdbDatastoreType;
import org.datacleaner.configuration.jaxb.CsvDatastoreType;
import org.datacleaner.configuration.jaxb.CustomElementType;
import org.datacleaner.configuration.jaxb.DatahubDatastoreType;
import org.datacleaner.configuration.jaxb.DatahubsecuritymodeEnum;
import org.datacleaner.configuration.jaxb.DatastoreCatalogType;
import org.datacleaner.configuration.jaxb.DatastoreDictionaryType;
import org.datacleaner.configuration.jaxb.DatastoreSynonymCatalogType;
import org.datacleaner.configuration.jaxb.DbaseDatastoreType;
import org.datacleaner.configuration.jaxb.DescriptorProvidersType;
import org.datacleaner.configuration.jaxb.ElasticSearchDatastoreType;
import org.datacleaner.configuration.jaxb.ExcelDatastoreType;
import org.datacleaner.configuration.jaxb.FixedWidthDatastoreType;
import org.datacleaner.configuration.jaxb.HadoopClusterType;
import org.datacleaner.configuration.jaxb.HbaseDatastoreType;
import org.datacleaner.configuration.jaxb.InMemoryStorageProviderType;
import org.datacleaner.configuration.jaxb.JdbcDatastoreType;
import org.datacleaner.configuration.jaxb.JsonDatastoreType;
import org.datacleaner.configuration.jaxb.MongodbDatastoreType;
import org.datacleaner.configuration.jaxb.MultithreadedTaskrunnerType;
import org.datacleaner.configuration.jaxb.Neo4JDatastoreType;
import org.datacleaner.configuration.jaxb.ObjectFactory;
import org.datacleaner.configuration.jaxb.OpenOfficeDatabaseDatastoreType;
import org.datacleaner.configuration.jaxb.PojoDatastoreType;
import org.datacleaner.configuration.jaxb.ReferenceDataCatalogType;
import org.datacleaner.configuration.jaxb.RegexPatternType;
import org.datacleaner.configuration.jaxb.RegexSwapPatternType;
import org.datacleaner.configuration.jaxb.RemoteComponentServerType;
import org.datacleaner.configuration.jaxb.RemoteComponentsType;
import org.datacleaner.configuration.jaxb.SalesforceDatastoreType;
import org.datacleaner.configuration.jaxb.SasDatastoreType;
import org.datacleaner.configuration.jaxb.ServersType;
import org.datacleaner.configuration.jaxb.SimplePatternType;
import org.datacleaner.configuration.jaxb.SinglethreadedTaskrunnerType;
import org.datacleaner.configuration.jaxb.StorageProviderType;
import org.datacleaner.configuration.jaxb.SugarCrmDatastoreType;
import org.datacleaner.configuration.jaxb.TableTypeEnum;
import org.datacleaner.configuration.jaxb.TextFileDictionaryType;
import org.datacleaner.configuration.jaxb.TextFileSynonymCatalogType;
import org.datacleaner.configuration.jaxb.ValueListDictionaryType;
import org.datacleaner.configuration.jaxb.XmlDatastoreType;
import org.datacleaner.connection.AccessDatastore;
import org.datacleaner.connection.CassandraDatastore;
import org.datacleaner.connection.CompositeDatastore;
import org.datacleaner.connection.CouchDbDatastore;
import org.datacleaner.connection.CsvDatastore;
import org.datacleaner.connection.DataHubDatastore;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreCatalogImpl;
import org.datacleaner.connection.DbaseDatastore;
import org.datacleaner.connection.ElasticSearchDatastore;
import org.datacleaner.connection.ExcelDatastore;
import org.datacleaner.connection.FixedWidthDatastore;
import org.datacleaner.connection.HBaseDatastore;
import org.datacleaner.connection.JdbcDatastore;
import org.datacleaner.connection.JsonDatastore;
import org.datacleaner.connection.MongoDbDatastore;
import org.datacleaner.connection.Neo4jDatastore;
import org.datacleaner.connection.OdbDatastore;
import org.datacleaner.connection.SalesforceDatastore;
import org.datacleaner.connection.SasDatastore;
import org.datacleaner.connection.SugarCrmDatastore;
import org.datacleaner.connection.XmlDatastore;
import org.datacleaner.descriptors.ClasspathScanDescriptorProvider;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.CompositeDescriptorProvider;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.descriptors.RemoteDescriptorProvider;
import org.datacleaner.descriptors.RemoteDescriptorProviderImpl;
import org.datacleaner.job.concurrent.MultiThreadedTaskRunner;
import org.datacleaner.job.concurrent.SingleThreadedTaskRunner;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.metamodel.datahub.DataHubSecurityMode;
import org.datacleaner.reference.DatastoreDictionary;
import org.datacleaner.reference.DatastoreSynonymCatalog;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.ReferenceData;
import org.datacleaner.reference.ReferenceDataCatalog;
import org.datacleaner.reference.ReferenceDataCatalogImpl;
import org.datacleaner.reference.RegexStringPattern;
import org.datacleaner.reference.SimpleDictionary;
import org.datacleaner.reference.SimpleStringPattern;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.reference.TextFileDictionary;
import org.datacleaner.reference.TextFileSynonymCatalog;
import org.datacleaner.reference.regexswap.Category;
import org.datacleaner.reference.regexswap.Regex;
import org.datacleaner.reference.regexswap.RegexSwapStringPattern;
import org.datacleaner.server.DirectConnectionHadoopClusterInformation;
import org.datacleaner.server.DirectoryBasedHadoopClusterInformation;
import org.datacleaner.server.EnvironmentBasedHadoopClusterInformation;
import org.datacleaner.storage.BerkeleyDbStorageProvider;
import org.datacleaner.storage.CombinedStorageProvider;
import org.datacleaner.storage.InMemoryStorageProvider;
import org.datacleaner.storage.StorageProvider;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.JaxbValidationEventHandler;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.SecurityUtils;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.convert.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaxbConfigurationReader
implements ConfigurationReader<InputStream> {
    private static final Logger logger = LoggerFactory.getLogger(JaxbConfigurationReader.class);
    private final JAXBContext _jaxbContext;
    private final ConfigurationReaderInterceptor _interceptor;
    private final Deque<String> _variablePathBuilder;

    public JaxbConfigurationReader() {
        this(null);
    }

    public JaxbConfigurationReader(ConfigurationReaderInterceptor interceptor) {
        if (interceptor == null) {
            interceptor = new DefaultConfigurationReaderInterceptor();
        }
        this._interceptor = interceptor;
        this._variablePathBuilder = new ArrayDeque<String>(4);
        try {
            this._jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public DataCleanerConfiguration read(InputStream input) {
        return this.create(input);
    }

    public DataCleanerConfiguration create(FileObject file) {
        DataCleanerConfiguration dataCleanerConfiguration;
        InputStream inputStream = null;
        try {
            inputStream = file.getContent().getInputStream();
            dataCleanerConfiguration = this.create(inputStream);
        }
        catch (FileSystemException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return dataCleanerConfiguration;
    }

    public DataCleanerConfiguration create(File file) {
        DataCleanerConfiguration dataCleanerConfiguration;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            dataCleanerConfiguration = this.create(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return dataCleanerConfiguration;
    }

    public DataCleanerConfiguration create(InputStream inputStream) {
        Configuration configuration = this.unmarshall(inputStream);
        return this.create(configuration);
    }

    public Configuration unmarshall(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            return (Configuration)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public void marshall(Configuration configuration, OutputStream outputStream) {
        try {
            Marshaller marshaller = this._jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            marshaller.marshal((Object)configuration, outputStream);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public DataCleanerConfiguration create(Configuration jaxbConfiguration) {
        ConfigurationMetadataType metadata = jaxbConfiguration.getConfigurationMetadata();
        if (metadata != null) {
            logger.info("Configuration name: {}", (Object)metadata.getConfigurationName());
            logger.info("Configuration version: {}", (Object)metadata.getConfigurationVersion());
            logger.info("Configuration description: {}", (Object)metadata.getConfigurationDescription());
            logger.info("Author: {}", (Object)metadata.getAuthor());
            logger.info("Created date: {}", (Object)metadata.getCreatedDate());
            logger.info("Updated date: {}", (Object)metadata.getUpdatedDate());
        }
        DataCleanerHomeFolder homeFolder = this._interceptor.getHomeFolder();
        TemporaryMutableDataCleanerEnvironment temporaryEnvironment = new TemporaryMutableDataCleanerEnvironment(this._interceptor.createBaseEnvironment());
        DataCleanerConfigurationImpl temporaryConfiguration = new DataCleanerConfigurationImpl((DataCleanerEnvironment)temporaryEnvironment, homeFolder);
        this.updateTaskRunnerIfSpecified(jaxbConfiguration, temporaryEnvironment, (DataCleanerConfiguration)temporaryConfiguration);
        this.updateStorageProviderIfSpecified(jaxbConfiguration, temporaryEnvironment, (DataCleanerConfiguration)temporaryConfiguration);
        this.updateDescriptorProviderIfSpecified(jaxbConfiguration, temporaryEnvironment, (DataCleanerConfiguration)temporaryConfiguration);
        ServerInformationCatalog serverInformationCatalog = this.createServerInformationCatalog(jaxbConfiguration.getServers(), temporaryConfiguration, temporaryEnvironment);
        temporaryConfiguration = temporaryConfiguration.withServerInformationCatalog(serverInformationCatalog);
        this.addVariablePath("datastoreCatalog");
        DatastoreCatalog datastoreCatalog = this.createDatastoreCatalog(jaxbConfiguration.getDatastoreCatalog(), temporaryConfiguration, temporaryEnvironment);
        this.removeVariablePath();
        temporaryConfiguration = temporaryConfiguration.withDatastoreCatalog(datastoreCatalog);
        this.addVariablePath("referenceDataCatalog");
        ReferenceDataCatalog referenceDataCatalog = this.createReferenceDataCatalog(jaxbConfiguration.getReferenceDataCatalog(), temporaryEnvironment, (DataCleanerConfiguration)temporaryConfiguration);
        this.removeVariablePath();
        DataCleanerEnvironmentImpl finalEnvironment = new DataCleanerEnvironmentImpl((DataCleanerEnvironment)temporaryEnvironment);
        return new DataCleanerConfigurationImpl((DataCleanerEnvironment)finalEnvironment, homeFolder, datastoreCatalog, referenceDataCatalog, serverInformationCatalog);
    }

    private void updateDescriptorProviderIfSpecified(Configuration configuration, TemporaryMutableDataCleanerEnvironment environment, DataCleanerConfiguration temporaryConfiguration) {
        ArrayList<DescriptorProvider> providers = new ArrayList<DescriptorProvider>();
        DescriptorProvidersType providersElement = configuration.getDescriptorProviders();
        if (providersElement == null) {
            providersElement = new DescriptorProvidersType();
        }
        if (configuration.getClasspathScanner() != null) {
            providersElement.getCustomClassOrClasspathScannerOrRemoteComponents().add(configuration.getClasspathScanner());
        }
        if (configuration.getCustomDescriptorProvider() != null) {
            providersElement.getCustomClassOrClasspathScannerOrRemoteComponents().add(configuration.getCustomDescriptorProvider());
        }
        List<RemoteServerData> remoteServerDataList = this.readAllRemoteServers(providersElement);
        environment.setRemoteServerConfiguration((RemoteServerConfiguration)new RemoteServerConfigurationImpl(remoteServerDataList, environment.getTaskRunner()));
        for (Object object : providersElement.getCustomClassOrClasspathScannerOrRemoteComponents()) {
            this.createDescriptorProvider(object, environment, temporaryConfiguration, providers);
        }
        this.createRemoteDescriptorProviders(environment, providers, remoteServerDataList);
        if (providers.isEmpty()) {
            if (!(environment.getDescriptorProvider() instanceof CompositeDescriptorProvider)) {
                CompositeDescriptorProvider compositeDescriptorProvider = new CompositeDescriptorProvider();
                compositeDescriptorProvider.addDelegate(environment.getDescriptorProvider());
                environment.setDescriptorProvider((DescriptorProvider)compositeDescriptorProvider);
            }
            return;
        }
        boolean foundNonRemote = false;
        for (DescriptorProvider provider : providers) {
            if (provider instanceof RemoteDescriptorProvider) continue;
            foundNonRemote = true;
            break;
        }
        if (!foundNonRemote) {
            providers.add(0, environment.getDescriptorProvider());
        }
        CompositeDescriptorProvider compositeDescriptorProvider = new CompositeDescriptorProvider();
        compositeDescriptorProvider.addDelegates(providers);
        environment.setDescriptorProvider((DescriptorProvider)compositeDescriptorProvider);
    }

    private void createDescriptorProvider(Object providerElement, DataCleanerEnvironment environment, DataCleanerConfiguration temporaryConfiguration, List<DescriptorProvider> providerList) {
        if (providerElement instanceof CustomElementType) {
            providerList.add(this.createCustomElement((CustomElementType)providerElement, DescriptorProvider.class, temporaryConfiguration, true));
        } else if (providerElement instanceof ClasspathScannerType) {
            ClasspathScanDescriptorProvider classPathProvider = this.createClasspathScanDescriptorProvider((ClasspathScannerType)providerElement, environment);
            providerList.add((DescriptorProvider)classPathProvider);
        } else if (!(providerElement instanceof RemoteComponentsType)) {
            throw new IllegalStateException("Unsupported descriptor provider type: " + providerElement.getClass());
        }
    }

    private void createRemoteDescriptorProviders(DataCleanerEnvironment environment, List<DescriptorProvider> providerList, List<RemoteServerData> remoteServerDataList) {
        for (RemoteServerData remoteServerData : remoteServerDataList) {
            providerList.add((DescriptorProvider)new RemoteDescriptorProviderImpl(remoteServerData, environment.getRemoteServerConfiguration()));
        }
    }

    private List<RemoteServerData> readAllRemoteServers(DescriptorProvidersType providersElement) {
        ArrayList<RemoteServerData> remoteServerDataList = new ArrayList<RemoteServerData>();
        for (Object provider : providersElement.getCustomClassOrClasspathScannerOrRemoteComponents()) {
            if (!(provider instanceof RemoteComponentsType)) continue;
            int i = 0;
            for (RemoteComponentServerType server : ((RemoteComponentsType)provider).getServer()) {
                String serverName = server.getName() == null ? "server" + ++i : server.getName();
                String serverUrl = server.getUrl();
                if (StringUtils.isNullOrEmpty((String)serverUrl) && serverName.equals("DataCloud")) {
                    serverUrl = "https://services.datacleaner.org";
                }
                RemoteServerDataImpl remoteServerData = new RemoteServerDataImpl(serverUrl, serverName, server.getUsername(), SecurityUtils.decodePasswordWithPrefix((String)server.getPassword()));
                remoteServerDataList.add((RemoteServerData)remoteServerData);
            }
        }
        return remoteServerDataList;
    }

    private ClasspathScanDescriptorProvider createClasspathScanDescriptorProvider(ClasspathScannerType classpathScannerElement, DataCleanerEnvironment environment) {
        HashSet<Class> excludedRenderingFormats = new HashSet<Class>();
        for (String excludedRenderingFormat : classpathScannerElement.getExcludedRenderingFormat()) {
            try {
                Class cls = this._interceptor.loadClass(excludedRenderingFormat);
                excludedRenderingFormats.add(cls);
            }
            catch (ClassNotFoundException e) {
                logger.error("Could not find excluded rendering format class: " + excludedRenderingFormat, (Throwable)e);
            }
        }
        ClasspathScanDescriptorProvider classpathScanner = new ClasspathScanDescriptorProvider(environment.getTaskRunner(), excludedRenderingFormats);
        for (ClasspathScannerType.Package pkg : classpathScannerElement.getPackage()) {
            String packageName = pkg.getValue();
            if (packageName == null) continue;
            packageName = packageName.trim();
            Boolean recursive = pkg.isRecursive();
            if (recursive == null) {
                recursive = true;
            }
            classpathScanner.scanPackage(packageName, recursive.booleanValue());
        }
        return classpathScanner;
    }

    private void updateStorageProviderIfSpecified(Configuration configuration, TemporaryMutableDataCleanerEnvironment environment, DataCleanerConfiguration temporaryConfiguration) {
        StorageProviderType storageProviderType = configuration.getStorageProvider();
        if (storageProviderType == null) {
            return;
        }
        StorageProvider storageProvider = this.createStorageProvider(storageProviderType, environment, temporaryConfiguration);
        environment.setStorageProvider(storageProvider);
    }

    private StorageProvider createStorageProvider(StorageProviderType storageProviderType, DataCleanerEnvironment environment, DataCleanerConfiguration temporaryConfiguration) {
        CombinedStorageProviderType combinedStorageProvider = storageProviderType.getCombined();
        if (combinedStorageProvider != null) {
            StorageProviderType collectionsStorage = combinedStorageProvider.getCollectionsStorage();
            StorageProviderType rowAnnotationStorage = combinedStorageProvider.getRowAnnotationStorage();
            StorageProvider collectionsStorageProvider = this.createStorageProvider(collectionsStorage, environment, temporaryConfiguration);
            StorageProvider rowAnnotationStorageProvider = this.createStorageProvider(rowAnnotationStorage, environment, temporaryConfiguration);
            return new CombinedStorageProvider(collectionsStorageProvider, rowAnnotationStorageProvider);
        }
        InMemoryStorageProviderType inMemoryStorageProvider = storageProviderType.getInMemory();
        if (inMemoryStorageProvider != null) {
            int maxRowsThreshold = inMemoryStorageProvider.getMaxRowsThreshold();
            int maxSetsThreshold = inMemoryStorageProvider.getMaxSetsThreshold();
            return new InMemoryStorageProvider(maxSetsThreshold, maxRowsThreshold);
        }
        CustomElementType customStorageProvider = storageProviderType.getCustomStorageProvider();
        if (customStorageProvider != null) {
            return this.createCustomElement(customStorageProvider, StorageProvider.class, temporaryConfiguration, true);
        }
        BerkeleyDbStorageProviderType berkeleyDbStorageProvider = storageProviderType.getBerkeleyDb();
        if (berkeleyDbStorageProvider != null) {
            File parentDirectory = new File(this._interceptor.getTemporaryStorageDirectory());
            BerkeleyDbStorageProvider storageProvider = new BerkeleyDbStorageProvider(parentDirectory);
            Boolean cleanDirectoryOnStartup = berkeleyDbStorageProvider.isCleanDirectoryOnStartup();
            if (cleanDirectoryOnStartup != null && cleanDirectoryOnStartup.booleanValue()) {
                storageProvider.cleanDirectory();
            }
            return storageProvider;
        }
        return environment.getStorageProvider();
    }

    @Deprecated
    private String createFilename(String filename) {
        return this._interceptor.createFilename(filename);
    }

    private ReferenceDataCatalog createReferenceDataCatalog(ReferenceDataCatalogType referenceDataCatalog, DataCleanerEnvironment environment, DataCleanerConfiguration temporaryConfiguration) {
        ArrayList<Object> dictionaryList = new ArrayList<Object>();
        ArrayList<Object> synonymCatalogList = new ArrayList<Object>();
        ArrayList<Object> stringPatterns = new ArrayList<Object>();
        if (referenceDataCatalog != null) {
            ReferenceDataCatalogType.StringPatterns stringPatternTypes;
            ReferenceDataCatalogType.SynonymCatalogs synonymCatalogs;
            ReferenceDataCatalogType.Dictionaries dictionaries = referenceDataCatalog.getDictionaries();
            if (dictionaries != null) {
                for (Object dictionaryType : dictionaries.getTextFileDictionaryOrValueListDictionaryOrDatastoreDictionary()) {
                    String name;
                    if (dictionaryType instanceof DatastoreDictionaryType) {
                        DatastoreDictionaryType datastoreDictionaryType = (DatastoreDictionaryType)dictionaryType;
                        name = datastoreDictionaryType.getName();
                        JaxbConfigurationReader.checkName(name, Dictionary.class, dictionaryList);
                        this.addVariablePath(name);
                        String dsName = this.getStringVariable("datastoreName", datastoreDictionaryType.getDatastoreName());
                        String columnPath = this.getStringVariable("columnPath", datastoreDictionaryType.getColumnPath());
                        boolean loadIntoMemory = this.getBooleanVariable("loadIntoMemory", datastoreDictionaryType.isLoadIntoMemory(), true);
                        DatastoreDictionary dict = new DatastoreDictionary(name, dsName, columnPath, loadIntoMemory);
                        dict.setDescription(datastoreDictionaryType.getDescription());
                        dictionaryList.add(dict);
                        this.removeVariablePath();
                        continue;
                    }
                    if (dictionaryType instanceof TextFileDictionaryType) {
                        TextFileDictionaryType textFileDictionaryType = (TextFileDictionaryType)dictionaryType;
                        name = textFileDictionaryType.getName();
                        JaxbConfigurationReader.checkName(name, Dictionary.class, dictionaryList);
                        this.addVariablePath(name);
                        String filenamePath = this.getStringVariable("filename", textFileDictionaryType.getFilename());
                        String filename = this.createFilename(filenamePath);
                        String encoding = this.getStringVariable("encoding", textFileDictionaryType.getEncoding());
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        boolean caseSensitive = this.getBooleanVariable("caseSensitive", textFileDictionaryType.isCaseSensitive(), true);
                        TextFileDictionary dict = new TextFileDictionary(name, filename, encoding, caseSensitive);
                        dict.setDescription(textFileDictionaryType.getDescription());
                        dictionaryList.add(dict);
                        this.removeVariablePath();
                        continue;
                    }
                    if (dictionaryType instanceof ValueListDictionaryType) {
                        ValueListDictionaryType valueListDictionaryType = (ValueListDictionaryType)dictionaryType;
                        name = valueListDictionaryType.getName();
                        JaxbConfigurationReader.checkName(name, Dictionary.class, dictionaryList);
                        List<String> values = valueListDictionaryType.getValue();
                        boolean caseSensitive = this.getBooleanVariable("caseSensitive", valueListDictionaryType.isCaseSensitive(), true);
                        SimpleDictionary dict = new SimpleDictionary(name, values, caseSensitive);
                        dict.setDescription(valueListDictionaryType.getDescription());
                        dictionaryList.add(dict);
                        continue;
                    }
                    if (dictionaryType instanceof CustomElementType) {
                        Dictionary dictionary = this.createCustomElement((CustomElementType)dictionaryType, Dictionary.class, temporaryConfiguration, false);
                        JaxbConfigurationReader.checkName(dictionary.getName(), Dictionary.class, dictionaryList);
                        dictionaryList.add(dictionary);
                        continue;
                    }
                    throw new IllegalStateException("Unsupported dictionary type: " + dictionaryType);
                }
            }
            if ((synonymCatalogs = referenceDataCatalog.getSynonymCatalogs()) != null) {
                for (Object e : synonymCatalogs.getTextFileSynonymCatalogOrDatastoreSynonymCatalogOrCustomSynonymCatalog()) {
                    TextFileSynonymCatalog sc;
                    String name;
                    if (e instanceof TextFileSynonymCatalogType) {
                        TextFileSynonymCatalogType tfsct = (TextFileSynonymCatalogType)e;
                        name = tfsct.getName();
                        JaxbConfigurationReader.checkName(name, SynonymCatalog.class, synonymCatalogList);
                        this.addVariablePath(name);
                        String filenamePath = this.getStringVariable("filename", tfsct.getFilename());
                        String filename = this.createFilename(filenamePath);
                        String encoding = this.getStringVariable("encoding", tfsct.getEncoding());
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        boolean caseSensitive = this.getBooleanVariable("caseSensitive", tfsct.isCaseSensitive(), true);
                        sc = new TextFileSynonymCatalog(name, filename, caseSensitive, encoding);
                        sc.setDescription(tfsct.getDescription());
                        synonymCatalogList.add(sc);
                        this.removeVariablePath();
                        continue;
                    }
                    if (e instanceof CustomElementType) {
                        SynonymCatalog customSynonymCatalog = this.createCustomElement((CustomElementType)e, SynonymCatalog.class, temporaryConfiguration, false);
                        JaxbConfigurationReader.checkName(customSynonymCatalog.getName(), SynonymCatalog.class, synonymCatalogList);
                        synonymCatalogList.add(customSynonymCatalog);
                        continue;
                    }
                    if (e instanceof DatastoreSynonymCatalogType) {
                        DatastoreSynonymCatalogType datastoreSynonymCatalogType = (DatastoreSynonymCatalogType)e;
                        name = datastoreSynonymCatalogType.getName();
                        JaxbConfigurationReader.checkName(name, SynonymCatalog.class, synonymCatalogList);
                        this.addVariablePath(name);
                        String dataStoreName = this.getStringVariable("datastoreName", datastoreSynonymCatalogType.getDatastoreName());
                        String masterTermColumnPath = this.getStringVariable("masterTermColumnPath", datastoreSynonymCatalogType.getMasterTermColumnPath());
                        boolean loadIntoMemory = this.getBooleanVariable("loadIntoMemory", datastoreSynonymCatalogType.isLoadIntoMemory(), true);
                        String[] synonymColumnPaths = datastoreSynonymCatalogType.getSynonymColumnPath().toArray(new String[0]);
                        sc = new DatastoreSynonymCatalog(name, dataStoreName, masterTermColumnPath, synonymColumnPaths, loadIntoMemory);
                        sc.setDescription(datastoreSynonymCatalogType.getDescription());
                        synonymCatalogList.add(sc);
                        this.removeVariablePath();
                        continue;
                    }
                    throw new IllegalStateException("Unsupported synonym catalog type: " + e);
                }
            }
            if ((stringPatternTypes = referenceDataCatalog.getStringPatterns()) != null) {
                for (Object obj : stringPatternTypes.getRegexPatternOrRegexSwapPatternOrSimplePattern()) {
                    String expression;
                    String name;
                    if (obj instanceof RegexPatternType) {
                        RegexPatternType regexPatternType = (RegexPatternType)obj;
                        name = regexPatternType.getName();
                        JaxbConfigurationReader.checkName(name, StringPattern.class, stringPatterns);
                        this.addVariablePath(name);
                        expression = this.getStringVariable("expression", regexPatternType.getExpression());
                        boolean matchEntireString = this.getBooleanVariable("matchEntireString", regexPatternType.isMatchEntireString(), true);
                        RegexStringPattern sp = new RegexStringPattern(name, expression, matchEntireString);
                        sp.setDescription(regexPatternType.getDescription());
                        stringPatterns.add(sp);
                        this.removeVariablePath();
                        continue;
                    }
                    if (obj instanceof RegexSwapPatternType) {
                        RegexSwapPatternType regexSwapPatternType = (RegexSwapPatternType)obj;
                        name = regexSwapPatternType.getName();
                        JaxbConfigurationReader.checkName(name, StringPattern.class, stringPatterns);
                        String categories = this.getStringVariable("categories", regexSwapPatternType.getCategories());
                        ArrayList<Category> categoryList = new ArrayList<Category>();
                        for (RegexStringPattern categoryName : categories.split(",")) {
                            categoryList.add(new Category((String)categoryName, "", ""));
                        }
                        this.addVariablePath(name);
                        Regex regex = new Regex(this.getStringVariable("name", regexSwapPatternType.getName()), this.getStringVariable("description", regexSwapPatternType.getDescription()), this.getStringVariable("expression", regexSwapPatternType.getExpression()), this.getStringVariable("author", regexSwapPatternType.getAuthor()), this.getLongVariable("timestamp", regexSwapPatternType.getTimestamp()).longValue(), this.getIntegerVariable("positiveVotes", regexSwapPatternType.getPositiveVotes()).intValue(), this.getIntegerVariable("negativeVotes", regexSwapPatternType.getNegativeVotes()).intValue(), this.getStringVariable("detailsUrl", regexSwapPatternType.getDetailsUrl()), categoryList);
                        RegexSwapStringPattern sp = new RegexSwapStringPattern(regex);
                        stringPatterns.add(sp);
                        this.removeVariablePath();
                        continue;
                    }
                    if (obj instanceof SimplePatternType) {
                        SimplePatternType simplePatternType = (SimplePatternType)obj;
                        name = simplePatternType.getName();
                        JaxbConfigurationReader.checkName(name, StringPattern.class, stringPatterns);
                        this.addVariablePath(name);
                        expression = this.getStringVariable("expression", simplePatternType.getExpression());
                        SimpleStringPattern sp = new SimpleStringPattern(name, expression);
                        sp.setDescription(simplePatternType.getDescription());
                        stringPatterns.add(sp);
                        this.removeVariablePath();
                        continue;
                    }
                    throw new IllegalStateException("Unsupported string pattern type: " + obj);
                }
            }
        }
        return new ReferenceDataCatalogImpl(dictionaryList, synonymCatalogList, stringPatterns);
    }

    private DatastoreCatalog createDatastoreCatalog(DatastoreCatalogType datastoreCatalogType, DataCleanerConfigurationImpl temporaryConfiguration, DataCleanerEnvironment environment) {
        String name;
        Datastore ds;
        if (datastoreCatalogType == null) {
            return temporaryConfiguration.getDatastoreCatalog();
        }
        HashMap<String, Object> datastores = new HashMap<String, Object>();
        List<AbstractDatastoreType> datastoreTypes = datastoreCatalogType.getJdbcDatastoreOrAccessDatastoreOrCsvDatastore();
        for (AbstractDatastoreType abstractDatastoreType : datastoreTypes) {
            String name2 = abstractDatastoreType.getName();
            JaxbConfigurationReader.checkName(name2, Datastore.class, datastores);
            this.addVariablePath(name2);
            if (abstractDatastoreType instanceof CsvDatastoreType) {
                ds = this.createDatastore(name2, (CsvDatastoreType)abstractDatastoreType, (DataCleanerConfiguration)temporaryConfiguration);
            } else if (abstractDatastoreType instanceof JdbcDatastoreType) {
                ds = this.createDatastore(name2, (JdbcDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof FixedWidthDatastoreType) {
                ds = this.createDatastore(name2, (FixedWidthDatastoreType)abstractDatastoreType, (DataCleanerConfiguration)temporaryConfiguration);
            } else if (abstractDatastoreType instanceof SasDatastoreType) {
                ds = this.createDatastore(name2, (SasDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof AccessDatastoreType) {
                ds = this.createDatastore(name2, (AccessDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof XmlDatastoreType) {
                ds = this.createDatastore(name2, (XmlDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof ExcelDatastoreType) {
                ds = this.createDatastore(name2, (ExcelDatastoreType)abstractDatastoreType, (DataCleanerConfiguration)temporaryConfiguration);
            } else if (abstractDatastoreType instanceof JsonDatastoreType) {
                ds = this.createDatastore(name2, (JsonDatastoreType)abstractDatastoreType, (DataCleanerConfiguration)temporaryConfiguration);
            } else if (abstractDatastoreType instanceof DbaseDatastoreType) {
                ds = this.createDatastore(name2, (DbaseDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof OpenOfficeDatabaseDatastoreType) {
                ds = this.createDatastore(name2, (OpenOfficeDatabaseDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof PojoDatastoreType) {
                ds = this.createDatastore(name2, (PojoDatastoreType)abstractDatastoreType, temporaryConfiguration);
            } else if (abstractDatastoreType instanceof CouchdbDatastoreType) {
                ds = this.createDatastore(name2, (CouchdbDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof MongodbDatastoreType) {
                ds = this.createDatastore(name2, (MongodbDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof ElasticSearchDatastoreType) {
                ds = this.createDatastore(name2, (ElasticSearchDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof CassandraDatastoreType) {
                ds = this.createDatastore(name2, (CassandraDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof HbaseDatastoreType) {
                ds = this.createDatastore(name2, (HbaseDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof SalesforceDatastoreType) {
                ds = this.createDatastore(name2, (SalesforceDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof SugarCrmDatastoreType) {
                ds = this.createDatastore(name2, (SugarCrmDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof DatahubDatastoreType) {
                ds = this.createDatastore(name2, (DatahubDatastoreType)abstractDatastoreType);
            } else if (abstractDatastoreType instanceof Neo4JDatastoreType) {
                ds = this.createDatastore(name2, (Neo4JDatastoreType)abstractDatastoreType);
            } else {
                if (abstractDatastoreType instanceof CompositeDatastoreType) continue;
                throw new UnsupportedOperationException("Unsupported datastore type: " + abstractDatastoreType);
            }
            String datastoreDescription = abstractDatastoreType.getDescription();
            ds.setDescription(datastoreDescription);
            this.removeVariablePath();
            datastores.put(name2, ds);
        }
        List<CustomElementType> customDatastores = datastoreCatalogType.getCustomDatastore();
        for (CustomElementType customElementType : customDatastores) {
            ds = this.createCustomElement(customElementType, Datastore.class, (DataCleanerConfiguration)temporaryConfiguration, true);
            name = ds.getName();
            JaxbConfigurationReader.checkName(name, Datastore.class, datastores);
            datastores.put(name, ds);
        }
        List list = CollectionUtils2.filterOnClass(datastoreTypes, CompositeDatastoreType.class);
        for (CompositeDatastoreType compositeDatastoreType : list) {
            name = compositeDatastoreType.getName();
            JaxbConfigurationReader.checkName(name, Datastore.class, datastores);
            List<String> datastoreNames = compositeDatastoreType.getDatastoreName();
            ArrayList<Datastore> childDatastores = new ArrayList<Datastore>(datastoreNames.size());
            for (String datastoreName : datastoreNames) {
                Datastore datastore = (Datastore)datastores.get(datastoreName);
                if (datastore == null) {
                    throw new IllegalStateException("No such datastore: " + datastoreName + " (found in composite datastore: " + name + ")");
                }
                childDatastores.add(datastore);
            }
            CompositeDatastore ds2 = new CompositeDatastore(name, childDatastores);
            ds2.setDescription(compositeDatastoreType.getDescription());
            datastores.put(name, ds2);
        }
        return new DatastoreCatalogImpl(datastores.values());
    }

    private ServerInformationCatalog createServerInformationCatalog(ServersType serversType, DataCleanerConfigurationImpl temporaryConfiguration, TemporaryMutableDataCleanerEnvironment temporaryEnvironment) {
        if (serversType == null) {
            return temporaryConfiguration.getServerInformationCatalog();
        }
        HashMap<String, Object> servers = new HashMap<String, Object>();
        List<HadoopClusterType> hadoopClusterTypes = serversType.getHadoopClusters().getHadoopCluster();
        for (HadoopClusterType hadoopClusterType : hadoopClusterTypes) {
            String name = hadoopClusterType.getName();
            JaxbConfigurationReader.checkName(name, ServerInformation.class, servers);
            String description = hadoopClusterType.getDescription();
            ServerInformation serverInformation = this.createHadoopClusterInformation(hadoopClusterType, name, description);
            servers.put(name, serverInformation);
        }
        try {
            servers.put("org.datacleaner.hadoop.environment", new EnvironmentBasedHadoopClusterInformation("org.datacleaner.hadoop.environment", null));
        }
        catch (IllegalStateException e) {
            logger.info("No Hadoop environment variables, skipping default server");
        }
        return new ServerInformationCatalogImpl(servers.values());
    }

    private ServerInformation createHadoopClusterInformation(HadoopClusterType hadoopClusterType, String name, String description) {
        EnvironmentBasedHadoopClusterInformation serverInformation;
        if (hadoopClusterType.getEnvironmentConfigured() != null) {
            serverInformation = new EnvironmentBasedHadoopClusterInformation(name, description);
        } else if (hadoopClusterType.getDirectories() != null) {
            List<String> directoryList = hadoopClusterType.getDirectories().getDirectory();
            String[] directories = directoryList.toArray(new String[directoryList.size()]);
            serverInformation = new DirectoryBasedHadoopClusterInformation(name, description, directories);
        } else if (hadoopClusterType.getNamenodeUrl() != null) {
            serverInformation = new DirectConnectionHadoopClusterInformation(name, description, URI.create(hadoopClusterType.getNamenodeUrl()));
        } else {
            throw new UnsupportedOperationException("Unsupported hadoop cluster configuration method");
        }
        return serverInformation;
    }

    private Datastore createDatastore(String name, Neo4JDatastoreType datastoreType) {
        String hostname = this.getStringVariable("hostname", datastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", datastoreType.getPort());
        if (port == null) {
            port = 7474;
        }
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getPasswordVariable("password", datastoreType.getPassword());
        return new Neo4jDatastore(name, hostname, port.intValue(), username, password);
    }

    private Datastore createDatastore(String name, CassandraDatastoreType datastoreType) {
        SimpleTableDef[] tableDefs;
        String hostname = this.getStringVariable("hostname", datastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", datastoreType.getPort());
        if (port == null) {
            port = 9042;
        }
        String keySpace = this.getStringVariable("keyspace", datastoreType.getKeyspace());
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getPasswordVariable("password", datastoreType.getPassword());
        boolean ssl = this.getBooleanVariable("ssl", datastoreType.isSsl(), false);
        List<CassandraDatastoreType.TableDef> tableDefList = datastoreType.getTableDef();
        if (tableDefList == null || tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                CassandraDatastoreType.TableDef tableDef = tableDefList.get(i);
                String tableName = tableDef.getTableName();
                List<CassandraDatastoreType.TableDef.Column> columnList = tableDef.getColumn();
                String[] columnNames = new String[columnList.size()];
                ColumnType[] columnTypes = new ColumnType[columnList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = columnList.get(j).getName();
                    String propertyTypeName = columnList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    columnNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(tableName, columnNames, columnTypes);
            }
        }
        return new CassandraDatastore(name, hostname, port.intValue(), keySpace, username, password, ssl, tableDefs);
    }

    private Datastore createDatastore(String name, ElasticSearchDatastoreType datastoreType) {
        SimpleTableDef[] tableDefs;
        List<ElasticSearchDatastoreType.TableDef> tableDefList;
        String clusterName = this.getStringVariable("clusterName", datastoreType.getClusterName());
        String hostname = this.getStringVariable("hostname", datastoreType.getHostname());
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getPasswordVariable("password", datastoreType.getPassword());
        boolean ssl = this.getBooleanVariable("ssl", datastoreType.isSsl(), false);
        String keystorePath = this.getStringVariable("keystorePath", datastoreType.getKeystorePath());
        String keystorePassword = this.getPasswordVariable("keystorePassword", datastoreType.getKeystorePassword());
        Integer port = this.getIntegerVariable("port", datastoreType.getPort());
        String indexName = this.getStringVariable("indexName", datastoreType.getIndexName());
        String clientType = this.getStringVariable("clientType", datastoreType.getClientType());
        if (clientType == null) {
            clientType = ElasticSearchDatastore.ClientType.TRANSPORT.name();
            if (port == null) {
                port = 9300;
            }
        }
        if (port == null) {
            port = 9200;
        }
        if ((tableDefList = datastoreType.getTableDef()).isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                ElasticSearchDatastoreType.TableDef tableDef = tableDefList.get(i);
                String docType = tableDef.getDocumentType();
                List<ElasticSearchDatastoreType.TableDef.Field> fieldList = tableDef.getField();
                String[] columnNames = new String[fieldList.size()];
                ColumnType[] columnTypes = new ColumnType[fieldList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = fieldList.get(j).getName();
                    String propertyTypeName = fieldList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    columnNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(docType, columnNames, columnTypes);
            }
        }
        return new ElasticSearchDatastore(name, ElasticSearchDatastore.ClientType.valueOf((String)clientType), hostname, port, clusterName, indexName, tableDefs, username, password, ssl, keystorePath, keystorePassword);
    }

    private Datastore createDatastore(String name, JsonDatastoreType datastoreType, DataCleanerConfiguration configuration) {
        String filename = this.getStringVariable("filename", datastoreType.getFilename());
        Resource resource = this._interceptor.createResource(filename, configuration);
        return new JsonDatastore(name, resource);
    }

    private Datastore createDatastore(String name, HbaseDatastoreType datastoreType) {
        SimpleTableDef[] tableDefs;
        String zookeeperHostname = this.getStringVariable("zookeeperHostname", datastoreType.getZookeeperHostname());
        int zookeeperPort = this.getIntegerVariable("zookeeperPort", datastoreType.getZookeeperPort());
        List<HbaseDatastoreType.TableDef> tableDefList = datastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                HbaseDatastoreType.TableDef tableDef = tableDefList.get(i);
                String tableName = tableDef.getName();
                List<HbaseDatastoreType.TableDef.Column> columnList = tableDef.getColumn();
                String[] columnNames = new String[columnList.size()];
                ColumnType[] columnTypes = new ColumnType[columnList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    HbaseDatastoreType.TableDef.Column column = columnList.get(j);
                    String family = column.getFamily();
                    String columnName = Strings.isNullOrEmpty((String)family) ? column.getName() : family + ":" + column.getName();
                    String columnTypeName = column.getType();
                    ColumnType columnType = StringUtils.isNullOrEmpty((String)columnTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)columnTypeName);
                    columnNames[j] = columnName;
                    columnTypes[j] = columnType;
                }
                tableDefs[i] = new SimpleTableDef(tableName, columnNames, columnTypes);
            }
        }
        return new HBaseDatastore(name, zookeeperHostname, zookeeperPort, tableDefs);
    }

    private Datastore createDatastore(String name, SalesforceDatastoreType datastoreType) {
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getPasswordVariable("password", datastoreType.getPassword());
        String securityToken = this.getStringVariable("securityToken", datastoreType.getSecurityToken());
        String endpointUrl = this.getStringVariable("endpointUrl", datastoreType.getEndpointUrl());
        return new SalesforceDatastore(name, username, password, securityToken, endpointUrl);
    }

    private Datastore createDatastore(String name, SugarCrmDatastoreType datastoreType) {
        String baseUrl = this.getStringVariable("baseUrl", datastoreType.getBaseUrl());
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getPasswordVariable("password", datastoreType.getPassword());
        return new SugarCrmDatastore(name, baseUrl, username, password);
    }

    private Datastore createDatastore(String name, DatahubDatastoreType datastoreType) {
        String host = this.getStringVariable("host", datastoreType.getHost());
        Integer port = this.getIntegerVariable("port", datastoreType.getPort());
        String username = this.getStringVariable("username", datastoreType.getUsername());
        String password = this.getPasswordVariable("password", datastoreType.getPassword());
        boolean https = this.getBooleanVariable("https", datastoreType.isHttps(), true);
        boolean acceptUnverifiedSslPeers = this.getBooleanVariable("acceptunverifiedsslpeers", datastoreType.isAcceptunverifiedsslpeers(), false);
        DatahubsecuritymodeEnum jaxbDatahubsecuritymode = datastoreType.getDatahubsecuritymode();
        DataHubSecurityMode dataHubSecurityMode = DataHubSecurityMode.valueOf((String)jaxbDatahubsecuritymode.value());
        return new DataHubDatastore(name, host, port, username, password, https, acceptUnverifiedSslPeers, dataHubSecurityMode);
    }

    private Datastore createDatastore(String name, MongodbDatastoreType mongodbDatastoreType) {
        SimpleTableDef[] tableDefs;
        String hostname = this.getStringVariable("hostname", mongodbDatastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", mongodbDatastoreType.getPort());
        String databaseName = this.getStringVariable("databaseName", mongodbDatastoreType.getDatabaseName());
        String username = this.getStringVariable("username", mongodbDatastoreType.getUsername());
        String password = this.getPasswordVariable("password", mongodbDatastoreType.getPassword());
        List<MongodbDatastoreType.TableDef> tableDefList = mongodbDatastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                MongodbDatastoreType.TableDef tableDef = tableDefList.get(i);
                String collectionName = tableDef.getCollection();
                List<MongodbDatastoreType.TableDef.Property> propertyList = tableDef.getProperty();
                String[] propertyNames = new String[propertyList.size()];
                ColumnType[] columnTypes = new ColumnType[propertyList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = propertyList.get(j).getName();
                    String propertyTypeName = propertyList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    propertyNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(collectionName, propertyNames, columnTypes);
            }
        }
        return new MongoDbDatastore(name, hostname, port, databaseName, username, password, tableDefs);
    }

    private Datastore createDatastore(String name, CouchdbDatastoreType couchdbDatastoreType) {
        SimpleTableDef[] tableDefs;
        String hostname = this.getStringVariable("hostname", couchdbDatastoreType.getHostname());
        Integer port = this.getIntegerVariable("port", couchdbDatastoreType.getPort());
        String username = this.getStringVariable("username", couchdbDatastoreType.getUsername());
        String password = this.getPasswordVariable("password", couchdbDatastoreType.getPassword());
        boolean sslEnabled = this.getBooleanVariable("ssl", couchdbDatastoreType.isSsl(), false);
        List<CouchdbDatastoreType.TableDef> tableDefList = couchdbDatastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new SimpleTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                CouchdbDatastoreType.TableDef tableDef = tableDefList.get(i);
                String databaseName = tableDef.getDatabase();
                List<CouchdbDatastoreType.TableDef.Field> fieldList = tableDef.getField();
                String[] propertyNames = new String[fieldList.size()];
                ColumnType[] columnTypes = new ColumnType[fieldList.size()];
                for (int j = 0; j < columnTypes.length; ++j) {
                    String propertyName = fieldList.get(j).getName();
                    String propertyTypeName = fieldList.get(j).getType();
                    ColumnType propertyType = StringUtils.isNullOrEmpty((String)propertyTypeName) ? ColumnType.STRING : ColumnTypeImpl.valueOf((String)propertyTypeName);
                    propertyNames[j] = propertyName;
                    columnTypes[j] = propertyType;
                }
                tableDefs[i] = new SimpleTableDef(databaseName, propertyNames, columnTypes);
            }
        }
        return new CouchDbDatastore(name, hostname, port, username, password, sslEnabled, tableDefs);
    }

    private Datastore createDatastore(String name, PojoDatastoreType pojoDatastore, DataCleanerConfigurationImpl temporaryConfiguration) {
        JaxbPojoDatastoreAdaptor adaptor = new JaxbPojoDatastoreAdaptor((DataCleanerConfiguration)temporaryConfiguration);
        return adaptor.read(pojoDatastore);
    }

    private Datastore createDatastore(String name, OpenOfficeDatabaseDatastoreType odbDatastoreType) {
        String filenamePath = this.getStringVariable("filename", odbDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        return new OdbDatastore(name, filename);
    }

    private Datastore createDatastore(String name, DbaseDatastoreType dbaseDatastoreType) {
        String filenamePath = this.getStringVariable("filename", dbaseDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        return new DbaseDatastore(name, filename);
    }

    private Datastore createDatastore(String name, ExcelDatastoreType excelDatastoreType, DataCleanerConfiguration configuration) {
        String filename = this.getStringVariable("filename", excelDatastoreType.getFilename());
        Resource resource = this._interceptor.createResource(filename, configuration);
        List<String> customColumnNames = null;
        if (excelDatastoreType.getCustomColumnNames() != null) {
            customColumnNames = excelDatastoreType.getCustomColumnNames().getColumnName();
        }
        return new ExcelDatastore(name, resource, filename, customColumnNames);
    }

    private Datastore createDatastore(String name, XmlDatastoreType xmlDatastoreType) {
        XmlSaxTableDef[] tableDefs;
        String filenamePath = this.getStringVariable("filename", xmlDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        List<XmlDatastoreType.TableDef> tableDefList = xmlDatastoreType.getTableDef();
        if (tableDefList.isEmpty()) {
            tableDefs = null;
        } else {
            tableDefs = new XmlSaxTableDef[tableDefList.size()];
            for (int i = 0; i < tableDefs.length; ++i) {
                String rowXpath = tableDefList.get(i).getRowXpath();
                String[] valueXpaths = tableDefList.get(i).getValueXpath().toArray(new String[0]);
                tableDefs[i] = new XmlSaxTableDef(rowXpath, valueXpaths);
            }
        }
        return new XmlDatastore(name, filename, tableDefs);
    }

    private Datastore createDatastore(String name, AccessDatastoreType accessDatastoreType) {
        String filenamePath = this.getStringVariable("filename", accessDatastoreType.getFilename());
        String filename = this.createFilename(filenamePath);
        return new AccessDatastore(name, filename);
    }

    private Datastore createDatastore(String name, SasDatastoreType sasDatastoreType) {
        String directoryPath = this.getStringVariable("directory", sasDatastoreType.getDirectory());
        File directory = new File(directoryPath);
        return new SasDatastore(name, directory);
    }

    private Datastore createDatastore(String name, FixedWidthDatastoreType fixedWidthDatastore, DataCleanerConfiguration configuration) {
        FixedWidthDatastore ds;
        FixedWidthDatastoreType.WidthSpecification widthSpecification;
        Integer fixedValueWidth;
        String filename = this.getStringVariable("filename", fixedWidthDatastore.getFilename());
        Resource resource = this._interceptor.createResource(filename, configuration);
        String encoding = this.getStringVariable("encoding", fixedWidthDatastore.getEncoding());
        if (!StringUtils.isNullOrEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        boolean failOnInconsistencies = this.getBooleanVariable("failOnInconsistencies", fixedWidthDatastore.isFailOnInconsistencies(), true);
        boolean skipEbcdicHeader = this.getBooleanVariable("skipEbcdicHeader", fixedWidthDatastore.isSkipEbcdicHeader(), false);
        boolean eolPresent = this.getBooleanVariable("eolPresent", fixedWidthDatastore.isEolPresent(), true);
        Integer headerLineNumber = this.getIntegerVariable("headerLineNumber", fixedWidthDatastore.getHeaderLineNumber());
        if (headerLineNumber == null) {
            headerLineNumber = 1;
        }
        if ((fixedValueWidth = this.getIntegerVariable("fixedValueWidth", (widthSpecification = fixedWidthDatastore.getWidthSpecification()).getFixedValueWidth())) == null) {
            List<Integer> valueWidthsBoxed = widthSpecification.getValueWidth();
            int[] valueWidths = new int[valueWidthsBoxed.size()];
            for (int i = 0; i < valueWidths.length; ++i) {
                valueWidths[i] = valueWidthsBoxed.get(i);
            }
            List<String> customColumnNames = null;
            if (fixedWidthDatastore.getCustomColumnNames() != null) {
                customColumnNames = fixedWidthDatastore.getCustomColumnNames().getColumnName();
            }
            ds = new FixedWidthDatastore(name, resource, filename, encoding, valueWidths, failOnInconsistencies, skipEbcdicHeader, eolPresent, headerLineNumber.intValue(), customColumnNames);
        } else {
            ds = new FixedWidthDatastore(name, resource, filename, encoding, fixedValueWidth.intValue(), failOnInconsistencies, skipEbcdicHeader, eolPresent, headerLineNumber.intValue());
        }
        return ds;
    }

    private Datastore createDatastore(String name, JdbcDatastoreType jdbcDatastoreType) {
        JdbcDatastore ds;
        TableType[] tableTypes;
        JdbcDatastoreType.TableTypes jaxbTableTypes = jdbcDatastoreType.getTableTypes();
        if (jaxbTableTypes == null) {
            tableTypes = null;
        } else {
            List<TableTypeEnum> jaxbTableTypeList = jaxbTableTypes.getTableType();
            tableTypes = new TableType[jaxbTableTypeList.size()];
            for (int i = 0; i < tableTypes.length; ++i) {
                TableTypeEnum tableTypeEnum = jaxbTableTypeList.get(i);
                tableTypes[i] = TableType.valueOf((String)tableTypeEnum.toString());
            }
        }
        String catalogName = this.getStringVariable("catalogName", jdbcDatastoreType.getCatalogName());
        String datasourceJndiUrl = this.getStringVariable("jndiUrl", jdbcDatastoreType.getDatasourceJndiUrl());
        if (datasourceJndiUrl == null) {
            String url = this.getStringVariable("url", jdbcDatastoreType.getUrl());
            String driver = this.getStringVariable("driver", jdbcDatastoreType.getDriver());
            String username = this.getStringVariable("username", jdbcDatastoreType.getUsername());
            String password = this.getPasswordVariable("password", jdbcDatastoreType.getPassword());
            boolean multipleConnections = this.getBooleanVariable("multipleConnections", jdbcDatastoreType.isMultipleConnections(), true);
            ds = new JdbcDatastore(name, url, driver, username, password, multipleConnections, tableTypes, catalogName);
        } else {
            ds = new JdbcDatastore(name, datasourceJndiUrl, tableTypes, catalogName);
        }
        return ds;
    }

    private Datastore createDatastore(String name, CsvDatastoreType csvDatastoreType, DataCleanerConfiguration configuration) {
        String filename = this.getStringVariable("filename", csvDatastoreType.getFilename());
        Resource resource = this._interceptor.createResource(filename, configuration);
        String quoteCharString = this.getStringVariable("quoteChar", csvDatastoreType.getQuoteChar());
        char quoteChar = this.getChar(quoteCharString, '\"', '\uffff');
        String separatorCharString = this.getStringVariable("separatorChar", csvDatastoreType.getSeparatorChar());
        char separatorChar = this.getChar(separatorCharString, ',', '\uffff');
        String escapeCharString = this.getStringVariable("escapeChar", csvDatastoreType.getEscapeChar());
        char escapeChar = this.getChar(escapeCharString, '\\', '\uffff');
        String encoding = this.getStringVariable("encoding", csvDatastoreType.getEncoding());
        if (StringUtils.isNullOrEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        boolean failOnInconsistencies = this.getBooleanVariable("failOnInconsistencies", csvDatastoreType.isFailOnInconsistencies(), true);
        boolean multilineValues = this.getBooleanVariable("multilineValues", csvDatastoreType.isMultilineValues(), true);
        Integer headerLineNumber = this.getIntegerVariable("headerLineNumber", csvDatastoreType.getHeaderLineNumber());
        if (headerLineNumber == null) {
            headerLineNumber = 1;
        }
        List<String> customColumnNames = null;
        if (csvDatastoreType.getCustomColumnNames() != null) {
            customColumnNames = csvDatastoreType.getCustomColumnNames().getColumnName();
        }
        return new CsvDatastore(name, resource, filename, Character.valueOf(quoteChar), Character.valueOf(separatorChar), Character.valueOf(escapeChar), encoding, failOnInconsistencies, multilineValues, headerLineNumber.intValue(), customColumnNames);
    }

    private char getChar(String charString, char ifNull, char ifBlank) {
        if (charString == null) {
            return ifNull;
        }
        if ("".equals(charString)) {
            return ifBlank;
        }
        if (charString.length() == 1) {
            return charString.charAt(0);
        }
        if ("\\t".equals(charString)) {
            return '\t';
        }
        if ("\\\n".equals(charString)) {
            return '\n';
        }
        if ("\\r".equals(charString)) {
            return '\r';
        }
        if ("\\\\".equals(charString)) {
            return '\\';
        }
        if ("NOT_A_CHAR".equals(charString)) {
            return '\uffff';
        }
        logger.warn("Char string contained more than 1 character and was not identified as a special char: '{}'", (Object)charString);
        return charString.charAt(0);
    }

    private void addVariablePath(String name) {
        name = StringUtils.toCamelCase((String)name);
        this._variablePathBuilder.add(name);
    }

    private void removeVariablePath() {
        this._variablePathBuilder.pollLast();
    }

    private String getStringVariable(String key, String valueIfNull) {
        StringBuilder sb = new StringBuilder();
        for (String keyElement : this._variablePathBuilder) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(keyElement);
        }
        sb.append('.');
        sb.append(key);
        String variablePath = sb.toString();
        String value = this._interceptor.getPropertyOverride(variablePath);
        if (value == null) {
            return valueIfNull;
        }
        logger.info("Overriding variable '{}' with value: {}", (Object)variablePath, (Object)value);
        return value;
    }

    private String getPasswordVariable(String key, String valueIfNull) {
        String possiblyEncodedPassword = this.getStringVariable(key, valueIfNull);
        if (possiblyEncodedPassword == null) {
            return null;
        }
        if (SecurityUtils.hasPrefix((String)possiblyEncodedPassword)) {
            return SecurityUtils.decodePasswordWithPrefix((String)possiblyEncodedPassword);
        }
        return possiblyEncodedPassword;
    }

    public Integer getIntegerVariable(String key, Integer valueIfNull) {
        String value = this.getStringVariable(key, null);
        if (value == null) {
            return valueIfNull;
        }
        return Integer.parseInt(value);
    }

    public Long getLongVariable(String key, Long valueIfNull) {
        String value = this.getStringVariable(key, null);
        if (value == null) {
            return valueIfNull;
        }
        return Long.parseLong(value);
    }

    private boolean getBooleanVariable(String key, Boolean valueIfNull, boolean valueIfNull2) {
        String value = this.getStringVariable(key, null);
        if (StringUtils.isNullOrEmpty((String)value)) {
            if (valueIfNull == null) {
                return valueIfNull2;
            }
            return valueIfNull;
        }
        return Boolean.parseBoolean(value);
    }

    private static void checkName(String name, Class<?> type, Map<String, ?> previousEntries) throws IllegalStateException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalStateException(type.getSimpleName() + " name cannot be null");
        }
        if (previousEntries.containsKey(name)) {
            throw new IllegalStateException(type.getSimpleName() + " name is not unique: " + name);
        }
    }

    private static void checkName(String name, Class<?> type, List<? extends ReferenceData> previousEntries) throws IllegalStateException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalStateException(type.getSimpleName() + " name cannot be null");
        }
        for (ReferenceData referenceData : previousEntries) {
            if (!name.equals(referenceData.getName())) continue;
            throw new IllegalStateException(type.getSimpleName() + " name is not unique: " + name);
        }
    }

    private void updateTaskRunnerIfSpecified(Configuration configuration, TemporaryMutableDataCleanerEnvironment environment, DataCleanerConfiguration temporaryConfiguration) {
        SinglethreadedTaskrunnerType singlethreadedTaskrunner = configuration.getSinglethreadedTaskrunner();
        MultithreadedTaskrunnerType multithreadedTaskrunner = configuration.getMultithreadedTaskrunner();
        CustomElementType customTaskrunner = configuration.getCustomTaskrunner();
        if (singlethreadedTaskrunner != null) {
            SingleThreadedTaskRunner taskRunner = new SingleThreadedTaskRunner();
            environment.setTaskRunner((TaskRunner)taskRunner);
        } else if (multithreadedTaskrunner != null) {
            Short maxThreads = multithreadedTaskrunner.getMaxThreads();
            MultiThreadedTaskRunner taskRunner = maxThreads != null ? new MultiThreadedTaskRunner(maxThreads.intValue()) : new MultiThreadedTaskRunner();
            environment.setTaskRunner((TaskRunner)taskRunner);
        } else if (customTaskrunner != null) {
            TaskRunner taskRunner = this.createCustomElement(customTaskrunner, TaskRunner.class, temporaryConfiguration, true);
            environment.setTaskRunner(taskRunner);
        }
    }

    private <E> E createCustomElement(CustomElementType customElementType, Class<E> expectedClazz, DataCleanerConfiguration configuration, boolean initialize) {
        InjectionManager injectionManager = configuration.getEnvironment().getInjectionManagerFactory().getInjectionManager(configuration);
        return this.createCustomElementInternal(customElementType, expectedClazz, injectionManager, initialize);
    }

    private <E> E createCustomElementInternal(CustomElementType customElementType, Class<E> expectedClazz, InjectionManager injectionManager, boolean initialize) {
        Class foundClass;
        String className = customElementType.getClassName();
        assert (className != null);
        try {
            foundClass = this._interceptor.loadClass(className);
        }
        catch (Exception e) {
            logger.error("Failed to load class: {}", (Object)className);
            throw new IllegalStateException(e);
        }
        if (!ReflectionUtils.is((Type)foundClass, expectedClazz)) {
            throw new IllegalStateException(className + " is not a valid " + expectedClazz);
        }
        Object result = ReflectionUtils.newInstance((Class)foundClass);
        ComponentDescriptor descriptor = Descriptors.ofComponent((Class)foundClass);
        StringConverter stringConverter = new StringConverter(injectionManager);
        List<CustomElementType.Property> propertyTypes = customElementType.getProperty();
        if (propertyTypes != null) {
            for (CustomElementType.Property property : propertyTypes) {
                String propertyName = property.getName();
                String propertyValue = property.getValue();
                ConfiguredPropertyDescriptor configuredProperty = descriptor.getConfiguredProperty(propertyName);
                if (configuredProperty == null) {
                    logger.warn("Missing configured property name: {}", (Object)propertyName);
                    if (logger.isInfoEnabled()) {
                        Set configuredProperties = descriptor.getConfiguredProperties();
                        for (ConfiguredPropertyDescriptor configuredPropertyDescriptor : configuredProperties) {
                            logger.info("Available configured property name: {}, {}", (Object)configuredPropertyDescriptor.getName(), (Object)configuredPropertyDescriptor.getType());
                        }
                    }
                    throw new IllegalStateException("No such property in " + foundClass.getName() + ": " + propertyName);
                }
                Object configuredValue = stringConverter.deserialize(propertyValue, configuredProperty.getType(), configuredProperty.createCustomConverter());
                configuredProperty.setValue(result, configuredValue);
            }
        }
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, true);
        lifeCycleHelper.assignProvidedProperties(descriptor, result);
        if (initialize) {
            lifeCycleHelper.initialize(descriptor, result);
        }
        return (E)result;
    }
}

