/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.csv.InconsistentRowLengthException;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.util.FileHelper;

final class CsvDataSet
extends AbstractDataSet {
    private final CSVReader _reader;
    private final SelectItem[] _selectItems;
    private final boolean _failOnInconsistentRowLength;
    private final int _columnsInTable;
    private volatile int _rowNumber;
    private volatile Integer _rowsRemaining;
    private volatile Row _row;

    public CsvDataSet(CSVReader reader, Column[] columns, Integer maxRows, int columnsInTable, boolean failOnInconsistentRowLength) {
        this._reader = reader;
        this._selectItems = new SelectItem[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            this._selectItems[i] = new SelectItem(column);
        }
        this._columnsInTable = columnsInTable;
        this._failOnInconsistentRowLength = failOnInconsistentRowLength;
        this._rowNumber = 0;
        this._rowsRemaining = maxRows;
    }

    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this._reader});
        this._row = null;
        this._rowsRemaining = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public Row getRow() throws MetaModelException {
        return this._row;
    }

    public SelectItem[] getSelectItems() {
        return this._selectItems;
    }

    public boolean next() {
        if (this._rowsRemaining != null && this._rowsRemaining > 0) {
            Integer n = this._rowsRemaining;
            Integer n2 = this._rowsRemaining = Integer.valueOf(this._rowsRemaining - 1);
            return this.nextInternal();
        }
        if (this._rowsRemaining == null) {
            return this.nextInternal();
        }
        return false;
    }

    private boolean nextInternal() {
        String[] csvValues;
        if (this._reader == null) {
            return false;
        }
        try {
            csvValues = this._reader.readNext();
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception reading from file", e);
        }
        if (csvValues == null) {
            this.close();
            return false;
        }
        Object[] rowValues = new Object[this._selectItems.length];
        for (int i = 0; i < this._selectItems.length; ++i) {
            Column column = this._selectItems[i].getColumn();
            int columnNumber = column.getColumnNumber();
            rowValues[i] = columnNumber < csvValues.length ? csvValues[columnNumber] : null;
        }
        this._row = new DefaultRow(this._selectItems, rowValues);
        if (this._failOnInconsistentRowLength) {
            ++this._rowNumber;
            if (this._columnsInTable != csvValues.length) {
                throw new InconsistentRowLengthException(this._columnsInTable, this._row, csvValues, this._rowNumber);
            }
        }
        return true;
    }
}

