/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvSchema;
import org.eobjects.metamodel.schema.AbstractTable;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.AlphabeticSequence;
import org.eobjects.metamodel.util.FileHelper;

final class CsvTable
extends AbstractTable {
    private final CsvSchema _schema;
    private Column[] _columns;

    public CsvTable(CsvSchema schema, String[] columnNames) {
        this(schema);
        this._columns = this.buildColumns(columnNames);
    }

    public CsvTable(CsvSchema schema) {
        this._schema = schema;
    }

    public String getName() {
        String schemaName = this._schema.getName();
        return schemaName.substring(0, schemaName.length() - 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns() {
        if (this._columns == null) {
            CsvTable csvTable = this;
            synchronized (csvTable) {
                if (this._columns == null) {
                    this._columns = this.buildColumns();
                }
            }
        }
        return this._columns;
    }

    private Column[] buildColumns() {
        Column[] columnArray;
        CSVReader reader = null;
        try {
            reader = this._schema.getDataContext().createCsvReader(0);
            int columnNameLineNumber = this._schema.getDataContext().getConfiguration().getColumnNameLineNumber();
            for (int i = 0; i < columnNameLineNumber; ++i) {
                reader.readNext();
            }
            String[] columnHeaders = reader.readNext();
            reader.close();
            columnArray = this.buildColumns(columnHeaders);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Exception reading from file: " + this._schema.getDataContext().getFile(), e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        return columnArray;
    }

    private Column[] buildColumns(String[] columnNames) {
        if (columnNames == null) {
            return new Column[0];
        }
        CsvConfiguration configuration = this._schema.getDataContext().getConfiguration();
        int columnNameLineNumber = configuration.getColumnNameLineNumber();
        boolean nullable = !configuration.isFailOnInconsistentRowLength();
        Column[] columns = new Column[columnNames.length];
        AlphabeticSequence sequence = new AlphabeticSequence();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNameLineNumber == -1 ? sequence.next() : columnNames[i];
            MutableColumn column = new MutableColumn(columnName, ColumnType.VARCHAR, (Table)this, i, null, null, Boolean.valueOf(nullable), null, false, null);
            columns[i] = column;
        }
        return columns;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableType getType() {
        return TableType.TABLE;
    }

    public Relationship[] getRelationships() {
        return new Relationship[0];
    }

    public String getRemarks() {
        return null;
    }

    public String getQuote() {
        return null;
    }
}

