/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvCreateTableBuilder;
import org.eobjects.metamodel.csv.CsvDataContext;
import org.eobjects.metamodel.csv.CsvDeleteBuilder;
import org.eobjects.metamodel.csv.CsvInsertBuilder;
import org.eobjects.metamodel.csv.CsvTable;
import org.eobjects.metamodel.csv.CsvTableDropBuilder;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CsvUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(CsvUpdateCallback.class);
    private final File _file;
    private final CsvConfiguration _configuration;
    private CSVWriter _csvWriter;

    public CsvUpdateCallback(CsvDataContext dataContext) {
        super((DataContext)dataContext);
        this._file = dataContext.getFile();
        this._configuration = dataContext.getConfiguration();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new CsvCreateTableBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        this.validateTable(table);
        return new CsvInsertBuilder(this, table);
    }

    public CsvConfiguration getConfiguration() {
        return this._configuration;
    }

    public File getFile() {
        return this._file;
    }

    private void validateTable(Table table) {
        if (!(table instanceof CsvTable)) {
            throw new IllegalArgumentException("Not a valid CSV table: " + table);
        }
    }

    protected synchronized void writeRow(String[] stringValues, boolean append) {
        this.getCsvWriter(append);
        this._csvWriter.writeNext(stringValues);
    }

    private void getCsvWriter(boolean append) {
        if (this._csvWriter == null || !append) {
            boolean needsLineBreak = CsvUpdateCallback.needsLineBreak(this._file, this._configuration);
            Writer writer = FileHelper.getWriter((File)this._file, (String)this._configuration.getEncoding(), (boolean)append);
            if (needsLineBreak) {
                try {
                    writer.write(10);
                }
                catch (IOException e) {
                    logger.debug("Failed to insert newline", (Throwable)e);
                }
            }
            this._csvWriter = new CSVWriter(writer, this._configuration.getSeparatorChar(), this._configuration.getQuoteChar(), this._configuration.getEscapeChar());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean needsLineBreak(File file, CsvConfiguration configuration) {
        if (!file.exists() || file.length() == 0L) {
            return false;
        }
        try {
            ByteBuffer encodedLineBreak = Charset.forName(configuration.getEncoding()).encode("\n");
            byte[] bytesInLineBreak = new byte[encodedLineBreak.capacity()];
            encodedLineBreak.get(bytesInLineBreak);
            byte[] bytesFromFile = new byte[bytesInLineBreak.length];
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            try {
                FileChannel channel = randomAccessFile.getChannel();
                try {
                    long length = randomAccessFile.length();
                    channel = channel.position(length - (long)bytesInLineBreak.length);
                    channel.read(ByteBuffer.wrap(bytesFromFile));
                }
                finally {
                    channel.close();
                }
            }
            finally {
                randomAccessFile.close();
            }
            return !EqualsBuilder.equals((Object)bytesInLineBreak, (Object)bytesFromFile);
        }
        catch (Exception e) {
            logger.error("Error occurred while checking if file needs linebreak, omitting check", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (this._csvWriter != null) {
            try {
                this._csvWriter.flush();
            }
            catch (IOException e) {
                logger.warn("Failed to flush CSV writer", (Throwable)e);
            }
            try {
                this._csvWriter.close();
            }
            catch (IOException e) {
                logger.error("Failed to close CSV writer", (Throwable)e);
            }
            finally {
                this._csvWriter = null;
            }
        }
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException {
        this.close();
        return super.update(table);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) {
        this.validateTable(table);
        return new CsvTableDropBuilder(this, table);
    }

    protected void dropTable() {
        this.close();
        boolean success = this._file.delete();
        if (!success) {
            throw new MetaModelException("Could not delete (drop) file: " + this._file);
        }
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) {
        this.validateTable(table);
        return new CsvDeleteBuilder(this, table);
    }
}

