/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.csv;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvCreateTableBuilder;
import org.eobjects.metamodel.csv.CsvDataContext;
import org.eobjects.metamodel.csv.CsvDeleteBuilder;
import org.eobjects.metamodel.csv.CsvInsertBuilder;
import org.eobjects.metamodel.csv.CsvTable;
import org.eobjects.metamodel.csv.CsvTableDropBuilder;
import org.eobjects.metamodel.csv.CsvWriter;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.FileResource;
import org.eobjects.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CsvUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(CsvUpdateCallback.class);
    private final CsvConfiguration _configuration;
    private final Resource _resource;
    private Writer _writer;

    public CsvUpdateCallback(CsvDataContext dataContext) {
        super((DataContext)dataContext);
        this._resource = dataContext.getResource();
        this._configuration = dataContext.getConfiguration();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new CsvCreateTableBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        this.validateTable(table);
        return new CsvInsertBuilder(this, table);
    }

    public CsvConfiguration getConfiguration() {
        return this._configuration;
    }

    public Resource getResource() {
        return this._resource;
    }

    private void validateTable(Table table) {
        if (!(table instanceof CsvTable)) {
            throw new IllegalArgumentException("Not a valid CSV table: " + table);
        }
    }

    protected synchronized void writeRow(String[] stringValues, boolean append) {
        CsvWriter _csvWriter = new CsvWriter(this._configuration);
        final String line = _csvWriter.buildLine(stringValues);
        if (this._resource instanceof FileResource) {
            File file = ((FileResource)this._resource).getFile();
            Writer writer = this.getFileWriter(file, append);
            try {
                writer.write(line);
            }
            catch (IOException e) {
                throw new MetaModelException("Failed to write line to file: " + line, (Exception)e);
            }
        } else {
            Action<OutputStream> action = new Action<OutputStream>(){

                public void run(OutputStream out) throws Exception {
                    String encoding = CsvUpdateCallback.this._configuration.getEncoding();
                    OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
                    writer.write(line);
                    writer.flush();
                }
            };
            if (append) {
                this._resource.append((Action)action);
            } else {
                this._resource.write((Action)action);
            }
        }
    }

    private Writer getFileWriter(File file, boolean append) {
        if (this._writer == null || !append) {
            boolean needsLineBreak = CsvUpdateCallback.needsLineBreak(file, this._configuration);
            Writer writer = FileHelper.getWriter((File)file, (String)this._configuration.getEncoding(), (boolean)append);
            if (needsLineBreak) {
                try {
                    writer.write(10);
                }
                catch (IOException e) {
                    logger.debug("Failed to insert newline", (Throwable)e);
                }
            }
            this._writer = writer;
        }
        return this._writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean needsLineBreak(File file, CsvConfiguration configuration) {
        if (!file.exists() || file.length() == 0L) {
            return false;
        }
        try {
            ByteBuffer encodedLineBreak = Charset.forName(configuration.getEncoding()).encode("\n");
            byte[] bytesInLineBreak = new byte[encodedLineBreak.capacity()];
            encodedLineBreak.get(bytesInLineBreak);
            byte[] bytesFromFile = new byte[bytesInLineBreak.length];
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            try {
                FileChannel channel = randomAccessFile.getChannel();
                try {
                    long length = randomAccessFile.length();
                    channel = channel.position(length - (long)bytesInLineBreak.length);
                    channel.read(ByteBuffer.wrap(bytesFromFile));
                }
                finally {
                    channel.close();
                }
            }
            finally {
                randomAccessFile.close();
            }
            return !EqualsBuilder.equals((Object)bytesInLineBreak, (Object)bytesFromFile);
        }
        catch (Exception e) {
            logger.error("Error occurred while checking if file needs linebreak, omitting check", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (this._writer != null) {
            try {
                this._writer.flush();
            }
            catch (IOException e) {
                logger.warn("Failed to flush CSV writer", (Throwable)e);
            }
            try {
                this._writer.close();
            }
            catch (IOException e) {
                logger.error("Failed to close CSV writer", (Throwable)e);
            }
            finally {
                this._writer = null;
            }
        }
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException {
        this.close();
        return super.update(table);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) {
        this.validateTable(table);
        return new CsvTableDropBuilder(this, table);
    }

    protected void dropTable() {
        this.close();
        if (this._resource instanceof FileResource) {
            File file = ((FileResource)this._resource).getFile();
            boolean success = file.delete();
            if (!success) {
                throw new MetaModelException("Could not delete (drop) file: " + file);
            }
        } else {
            this._resource.write((Action)new Action<OutputStream>(){

                public void run(OutputStream arg) throws Exception {
                }
            });
        }
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) {
        this.validateTable(table);
        return new CsvDeleteBuilder(this, table);
    }
}

