/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.poi.POIXMLDocument;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.excel.DefaultSpreadsheetReaderDelegate;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelUpdateCallback;
import org.eobjects.metamodel.excel.SpreadsheetReaderDelegate;
import org.eobjects.metamodel.excel.XlsxSpreadsheetReaderDelegate;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ExcelDataContext.class);
    private final Object WRITE_LOCK = new Object();
    private final File _file;
    private final ExcelConfiguration _configuration;
    private SpreadsheetReaderDelegate _spreadsheetReaderDelegate;

    public ExcelDataContext(File file) {
        this(file, new ExcelConfiguration());
    }

    public ExcelDataContext(File file, ExcelConfiguration configuration) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("ExcelConfiguration cannot be null");
        }
        if (file.exists() && !file.canRead()) {
            throw new IllegalArgumentException("Cannot read from file");
        }
        this._file = file;
        this._configuration = configuration;
    }

    public ExcelConfiguration getConfiguration() {
        return this._configuration;
    }

    public File getFile() {
        return this._file;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._file.getName();
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        DataSet dataSet;
        Ref<InputStream> inputStreamRef = this.getInputStreamRef();
        InputStream inputStream = null;
        try {
            DataSet dataSet2;
            SpreadsheetReaderDelegate delegate = this.getSpreadsheetReaderDelegate(inputStreamRef);
            inputStream = (InputStream)inputStreamRef.get();
            dataSet = dataSet2 = delegate.executeQuery(inputStream, table, columns, maxRows);
        }
        catch (Exception e) {
            try {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MetaModelException("Unexpected exception while materializing main schema table", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return dataSet;
    }

    protected Schema getMainSchema() throws MetaModelException {
        Schema schema;
        if (!this._file.exists()) {
            logger.info("File does not exist, returning empty schema");
            return new MutableSchema(this.getMainSchemaName());
        }
        Ref<InputStream> inputStreamRef = this.getInputStreamRef();
        InputStream inputStream = null;
        try {
            SpreadsheetReaderDelegate delegate = this.getSpreadsheetReaderDelegate(inputStreamRef);
            inputStream = (InputStream)inputStreamRef.get();
            Schema schema2 = delegate.createSchema(inputStream, this.getMainSchemaName());
            assert (this.getMainSchemaName().equals(schema2.getName()));
            schema = schema2;
        }
        catch (Exception e) {
            try {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MetaModelException("Unexpected exception while building main schema", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return schema;
    }

    protected Class<? extends SpreadsheetReaderDelegate> getSpreadsheetReaderDelegateClass() {
        if (this._spreadsheetReaderDelegate != null) {
            return this._spreadsheetReaderDelegate.getClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpreadsheetReaderDelegate getSpreadsheetReaderDelegate(Ref<InputStream> inputStream) throws MetaModelException {
        if (this._spreadsheetReaderDelegate == null) {
            ExcelDataContext excelDataContext = this;
            synchronized (excelDataContext) {
                if (this._spreadsheetReaderDelegate == null) {
                    try {
                        this._spreadsheetReaderDelegate = POIXMLDocument.hasOOXMLHeader((InputStream)((InputStream)inputStream.get())) ? new XlsxSpreadsheetReaderDelegate(this._configuration) : new DefaultSpreadsheetReaderDelegate(this._configuration);
                    }
                    catch (IOException e) {
                        logger.error("Could not identify spreadsheet type, using default", (Throwable)e);
                        this._spreadsheetReaderDelegate = new DefaultSpreadsheetReaderDelegate(this._configuration);
                    }
                }
            }
        }
        return this._spreadsheetReaderDelegate;
    }

    private InputStream getInputStream() throws MetaModelException {
        try {
            InputStream inputStream = new FileInputStream(this._file);
            if (!inputStream.markSupported()) {
                inputStream = new PushbackInputStream(inputStream, 8);
            }
            return inputStream;
        }
        catch (FileNotFoundException e) {
            throw new MetaModelException("Spreadsheet file was not found", (Exception)e);
        }
    }

    private Ref<InputStream> getInputStreamRef() throws MetaModelException {
        LazyRef<InputStream> inputStreamRef = new LazyRef<InputStream>(){

            public InputStream fetch() {
                InputStream inputStream = ExcelDataContext.this.getInputStream();
                return inputStream;
            }
        };
        return inputStreamRef;
    }

    protected void notifyTableCreated() {
        Ref<InputStream> inputStreamRef = this.getInputStreamRef();
        this.getSpreadsheetReaderDelegate(inputStreamRef).notifyTablesModified(inputStreamRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update) {
        ExcelUpdateCallback updateCallback = new ExcelUpdateCallback(this);
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            try {
                update.run((UpdateCallback)updateCallback);
            }
            finally {
                updateCallback.close();
            }
        }
    }
}

