/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelDataContext;
import org.eobjects.metamodel.excel.ExcelInsertBuilder;
import org.eobjects.metamodel.excel.ExcelTableCreationBuilder;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

final class ExcelUpdateCallback
implements UpdateCallback {
    private final ExcelDataContext _dataContext;
    private boolean _sheetsCreated;
    private Workbook _workbook;
    private Short _dateCellFormat;
    private CellStyle _dateCellStyle;

    public ExcelUpdateCallback(ExcelDataContext dataContext) {
        this._dataContext = dataContext;
        this._sheetsCreated = false;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new ExcelTableCreationBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new ExcelInsertBuilder(this, table);
    }

    protected ExcelConfiguration getConfiguration() {
        return this._dataContext.getConfiguration();
    }

    protected void close() {
        if (this._workbook != null) {
            ExcelUtils.writeWorkbook(this._dataContext, this._workbook);
            if (this._sheetsCreated) {
                this._dataContext.notifyTableCreated();
            }
            this._sheetsCreated = false;
            this._workbook = null;
            this._dateCellFormat = null;
            this._dateCellStyle = null;
        }
    }

    private Workbook getWorkbook() {
        if (this._workbook == null) {
            this._workbook = ExcelUtils.readWorkbook(this._dataContext);
        }
        return this._workbook;
    }

    protected Sheet createSheet(String name) {
        Sheet sheet = this.getWorkbook().createSheet(name);
        this._sheetsCreated = true;
        return sheet;
    }

    protected Row createRow(String name) {
        Sheet sheet = this.getWorkbook().getSheet(name);
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        return row;
    }

    public CellStyle createCellStyle() {
        Workbook workbook = this.getWorkbook();
        return workbook.createCellStyle();
    }

    public Font createFont() {
        Workbook workbook = this.getWorkbook();
        return workbook.createFont();
    }

    public short getDateCellFormat() {
        if (this._dateCellFormat == null) {
            Workbook workbook = this.getWorkbook();
            this._dateCellFormat = workbook.getCreationHelper().createDataFormat().getFormat("m/d/yy h:mm");
        }
        return this._dateCellFormat;
    }

    public CellStyle getDateCellStyle() {
        if (this._dateCellStyle == null) {
            this._dateCellStyle = this.createCellStyle();
            this._dateCellStyle.setDataFormat(this.getDateCellFormat());
        }
        return this._dateCellStyle;
    }

    public short getColorIndex(Style.Color color) {
        Workbook workbook = this.getWorkbook();
        if (workbook instanceof HSSFWorkbook) {
            byte b;
            byte g;
            byte r;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            HSSFColor index = palette.findColor(r = this.toRgb(color.getRed()), g = this.toRgb(color.getGreen()), b = this.toRgb(color.getBlue()));
            if (index == null) {
                index = palette.findSimilarColor(r, g, b);
            }
            return index.getIndex();
        }
        throw new IllegalStateException("Unexpected workbook type: " + workbook.getClass());
    }

    private byte toRgb(int i) {
        assert (i >= 0);
        assert (i <= 255);
        if (i > 127) {
            i -= 256;
        }
        return (byte)i;
    }
}

