/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.data.StyleBuilder;
import org.eobjects.metamodel.excel.ExcelDataContext;
import org.eobjects.metamodel.util.DateUtils;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.FormatHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;

final class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static final NumberFormat _numberFormat = FormatHelper.getUiNumberFormat();

    private ExcelUtils() {
    }

    public static XMLReader createXmlReader() {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            return sheetParser;
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public static Workbook readWorkbook(InputStream inputStream) {
        try {
            return WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not open workbook", e);
        }
    }

    public static Workbook readWorkbook(ExcelDataContext dataContext) {
        File file = dataContext.getFile();
        if (!file.exists()) {
            if (file.getName().toLowerCase().endsWith(".xlsx")) {
                return new SXSSFWorkbook();
            }
            return new HSSFWorkbook();
        }
        try {
            return ExcelUtils.readWorkbook(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Could not find workbook file", e);
        }
    }

    public static void writeWorkbook(ExcelDataContext dataContext, Workbook wb) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(dataContext.getFile());
            wb.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{outputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{outputStream});
    }

    public static String getCellValue(Workbook wb, Cell cell) {
        if (cell == null) {
            return null;
        }
        String cellCoordinate = "(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")";
        String result = null;
        if (cell.getCellType() == 2) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("cell({},{}) is a formula. Attempting to evaluate: {}", new Object[]{cell.getRowIndex(), cell.getColumnIndex(), cell.getCellFormula()});
                }
                FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
                cell = evaluator.evaluateInCell(cell);
            }
            catch (RuntimeException e) {
                logger.warn("Exception occurred while evaluating formula at position {}: {}", new Object[]{cellCoordinate, e.getMessage()});
                if (e instanceof FormulaParseException) {
                    logger.error("Parse exception occurred while evaluating cell formula: " + cellCoordinate, (Throwable)e);
                }
                if (e instanceof IllegalArgumentException) {
                    logger.error("Illegal formula argument occurred while evaluating cell formula: " + cellCoordinate, (Throwable)e);
                }
                logger.error("Unexpected exception occurred while evaluating cell formula: " + cellCoordinate, (Throwable)e);
            }
        }
        switch (cell.getCellType()) {
            case 3: {
                result = null;
                break;
            }
            case 4: {
                result = Boolean.toString(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                try {
                    byte errorCode = cell.getErrorCellValue();
                    FormulaError formulaError = FormulaError.forInt((byte)errorCode);
                    result = formulaError.getString();
                    break;
                }
                catch (RuntimeException e) {
                    logger.debug("Getting error code for {} failed!: {}", (Object)cellCoordinate, (Object)e.getMessage());
                    if (cell instanceof XSSFCell) {
                        String value;
                        result = value = ((XSSFCell)cell).getErrorCellString();
                        break;
                    }
                    logger.error("Couldn't handle unexpected error scenario in cell: " + cellCoordinate, (Throwable)e);
                    throw e;
                }
            }
            case 2: {
                result = cell.getCellFormula();
                break;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    if (date == null) break;
                    date = DateUtils.get((Date)date);
                    result = DateUtils.createDateFormat().format(date);
                    break;
                }
                result = _numberFormat.format(cell.getNumericCellValue());
                break;
            }
            case 1: {
                result = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown cell type: " + cell.getCellType());
            }
        }
        logger.debug("cell {} resolved to value: {}", (Object)cellCoordinate, (Object)result);
        return result;
    }

    public static Style getCellStyle(Workbook workbook, Cell cell) {
        XSSFColor color;
        if (cell == null) {
            return Style.NO_STYLE;
        }
        CellStyle cellStyle = cell.getCellStyle();
        short fontIndex = cellStyle.getFontIndex();
        Font font = workbook.getFontAt(fontIndex);
        StyleBuilder styleBuilder = new StyleBuilder();
        if (font.getBoldweight() >= 700) {
            styleBuilder.bold();
        }
        if (font.getItalic()) {
            styleBuilder.italic();
        }
        if (font.getUnderline() != FontUnderline.NONE.getByteValue()) {
            styleBuilder.underline();
        }
        Font stdFont = workbook.getFontAt((short)0);
        short fontSize = font.getFontHeightInPoints();
        if (stdFont.getFontHeightInPoints() != fontSize) {
            styleBuilder.fontSize((int)fontSize, Style.SizeUnit.PT);
        }
        short colorIndex = font.getColor();
        if (font instanceof HSSFFont) {
            HSSFWorkbook wb;
            if (colorIndex != Short.MAX_VALUE && (color = (wb = (HSSFWorkbook)workbook).getCustomPalette().getColor(colorIndex)) != null) {
                short[] triplet = color.getTriplet();
                styleBuilder.foreground(triplet);
            }
        } else if (font instanceof XSSFFont) {
            String argbHex;
            XSSFFont xssfFont = (XSSFFont)font;
            color = xssfFont.getXSSFColor();
            if (color != null && (argbHex = color.getARGBHex()) != null) {
                styleBuilder.foreground(argbHex.substring(2));
            }
        } else {
            throw new IllegalStateException("Unexpected font type: " + (font == null ? "null" : font.getClass()) + ")");
        }
        if (cellStyle.getFillPattern() == 1) {
            Color color2 = cellStyle.getFillForegroundColorColor();
            if (color2 instanceof HSSFColor) {
                short[] triplet = ((HSSFColor)color2).getTriplet();
                if (triplet != null) {
                    styleBuilder.background(triplet);
                }
            } else if (color2 instanceof XSSFColor) {
                String argb = ((XSSFColor)color2).getARGBHex();
                if (argb != null) {
                    styleBuilder.background(argb.substring(2));
                }
            } else {
                throw new IllegalStateException("Unexpected color type: " + (color2 == null ? "null" : color2.getClass()) + ")");
            }
        }
        switch (cellStyle.getAlignment()) {
            case 1: {
                styleBuilder.leftAligned();
                break;
            }
            case 3: {
                styleBuilder.rightAligned();
                break;
            }
            case 2: {
                styleBuilder.centerAligned();
                break;
            }
            case 5: {
                styleBuilder.justifyAligned();
            }
        }
        return styleBuilder.create();
    }
}

