/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;

final class XlsDataSet
extends AbstractDataSet {
    private final SelectItem[] _selectItems;
    private final Column[] _columns;
    private final Iterator<org.apache.poi.ss.usermodel.Row> _rowIterator;
    private final Workbook _workbook;
    private volatile org.apache.poi.ss.usermodel.Row _row;
    private volatile boolean _closed;

    public XlsDataSet(Column[] columns, Workbook workbook, Iterator<org.apache.poi.ss.usermodel.Row> rowIterator) {
        this._columns = columns;
        this._workbook = workbook;
        this._rowIterator = rowIterator;
        this._closed = false;
        this._selectItems = new SelectItem[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            this._selectItems[i] = new SelectItem(column);
        }
    }

    public SelectItem[] getSelectItems() {
        return this._selectItems;
    }

    public boolean next() {
        if (this._rowIterator.hasNext()) {
            this._row = this._rowIterator.next();
            return true;
        }
        this._row = null;
        this._closed = true;
        return false;
    }

    public Row getRow() {
        if (this._closed) {
            return null;
        }
        Object[] values = new String[this._columns.length];
        Style[] styles = new Style[this._columns.length];
        if (this._row != null) {
            for (int j = 0; j < this._columns.length; ++j) {
                int columnNumber = this._columns[j].getColumnNumber();
                Cell cell = this._row.getCell(columnNumber);
                values[j] = ExcelUtils.getCellValue(this._workbook, cell);
                styles[j] = ExcelUtils.getCellStyle(this._workbook, cell);
            }
        }
        return new DefaultRow(this._selectItems, values, styles);
    }
}

