/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.data.StyleBuilder;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.XlsxRowCallback;
import org.eobjects.metamodel.excel.XlsxStopParsingException;
import org.eobjects.metamodel.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class XlsxSheetToRowsHandler
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(XlsxSheetToRowsHandler.class);
    private final XlsxRowCallback _callback;
    private final ExcelConfiguration _configuration;
    private final StylesTable _stylesTable;
    private final SharedStringsTable _sharedStringTable;
    private int _rowNumber;
    private final List<String> _rowValues;
    private final List<Style> _styles;
    private final StringBuilder _value;
    private final StyleBuilder _style;
    private boolean _inCell;
    private boolean _inFormula;
    private int _columnNumber;
    private XssfDataType _dataType;
    private int _formatIndex;
    private String _formatString;

    public XlsxSheetToRowsHandler(XlsxRowCallback callback, XSSFReader xssfReader, ExcelConfiguration configuration) throws Exception {
        this._callback = callback;
        this._configuration = configuration;
        this._sharedStringTable = xssfReader.getSharedStringsTable();
        this._stylesTable = xssfReader.getStylesTable();
        this._value = new StringBuilder();
        this._style = new StyleBuilder();
        this._rowValues = new ArrayList<String>();
        this._styles = new ArrayList<Style>();
        this._rowNumber = -1;
        this._inCell = false;
        this._inFormula = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("row".equals(qName)) {
            int rowNumber = Integer.parseInt(attributes.getValue("r"));
            --rowNumber;
            if (this._configuration.isSkipEmptyLines()) {
                ++this._rowNumber;
            } else {
                while (this._rowNumber + 1 < rowNumber) {
                    ++this._rowNumber;
                    List<String> emptyValues = Collections.emptyList();
                    List<Style> emptyStyles = Collections.emptyList();
                    this._callback.row(this._rowNumber, emptyValues, emptyStyles);
                }
                this._rowNumber = rowNumber;
            }
        } else if ("c".equals(qName)) {
            this._inCell = true;
            String r = attributes.getValue("r");
            int firstDigit = -1;
            for (int c = 0; c < r.length(); ++c) {
                if (!Character.isDigit(r.charAt(c))) continue;
                firstDigit = c;
                break;
            }
            this._columnNumber = this.nameToColumn(r.substring(0, firstDigit));
            this._dataType = XssfDataType.NUMBER;
            this._formatIndex = -1;
            this._formatString = null;
            String cellType = attributes.getValue("t");
            if ("b".equals(cellType)) {
                this._dataType = XssfDataType.BOOL;
            } else if ("e".equals(cellType)) {
                this._dataType = XssfDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this._dataType = XssfDataType.INLINESTR;
            } else if ("s".equals(cellType)) {
                this._dataType = XssfDataType.SSTINDEX;
            } else if ("str".equals(cellType)) {
                this._dataType = XssfDataType.FORMULA;
            }
            String cellStyleStr = attributes.getValue("s");
            if (cellStyleStr != null) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                XSSFCellStyle style = this._stylesTable.getStyleAt(styleIndex);
                this.configureStyle(style);
                if (this._dataType == XssfDataType.NUMBER) {
                    this._formatIndex = style.getDataFormat();
                    this._formatString = style.getDataFormatString();
                    if (this._formatString == null) {
                        this._formatString = BuiltinFormats.getBuiltinFormat((int)this._formatIndex);
                    }
                }
            }
        } else if (this._inCell && "f".equals(qName)) {
            this._inFormula = true;
        }
    }

    private void configureStyle(XSSFCellStyle style) {
        String argbHex;
        XSSFColor fontColor;
        XSSFColor fillForegroundXSSFColor;
        String argb;
        XSSFFont font = style.getFont();
        if (font.getBold()) {
            this._style.bold();
        }
        if (font.getItalic()) {
            this._style.italic();
        }
        if (font.getUnderline() != FontUnderline.NONE.getByteValue()) {
            this._style.underline();
        }
        if (style.getFillPatternEnum() == FillPatternType.SOLID_FOREGROUND && (argb = (fillForegroundXSSFColor = style.getFillForegroundXSSFColor()).getARGBHex()) != null) {
            this._style.background(argb.substring(2));
        }
        XSSFFont stdFont = this._stylesTable.getStyleAt(0).getFont();
        short fontHeight = style.getFont().getFontHeightInPoints();
        if (stdFont.getFontHeightInPoints() != fontHeight) {
            this._style.fontSize((int)fontHeight, Style.SizeUnit.PT);
        }
        if ((fontColor = style.getFont().getXSSFColor()) != null && (argbHex = fontColor.getARGBHex()) != null) {
            this._style.foreground(argbHex.substring(2));
        }
        switch (style.getAlignmentEnum()) {
            case LEFT: {
                this._style.leftAligned();
                break;
            }
            case RIGHT: {
                this._style.rightAligned();
                break;
            }
            case CENTER: {
                this._style.centerAligned();
                break;
            }
            case JUSTIFY: {
                this._style.justifyAligned();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("row".equals(qName)) {
            boolean next = this._callback.row(this._rowNumber, this._rowValues, this._styles);
            if (!next) {
                throw new XlsxStopParsingException();
            }
            this._rowValues.clear();
            this._styles.clear();
        } else if ("c".equals(qName)) {
            this._inCell = false;
            while (this._rowValues.size() < this._columnNumber) {
                this._rowValues.add(null);
                this._styles.add(Style.NO_STYLE);
            }
            this._rowValues.add(this.createValue());
            this._styles.add(this._style.create());
            this._value.setLength(0);
            this._style.reset();
        } else if (this._inFormula && "f".equals(qName)) {
            this._inFormula = false;
        }
    }

    private String createValue() {
        switch (this._dataType) {
            case BOOL: {
                char first = this._value.charAt(0);
                return first == '0' ? "false" : "true";
            }
            case ERROR: {
                logger.warn("Error-cell occurred: {}", (Object)this._value);
                return this._value.toString();
            }
            case FORMULA: {
                return this._value.toString();
            }
            case INLINESTR: {
                XSSFRichTextString rtsi = new XSSFRichTextString(this._value.toString());
                return rtsi.toString();
            }
            case SSTINDEX: {
                String sstIndex = this._value.toString();
                int idx = Integer.parseInt(sstIndex);
                XSSFRichTextString rtss = new XSSFRichTextString(this._sharedStringTable.getEntryAt(idx));
                return rtss.toString();
            }
            case NUMBER: {
                String numberString = this._value.toString();
                if (this._formatString != null) {
                    DataFormatter formatter = this.getDataFormatter();
                    if (HSSFDateUtil.isADateFormat((int)this._formatIndex, (String)this._formatString)) {
                        Date date = DateUtil.getJavaDate((double)Double.parseDouble(numberString));
                        date = DateUtils.get((Date)date);
                        return DateUtils.createDateFormat().format(date);
                    }
                    return formatter.formatRawCellContents(Double.parseDouble(numberString), this._formatIndex, this._formatString);
                }
                if (numberString.endsWith(".0")) {
                    return numberString.substring(0, numberString.length() - 2);
                }
                return numberString;
            }
        }
        logger.error("Unsupported data type: {}", (Object)this._dataType);
        return "";
    }

    private DataFormatter getDataFormatter() {
        return new DataFormatter();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._inCell && !this._inFormula) {
            this._value.append(ch, start, length);
        }
    }

    private int nameToColumn(String name) {
        int column = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            column = (column + 1) * 26 + c - 65;
        }
        return column;
    }

    private static enum XssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

