/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.delete.AbstractRowDeletionBuilder;
import org.eobjects.metamodel.excel.ExcelDataContext;
import org.eobjects.metamodel.excel.ExcelUpdateCallback;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

final class ExcelDeleteBuilder
extends AbstractRowDeletionBuilder {
    private final ExcelUpdateCallback _updateCallback;

    public ExcelDeleteBuilder(ExcelUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        this._updateCallback.close();
        ExcelDataContext dataContext = this._updateCallback.getDataContext();
        Workbook workbook = ExcelUtils.readWorkbook(dataContext);
        String tableName = this.getTable().getName();
        SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])this.getTable().getColumns());
        Sheet sheet = workbook.getSheet(tableName);
        Iterator<org.apache.poi.ss.usermodel.Row> rowIterator = ExcelUtils.getRowIterator(sheet, this._updateCallback.getConfiguration(), true);
        ArrayList<org.apache.poi.ss.usermodel.Row> rowsToDelete = new ArrayList<org.apache.poi.ss.usermodel.Row>();
        while (rowIterator.hasNext()) {
            org.apache.poi.ss.usermodel.Row excelRow = rowIterator.next();
            DefaultRow defaultRow = ExcelUtils.createRow(workbook, excelRow, selectItems);
            if (!this.deleteRow((Row)defaultRow)) continue;
            rowsToDelete.add(excelRow);
        }
        Collections.reverse(rowsToDelete);
        for (org.apache.poi.ss.usermodel.Row row : rowsToDelete) {
            sheet.removeRow(row);
        }
        ExcelUtils.writeWorkbook(dataContext, workbook);
    }
}

