/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.AbstractTableCreationBuilder;
import org.eobjects.metamodel.excel.ExcelUpdateCallback;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

final class ExcelTableCreationBuilder
extends AbstractTableCreationBuilder<ExcelUpdateCallback> {
    public ExcelTableCreationBuilder(ExcelUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() {
        ExcelUpdateCallback updateCallback = (ExcelUpdateCallback)this.getUpdateCallback();
        MutableTable table = this.getTable();
        Sheet sheet = updateCallback.createSheet(table.getName());
        int lineNumber = updateCallback.getConfiguration().getColumnNameLineNumber();
        if (lineNumber != -1) {
            Row row = sheet.createRow(lineNumber);
            Column[] columns = table.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                int columnNumber = column.getColumnNumber();
                row.createCell(columnNumber).setCellValue(column.getName());
            }
        }
        MutableSchema schema = (MutableSchema)table.getSchema();
        schema.addTable(table);
        return table;
    }
}

