/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelDataContext;
import org.eobjects.metamodel.excel.ExcelDeleteBuilder;
import org.eobjects.metamodel.excel.ExcelDropTableBuilder;
import org.eobjects.metamodel.excel.ExcelInsertBuilder;
import org.eobjects.metamodel.excel.ExcelTableCreationBuilder;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

final class ExcelUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private final ExcelDataContext _dataContext;
    private final ExcelConfiguration _configuration;
    private boolean _sheetsModified = false;
    private Workbook _workbook;
    private Short _dateCellFormat;
    private CellStyle _dateCellStyle;

    public ExcelUpdateCallback(ExcelDataContext dataContext) {
        super((DataContext)dataContext);
        this._configuration = dataContext.getConfiguration();
        this._dataContext = dataContext;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new ExcelTableCreationBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new ExcelInsertBuilder(this, table);
    }

    protected ExcelConfiguration getConfiguration() {
        return this._configuration;
    }

    public ExcelDataContext getDataContext() {
        return this._dataContext;
    }

    protected void close() {
        if (this._workbook != null) {
            ExcelUtils.writeWorkbook(this._dataContext, this._workbook);
            if (this._sheetsModified) {
                this._dataContext.notifyTablesModified();
            }
            this._sheetsModified = false;
            this._workbook = null;
            this._dateCellFormat = null;
            this._dateCellStyle = null;
        }
    }

    protected Workbook getWorkbook() {
        if (this._workbook == null) {
            this._workbook = ExcelUtils.readWorkbook(this._dataContext);
            if (this._workbook instanceof XSSFWorkbook) {
                this._workbook = new SXSSFWorkbook((XSSFWorkbook)this._workbook);
            }
        }
        return this._workbook;
    }

    protected Sheet createSheet(String name) {
        Sheet sheet = this.getWorkbook().createSheet(name);
        this._sheetsModified = true;
        return sheet;
    }

    protected void removeSheet(String name) {
        int index = this.getWorkbook().getSheetIndex(name);
        if (index != -1) {
            this.getWorkbook().removeSheetAt(index);
            this._sheetsModified = true;
        }
    }

    protected Row createRow(String name) {
        Sheet sheet = this.getWorkbook().getSheet(name);
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        return row;
    }

    public CellStyle createCellStyle() {
        Workbook workbook = this.getWorkbook();
        return workbook.createCellStyle();
    }

    public Font createFont() {
        Workbook workbook = this.getWorkbook();
        return workbook.createFont();
    }

    protected Sheet getSheet(String name) {
        return this.getWorkbook().getSheet(name);
    }

    public short getDateCellFormat() {
        if (this._dateCellFormat == null) {
            Workbook workbook = this.getWorkbook();
            this._dateCellFormat = workbook.getCreationHelper().createDataFormat().getFormat("m/d/yy h:mm");
        }
        return this._dateCellFormat;
    }

    public CellStyle getDateCellStyle() {
        if (this._dateCellStyle == null) {
            this._dateCellStyle = this.createCellStyle();
            this._dateCellStyle.setDataFormat(this.getDateCellFormat());
        }
        return this._dateCellStyle;
    }

    public short getColorIndex(Style.Color color) {
        Workbook workbook = this.getWorkbook();
        if (workbook instanceof HSSFWorkbook) {
            byte b;
            byte g;
            byte r;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            HSSFColor index = palette.findColor(r = this.toRgb(color.getRed()), g = this.toRgb(color.getGreen()), b = this.toRgb(color.getBlue()));
            if (index == null) {
                index = palette.findSimilarColor(r, g, b);
            }
            return index.getIndex();
        }
        throw new IllegalStateException("Unexpected workbook type: " + workbook.getClass());
    }

    private byte toRgb(int i) {
        assert (i >= 0);
        assert (i <= 255);
        if (i > 127) {
            i -= 256;
        }
        return (byte)i;
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws UnsupportedOperationException {
        return new ExcelDropTableBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        boolean xlsxFile = ExcelUtils.isXlsxFile(this._dataContext.getFile());
        return !xlsxFile;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws UnsupportedOperationException {
        return new ExcelDeleteBuilder(this, table);
    }
}

