/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.cactoos.Output;
import org.cactoos.Text;
import org.cactoos.io.OutputTo;
import org.cactoos.list.ListOf;
import org.cactoos.text.FormattedText;
import org.cactoos.text.UncheckedText;
import org.eolang.maven.Save;
import org.eolang.maven.TargetSpy;
import org.eolang.parser.Spy;
import org.eolang.parser.Xsline;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="compile", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class CompileMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources")
    private File generatedDir;
    @Parameter(required=true, defaultValue="${project.build.directory}/eo")
    private File targetDir;
    @Parameter
    private boolean addSourcesRoot = true;
    @Parameter
    private boolean addTestSourcesRoot;
    @Parameter(property="compiler")
    private String compiler;

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.generatedDir.mkdirs()) {
            Logger.info((Object)((Object)this), (String)"Gen directory created: %s", (Object[])new Object[]{this.generatedDir});
        }
        Path dir = this.targetDir.toPath().resolve("03-optimize");
        if (this.compiler == null) {
            try {
                Files.walk(dir, new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).forEach(this::compile);
            }
            catch (IOException ex) {
                throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Can't list EO files in %s", new Object[]{dir})).asString(), (Throwable)ex);
            }
        } else {
            this.compileAlternative(dir);
        }
        if (this.addSourcesRoot) {
            this.project.addCompileSourceRoot(this.generatedDir.getAbsolutePath());
        }
        if (this.addTestSourcesRoot) {
            this.project.addTestCompileSourceRoot(this.generatedDir.getAbsolutePath());
        }
        Logger.info((Object)((Object)this), (String)"Directory added to sources: %s", (Object[])new Object[]{this.generatedDir});
    }

    private void compile(Path file) {
        Path temp = this.targetDir.toPath().resolve("05-compile");
        Path pre = this.targetDir.toPath().resolve("04-pre");
        try {
            XMLDocument input = new XMLDocument(file);
            String name = (String)input.xpath("/program/@name").get(0);
            Path target = CompileMojo.resolve(temp, name);
            if (Files.exists(target, new LinkOption[0])) {
                Logger.info((Object)((Object)this), (String)"%s already compiled to %s with the original compiler", (Object[])new Object[]{file, this.generatedDir});
            } else {
                new Xsline((XML)input, (Output)new OutputTo(target), (Spy)new TargetSpy(CompileMojo.resolve(pre, name)), (Iterable)new ListOf((Object[])new String[]{"org/eolang/maven/pre/classes.xsl", "org/eolang/maven/pre/junit.xsl", "org/eolang/maven/pre/attrs.xsl", "org/eolang/maven/pre/varargs.xsl", "org/eolang/maven/pre/arrays.xsl", "org/eolang/maven/pre/data.xsl", "org/eolang/maven/pre/to-java.xsl"})).pass();
                XML after = this.noErrors((XML)new XMLDocument(target), name);
                for (XML java : after.nodes("//class[java and not(@atom)]")) {
                    new Save((String)java.xpath("java/text()").get(0), this.generatedDir.toPath().resolve(Paths.get(String.format("%s.java", ((String)java.xpath("@java-name").get(0)).replace(".", "/")), new String[0]))).save();
                }
                Logger.info((Object)((Object)this), (String)"%s compiled to %s with the original compiler", (Object[])new Object[]{file, this.generatedDir});
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't pass %s into %s", file, this.generatedDir), ex);
        }
    }

    private void compileAlternative(Path dir) throws MojoFailureException {
        try {
            Path[] paths;
            Class<?> clss = Class.forName(this.compiler);
            Constructor<?> constructor = clss.getDeclaredConstructor(File.class);
            Object transpiler = constructor.newInstance(this.generatedDir);
            Method method = Arrays.stream(transpiler.getClass().getMethods()).filter(mthd -> mthd.getName().equals("compile")).findFirst().get();
            method.setAccessible(true);
            for (Path path : paths = (Path[])Files.walk(dir, new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).toArray(Path[]::new)) {
                method.invoke(transpiler, path);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Can't load an alternative's compiler class %s.", new Object[]{this.compiler})).asString(), (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Error has occurred in an alternative's compiler method(s): %s.", new Object[]{this.compiler})).asString(), (Throwable)exception);
        }
        catch (NoSuchMethodException exception) {
            throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Can't load an alternative's compiler method(s) in class %s.", new Object[]{this.compiler})).asString(), (Throwable)exception);
        }
        catch (InstantiationException exception) {
            throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Can't instantiate an alternative's compiler class %s.", new Object[]{this.compiler})).asString(), (Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Not permitted to access class %s (or its method(s)) through reflection.", new Object[]{this.compiler})).asString(), (Throwable)exception);
        }
        catch (IOException exception) {
            throw new MojoFailureException(new UncheckedText((Text)new FormattedText("Can't list EO files in the %s directory.", new Object[]{dir})).asString(), (Throwable)exception);
        }
    }

    private static Path resolve(Path dir, String name) {
        Path path = dir.resolve(String.format("%s.xml", name));
        if (path.toFile().getParentFile().mkdirs()) {
            Logger.info(CompileMojo.class, (String)"%s directory created", (Object[])new Object[]{dir});
        }
        return path;
    }

    private XML noErrors(XML xml, String name) {
        List errors = xml.nodes("/program/errors/error");
        for (XML error : errors) {
            Logger.error((Object)((Object)this), (String)"[%s:%s] %s (%s:%s)", (Object[])new Object[]{name, error.xpath("@line").get(0), error.xpath("text()").get(0), error.xpath("@check").get(0), error.xpath("@step").get(0)});
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException(String.format("There are %d errors in %s, see log above", errors.size(), name));
        }
        return xml;
    }
}

