/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cactoos.set.SetOf;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="prepack", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public final class PrepackMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/classes")
    private File classesDir;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources")
    private File generatedDir;
    @Parameter
    private Set<String> includes = new SetOf((Object[])new String[]{"**/*.class"});

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        try {
            Files.walk(this.classesDir.toPath(), new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).filter(file -> this.includes.stream().anyMatch(glob -> PrepackMojo.matcher(glob).matches((Path)file))).forEach(this::delete);
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Can't list EO files in %s", this.classesDir), (Throwable)ex);
        }
    }

    private static PathMatcher matcher(String text) {
        return FileSystems.getDefault().getPathMatcher(String.format("glob:%s", text));
    }

    private void delete(Path file) {
        String name = file.toString().substring(this.classesDir.toString().length() + 1);
        Path java = this.generatedDir.toPath().resolve(name.replaceAll("\\.class$", ".java"));
        if (Files.exists(java, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            Logger.info((Object)((Object)this), (String)"%s deleted since %s is present", (Object[])new Object[]{file, java});
        }
    }
}

