/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.impl.StaticLoggerBinder;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="resolve", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class ResolveMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private BuildPluginManager manager;
    @Parameter(required=true, defaultValue="${project.build.directory}/eo")
    private File targetDir;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;

    public void execute() throws MojoFailureException, MojoExecutionException {
        Collection deps;
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        Path dir = this.targetDir.toPath().resolve("03-optimize");
        try {
            deps = Files.walk(dir, new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).map(this::artifacts).flatMap(Collection::stream).map(x$0 -> new Wrap((Dependency)x$0)).sorted().distinct().map(Wrap::dep).collect(Collectors.toList());
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Can't list XML files in %s", dir), (Throwable)ex);
        }
        Logger.info((Object)((Object)this), (String)"Found %d dependencie(s)", (Object[])new Object[]{deps.size()});
        for (Dependency dep : deps) {
            this.unpack(dep);
        }
    }

    private void unpack(Dependency dep) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin")), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifactItems", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)dep.getGroupId()), MojoExecutor.element((String)"artifactId", (String)dep.getArtifactId()), MojoExecutor.element((String)"version", (String)dep.getVersion()), MojoExecutor.element((String)"overWrite", (String)"true"), MojoExecutor.element((String)"outputDirectory", (String)this.outputDirectory.toString())})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.manager));
        Logger.info((Object)((Object)this), (String)"%s:%s:%s unpacked to %s", (Object[])new Object[]{dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), this.outputDirectory});
    }

    private Collection<Dependency> artifacts(Path file) {
        LinkedList<Dependency> artifacts = new LinkedList<Dependency>();
        try {
            String xpath = "//meta[head='rt' and part[1]='jvm']/part[2]/text()";
            for (String coords : new XMLDocument(file).xpath("//meta[head='rt' and part[1]='jvm']/part[2]/text()")) {
                String[] parts = coords.split(":");
                Dependency dep = new Dependency();
                dep.setGroupId(parts[0]);
                dep.setArtifactId(parts[1]);
                dep.setVersion(parts[2]);
                dep.setClassifier("");
                dep.setType("jar");
                dep.setScope("compile");
                artifacts.add(dep);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't pull %s into %s", file, this.targetDir), ex);
        }
        return artifacts;
    }

    private static final class Wrap
    implements Comparable<Wrap> {
        private final Dependency dependency;

        private Wrap(Dependency dep) {
            this.dependency = dep;
        }

        public Dependency dep() {
            return this.dependency;
        }

        @Override
        public int compareTo(Wrap wrap) {
            return Wrap.toStr(this.dependency).compareTo(Wrap.toStr(wrap.dependency));
        }

        public boolean equals(Object wrap) {
            return Wrap.toStr(this.dependency).equals(Wrap.toStr(((Wrap)Wrap.class.cast((Object)wrap)).dependency));
        }

        public int hashCode() {
            return Wrap.toStr(this.dependency).hashCode();
        }

        private static String toStr(Dependency dep) {
            return String.format("%s:%s", dep.getGroupId(), dep.getArtifactId());
        }
    }
}

